/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.proxy;

import me.desht.modularrouters.block.tile.ICamouflageable;
import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.client.AreaShowManager;
import me.desht.modularrouters.client.ItemColours;
import me.desht.modularrouters.client.ModelBakeEventHandler;
import me.desht.modularrouters.client.fx.FXSparkle;
import me.desht.modularrouters.client.fx.RenderListener;
import me.desht.modularrouters.client.gui.GuiItemRouter;
import me.desht.modularrouters.client.gui.MouseOverHelp;
import me.desht.modularrouters.core.RegistrarMR;
import me.desht.modularrouters.proxy.IProxy;
import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IThreadListener;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;

public class ClientProxy
implements IProxy {
    private static boolean noclipEnabled = false;
    private static boolean corruptSparkle = false;

    @Override
    public void preInit() {
        MinecraftForge.EVENT_BUS.register(ModelBakeEventHandler.class);
        MinecraftForge.EVENT_BUS.register((Object)AreaShowManager.getInstance());
        MinecraftForge.EVENT_BUS.register(MouseOverHelp.class);
    }

    @Override
    public void init() {
        MinecraftForge.EVENT_BUS.register(RenderListener.class);
        this.registerBlockColors();
    }

    @Override
    public void postInit() {
        Minecraft.func_71410_x().getItemColors().func_186730_a((IItemColor)new ItemColours.ModuleColour(), new Item[]{RegistrarMR.MODULE});
        Minecraft.func_71410_x().getItemColors().func_186730_a((IItemColor)new ItemColours.UpgradeColour(), new Item[]{RegistrarMR.UPGRADE});
    }

    @Override
    public void setSparkleFXNoClip(boolean noclip) {
        noclipEnabled = noclip;
    }

    @Override
    public void setSparkleFXCorrupt(boolean corrupt) {
        corruptSparkle = corrupt;
    }

    @Override
    public void sparkleFX(World world, double x, double y, double z, float r, float g, float b, float size, int m, boolean fake) {
        if (!this.doParticle(world) && !fake) {
            return;
        }
        FXSparkle sparkle = new FXSparkle(world, x, y, z, size, r, g, b, m);
        sparkle.fake = sparkle.noClip = fake;
        if (noclipEnabled) {
            sparkle.noClip = true;
        }
        if (corruptSparkle) {
            sparkle.corrupt = true;
        }
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)sparkle);
    }

    private boolean doParticle(World world) {
        if (!world.field_72995_K) {
            return false;
        }
        float chance = 1.0f;
        if (Minecraft.func_71410_x().field_71474_y.field_74362_aa == 1) {
            chance = 0.6f;
        } else if (Minecraft.func_71410_x().field_71474_y.field_74362_aa == 2) {
            chance = 0.2f;
        }
        return chance == 1.0f || Math.random() < (double)chance;
    }

    @Override
    public World theClientWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    @Override
    public IThreadListener threadListener() {
        return Minecraft.func_71410_x();
    }

    @Override
    public TileEntityItemRouter getOpenItemRouter() {
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiItemRouter) {
            return ((GuiItemRouter)Minecraft.func_71410_x().field_71462_r).router;
        }
        return null;
    }

    private void registerBlockColors() {
        Minecraft.func_71410_x().func_184125_al().func_186722_a((state, worldIn, pos, tintIndex) -> {
            if (pos == null) {
                return -1;
            }
            TileEntity te = MiscUtil.getTileEntitySafely(worldIn, pos);
            if (te instanceof ICamouflageable && ((ICamouflageable)te).getCamouflage() != null) {
                return Minecraft.func_71410_x().func_184125_al().func_186724_a(((ICamouflageable)te).getCamouflage(), (IBlockAccess)te.func_145831_w(), pos, tintIndex);
            }
            return 0xFFFFFF;
        }, new Block[]{RegistrarMR.ITEM_ROUTER, RegistrarMR.TEMPLATE_FRAME});
    }

    @Override
    public EntityPlayer getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }
}

