/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.filter;

import com.google.common.base.Joiner;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.List;
import me.desht.modularrouters.client.gui.filter.Buttons;
import me.desht.modularrouters.client.gui.filter.GuiFilterScreen;
import me.desht.modularrouters.client.gui.widgets.button.BackButton;
import me.desht.modularrouters.client.gui.widgets.textfield.IntegerTextField;
import me.desht.modularrouters.client.gui.widgets.textfield.TextFieldManager;
import me.desht.modularrouters.item.smartfilter.InspectionFilter;
import me.desht.modularrouters.logic.filter.matchers.InspectionMatcher;
import me.desht.modularrouters.network.FilterSettingsMessage;
import me.desht.modularrouters.network.PacketHandler;
import me.desht.modularrouters.util.MFLocator;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;

public class GuiInspectionFilter
extends GuiFilterScreen {
    private static final ResourceLocation textureLocation = new ResourceLocation("modularrouters", "textures/gui/inspectionfilter.png");
    private static final int GUI_WIDTH = 176;
    private static final int GUI_HEIGHT = 191;
    private int xPos;
    private int yPos;
    private InspectionMatcher.ComparisonList comparisonList;
    private IntegerTextField valueTextField;
    private InspectionMatcher.InspectionSubject currentSubject = InspectionMatcher.InspectionSubject.NONE;
    private InspectionMatcher.InspectionOp currentOp = InspectionMatcher.InspectionOp.NONE;
    private List<Buttons.DeleteButton> deleteButtons = new ArrayList<Buttons.DeleteButton>();
    private Button matchButton;

    public GuiInspectionFilter(ItemStack filterStack, MFLocator locator) {
        super(filterStack, locator);
        this.comparisonList = InspectionFilter.getComparisonList(filterStack);
    }

    public void init() {
        super.init();
        this.xPos = (this.width - 176) / 2;
        this.yPos = (this.height - 191) / 2;
        if (this.locator.filterSlot >= 0) {
            this.addButton((Widget)new BackButton(this.xPos - 12, this.yPos, button -> this.closeGUI()));
        }
        this.addButton((Widget)new Button(this.xPos + 8, this.yPos + 22, 90, 20, I18n.func_135052_a((String)("guiText.label.inspectionSubject." + (Object)((Object)this.currentSubject)), (Object[])new Object[0]), button -> {
            this.currentSubject = this.currentSubject.cycle(Screen.hasShiftDown() ? -1 : 1);
            button.setMessage(I18n.func_135052_a((String)("guiText.label.inspectionSubject." + (Object)((Object)this.currentSubject)), (Object[])new Object[0]));
        }));
        this.addButton((Widget)new Button(this.xPos + 95, this.yPos + 22, 20, 20, I18n.func_135052_a((String)("guiText.label.inspectionOp." + (Object)((Object)this.currentOp)), (Object[])new Object[0]), button -> {
            this.currentOp = this.currentOp.cycle(Screen.hasShiftDown() ? -1 : 1);
            button.setMessage(I18n.func_135052_a((String)("guiText.label.inspectionOp." + (Object)((Object)this.currentOp)), (Object[])new Object[0]));
        }));
        this.addButton((Widget)new Buttons.AddButton(this.xPos + 152, this.yPos + 23, button -> this.addEntry()));
        this.matchButton = new Button(this.xPos + 8, this.yPos + 167, 60, 20, I18n.func_135052_a((String)("guiText.label.matchAll." + this.comparisonList.isMatchAll()), (Object[])new Object[0]), button -> {
            CompoundNBT ext = new CompoundNBT();
            ext.func_74757_a("MatchAll", !this.comparisonList.isMatchAll());
            PacketHandler.NETWORK.sendToServer((Object)new FilterSettingsMessage(FilterSettingsMessage.Operation.ANY_ALL_FLAG, this.locator, ext));
        });
        this.addButton((Widget)this.matchButton);
        for (int i = 0; i < 6; ++i) {
            Buttons.DeleteButton b = new Buttons.DeleteButton(this.xPos + 8, this.yPos + 52 + i * 19, i, button -> this.sendRemovePosMessage(((Buttons.DeleteButton)button).getId()));
            this.addButton((Widget)b);
            this.deleteButtons.add(b);
        }
        this.updateDeleteButtonVisibility();
        TextFieldManager manager = this.getTextFieldManager().clear();
        this.valueTextField = new IntegerTextField(manager, this.font, this.xPos + 120, this.yPos + 28, 20, 14, 0, 100){

            @Override
            public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
                if (keyCode == 257 || keyCode == 335) {
                    GuiInspectionFilter.this.addEntry();
                    return true;
                }
                return super.keyPressed(keyCode, scanCode, modifiers);
            }
        };
        this.valueTextField.useGuiTextBackground();
    }

    private void updateDeleteButtonVisibility() {
        for (int i = 0; i < this.deleteButtons.size(); ++i) {
            this.deleteButtons.get((int)i).visible = i < this.comparisonList.items.size();
        }
    }

    private void addEntry() {
        int val = this.valueTextField.getValue();
        String s = Joiner.on((String)" ").join((Object)this.currentSubject, (Object)this.currentOp, new Object[]{val});
        this.sendAddStringMessage("Comparison", s);
        this.valueTextField.func_146180_a("");
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(textureLocation);
        this.blit(this.xPos, this.yPos, 0, 0, 176, 191);
        this.font.func_211126_b(this.title, (float)this.xPos + 88.0f - (float)this.font.func_78256_a(this.title) / 2.0f, (float)(this.yPos + 6), 0x404040);
        for (int i = 0; i < this.comparisonList.items.size(); ++i) {
            InspectionMatcher.Comparison comparison = this.comparisonList.items.get(i);
            this.font.func_211126_b(comparison.asLocalizedText(), (float)(this.xPos + 28), (float)(this.yPos + 55 + i * 19), 0x404080);
        }
        super.render(mouseX, mouseY, partialTicks);
    }

    @Override
    public void resync(ItemStack stack) {
        this.comparisonList = InspectionFilter.getComparisonList(stack);
        this.matchButton.setMessage(I18n.func_135052_a((String)("guiText.label.matchAll." + this.comparisonList.isMatchAll()), (Object[])new Object[0]));
        this.updateDeleteButtonVisibility();
    }
}

