/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.filter;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import me.desht.modularrouters.client.gui.filter.Buttons;
import me.desht.modularrouters.client.gui.filter.GuiFilterScreen;
import me.desht.modularrouters.client.gui.widgets.button.BackButton;
import me.desht.modularrouters.client.gui.widgets.textfield.TextFieldManager;
import me.desht.modularrouters.client.gui.widgets.textfield.TextFieldWidgetMR;
import me.desht.modularrouters.core.ModSounds;
import me.desht.modularrouters.item.smartfilter.RegexFilter;
import me.desht.modularrouters.util.MFLocator;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class GuiRegexFilter
extends GuiFilterScreen {
    private static final ResourceLocation textureLocation = new ResourceLocation("modularrouters", "textures/gui/regexfilter.png");
    private static final int GUI_WIDTH = 176;
    private static final int GUI_HEIGHT = 186;
    private int xPos;
    private int yPos;
    private RegexTextField regexTextField;
    private String errorMsg = "";
    private int errorTimer = 60;
    private final List<String> regexList = Lists.newArrayList();
    private final List<Buttons.DeleteButton> deleteButtons = Lists.newArrayList();

    public GuiRegexFilter(ItemStack filterStack, MFLocator locator) {
        super(filterStack, locator);
        this.regexList.addAll(RegexFilter.getRegexList(filterStack));
    }

    public void init() {
        this.xPos = (this.width - 176) / 2;
        this.yPos = (this.height - 186) / 2;
        TextFieldManager manager = this.getTextFieldManager().clear();
        this.regexTextField = new RegexTextField(this, 1, this.font, this.xPos + 10, this.yPos + 27, 144, 18);
        this.regexTextField.useGuiTextBackground();
        manager.focus(0);
        if (this.locator.filterSlot >= 0) {
            this.addButton((Widget)new BackButton(this.xPos - 12, this.yPos, p -> this.closeGUI()));
        }
        this.addButton((Widget)new Buttons.AddButton(this.xPos + 155, this.yPos + 23, button -> {
            if (!this.regexTextField.func_146179_b().isEmpty()) {
                this.addRegex();
            }
        }));
        for (int i = 0; i < 6; ++i) {
            Buttons.DeleteButton b = new Buttons.DeleteButton(this.xPos + 8, this.yPos + 52 + i * 19, i, button -> this.sendRemovePosMessage(((Buttons.DeleteButton)button).getId()));
            this.addButton((Widget)b);
            this.deleteButtons.add(b);
        }
        this.updateDeleteButtonVisibility();
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(textureLocation);
        this.blit(this.xPos, this.yPos, 0, 0, 176, 186);
        this.font.func_211126_b(this.title, (float)this.xPos + 88.0f - (float)this.font.func_78256_a(this.title) / 2.0f, (float)(this.yPos + 6), 0x404040);
        for (int i = 0; i < this.regexList.size(); ++i) {
            String regex = this.regexList.get(i);
            this.font.func_211126_b("/" + regex + "/", (float)(this.xPos + 28), (float)(this.yPos + 55 + i * 19), 0x404080);
        }
        if (!this.errorMsg.isEmpty()) {
            this.font.func_211126_b(this.errorMsg, (float)(this.xPos + 8), (float)(this.yPos + 170), 0x804040);
        }
        super.render(mouseX, mouseY, partialTicks);
    }

    @Override
    public void tick() {
        if (this.errorTimer > 0 && --this.errorTimer == 0) {
            this.errorMsg = "";
        }
        super.tick();
    }

    private void addRegex() {
        try {
            String regex = this.regexTextField.func_146179_b();
            Pattern.compile(regex);
            this.sendAddStringMessage("String", regex);
            this.regexTextField.func_146180_a("");
            this.getTextFieldManager().focus(0);
            this.errorMsg = "";
        }
        catch (PatternSyntaxException e) {
            this.minecraft.field_71439_g.func_184185_a(ModSounds.ERROR, 1.0f, 1.0f);
            this.errorMsg = I18n.func_135052_a((String)"guiText.label.regexError", (Object[])new Object[0]);
            this.errorTimer = 60;
        }
    }

    @Override
    public void resync(ItemStack stack) {
        this.regexList.clear();
        this.regexList.addAll(RegexFilter.getRegexList(stack));
        this.updateDeleteButtonVisibility();
    }

    private void updateDeleteButtonVisibility() {
        for (int i = 0; i < this.deleteButtons.size(); ++i) {
            this.deleteButtons.get((int)i).visible = i < this.regexList.size();
        }
    }

    private static class RegexTextField
    extends TextFieldWidgetMR {
        private final GuiRegexFilter parent;

        RegexTextField(GuiRegexFilter parent, int componentId, FontRenderer fontrendererObj, int x, int y, int par5Width, int par6Height) {
            super(parent.getTextFieldManager(), fontrendererObj, x, y, par5Width, par6Height);
            this.parent = parent;
            this.func_146203_f(40);
        }

        public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
            if (keyCode == 257) {
                this.parent.addRegex();
                return true;
            }
            return super.keyPressed(keyCode, scanCode, modifiers);
        }

        public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
            if (mouseX >= (double)this.x && mouseX < (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY < (double)(this.y + this.height) && mouseButton == 1) {
                this.func_146180_a("");
            }
            return super.mouseClicked(mouseX, mouseY, mouseButton);
        }
    }
}

