/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.module;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import me.desht.modularrouters.client.gui.module.GuiModule;
import me.desht.modularrouters.client.gui.widgets.button.ItemStackButton;
import me.desht.modularrouters.client.gui.widgets.button.TexturedCyclerButton;
import me.desht.modularrouters.client.gui.widgets.button.TexturedToggleButton;
import me.desht.modularrouters.client.gui.widgets.textfield.IntegerTextField;
import me.desht.modularrouters.client.gui.widgets.textfield.TextFieldManager;
import me.desht.modularrouters.client.render.RenderHelper;
import me.desht.modularrouters.config.ConfigHandler;
import me.desht.modularrouters.container.ContainerModule;
import me.desht.modularrouters.core.ModBlocks;
import me.desht.modularrouters.item.module.FluidModule;
import me.desht.modularrouters.logic.compiled.CompiledFluidModule;
import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;

public class GuiModuleFluid
extends GuiModule {
    private static final ItemStack bucketStack = new ItemStack((IItemProvider)Items.field_151133_ar);
    private static final ItemStack routerStack = new ItemStack((IItemProvider)ModBlocks.ITEM_ROUTER);
    private static final ItemStack waterStack = new ItemStack((IItemProvider)Items.field_151131_as);
    private ForceEmptyButton feb;
    private FluidDirectionButton fdb;
    private IntegerTextField maxTransferField;

    public GuiModuleFluid(ContainerModule container, PlayerInventory inv, ITextComponent displayName) {
        super(container, inv, displayName);
    }

    @Override
    public void init() {
        super.init();
        CompiledFluidModule cfm = new CompiledFluidModule(null, this.moduleItemStack);
        TextFieldManager manager = this.getOrCreateTextFieldManager();
        int max = (Integer)ConfigHandler.ROUTER.baseTickRate.get() * (Integer)ConfigHandler.ROUTER.fluidMaxTransferRate.get();
        this.maxTransferField = new IntegerTextField(manager, this.font, this.field_147003_i + 152, this.field_147009_r + 23, 34, 12, 0, max);
        this.maxTransferField.setValue(cfm.getMaxTransfer());
        this.maxTransferField.func_212954_a(str -> this.sendModuleSettingsDelayed(5));
        this.maxTransferField.setIncr(100, 10, 10);
        this.maxTransferField.useGuiTextBackground();
        manager.focus(0);
        this.addButton((Widget)new TooltipButton(this.field_147003_i + 130, this.field_147009_r + 19, 16, 16, bucketStack));
        this.fdb = new FluidDirectionButton(this.field_147003_i + 148, this.field_147009_r + 44, cfm.getFluidDirection());
        this.addButton((Widget)this.fdb);
        this.feb = new ForceEmptyButton(this.field_147003_i + 168, this.field_147009_r + 69, cfm.isForceEmpty());
        this.addButton((Widget)this.feb);
        this.getMouseOverHelp().addHelpRegion(this.field_147003_i + 128, this.field_147009_r + 17, this.field_147003_i + 183, this.field_147009_r + 35, "guiText.popup.fluid.maxTransfer");
        this.getMouseOverHelp().addHelpRegion(this.field_147003_i + 126, this.field_147009_r + 42, this.field_147003_i + 185, this.field_147009_r + 61, "guiText.popup.fluid.direction");
        this.getMouseOverHelp().addHelpRegion(this.field_147003_i + 128, this.field_147009_r + 67, this.field_147003_i + 185, this.field_147009_r + 86, "guiText.popup.fluid.forceEmpty");
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        this.blit(this.field_147003_i + 146, this.field_147009_r + 20, GuiModuleFluid.LARGE_TEXTFIELD_XY.x, GuiModuleFluid.LARGE_TEXTFIELD_XY.y, 35, 14);
        RenderHelper.renderItemStack(this.minecraft, routerStack, this.field_147003_i + 128, this.field_147009_r + 44, "");
        RenderHelper.renderItemStack(this.minecraft, waterStack, this.field_147003_i + 168, this.field_147009_r + 44, "");
    }

    @Override
    protected void func_146979_b(int par1, int par2) {
        super.func_146979_b(par1, par2);
        if (this.regulatorTextField.func_146176_q()) {
            this.font.func_211126_b("%", 179.0f, 77.0f, 0x404040);
        }
        if (this.feb.visible) {
            String s = I18n.func_135052_a((String)"guiText.label.fluidForceEmpty", (Object[])new Object[0]);
            this.font.func_211126_b(s, (float)(165 - this.font.func_78256_a(s)), 73.0f, 0x202040);
        }
    }

    @Override
    public void tick() {
        super.tick();
        this.feb.visible = this.fdb.getState() == FluidModule.FluidDirection.OUT;
    }

    @Override
    protected CompoundNBT buildMessageData() {
        CompoundNBT compound = super.buildMessageData();
        compound.func_74768_a("MaxTransfer", this.maxTransferField.getValue());
        compound.func_74774_a("FluidDir", (byte)((FluidModule.FluidDirection)((Object)this.fdb.getState())).ordinal());
        compound.func_74757_a("ForceEmpty", this.feb.isToggled());
        return compound;
    }

    private class ForceEmptyButton
    extends TexturedToggleButton {
        ForceEmptyButton(int x, int y, boolean initialVal) {
            super(x, y, 16, 16, initialVal, GuiModuleFluid.this);
            MiscUtil.appendMultiline(this.tooltip1, "guiText.tooltip.fluidForceEmpty.false", new Object[0]);
            MiscUtil.appendMultiline(this.tooltip2, "guiText.tooltip.fluidForceEmpty.true", new Object[0]);
        }

        @Override
        protected int getTextureX() {
            return this.isToggled() ? 192 : 112;
        }

        @Override
        protected int getTextureY() {
            return 16;
        }
    }

    private class FluidDirectionButton
    extends TexturedCyclerButton<FluidModule.FluidDirection> {
        private final List<List<String>> tooltips;

        FluidDirectionButton(int x, int y, FluidModule.FluidDirection initialVal) {
            super(x, y, 16, 16, initialVal, GuiModuleFluid.this);
            this.tooltips = Lists.newArrayList();
            for (FluidModule.FluidDirection dir : FluidModule.FluidDirection.values()) {
                this.tooltips.add(Collections.singletonList(I18n.func_135052_a((String)("itemText.fluid.direction." + (Object)((Object)dir)), (Object[])new Object[0])));
            }
        }

        @Override
        protected int getTextureX() {
            return 160 + ((FluidModule.FluidDirection)((Object)this.getState())).ordinal() * 16;
        }

        @Override
        protected int getTextureY() {
            return 16;
        }

        @Override
        public List<String> getTooltip() {
            return this.tooltips.get(((FluidModule.FluidDirection)((Object)this.getState())).ordinal());
        }
    }

    private class TooltipButton
    extends ItemStackButton {
        TooltipButton(int x, int y, int width, int height, ItemStack renderStack) {
            super(x, y, width, height, renderStack, true, p -> {});
            MiscUtil.appendMultiline(this.tooltip1, "guiText.tooltip.fluidTransferTooltip", new Object[0]);
            this.tooltip1.add("");
            GuiModuleFluid.this.getItemRouter().ifPresent(router -> {
                int ftRate = router.getFluidTransferRate();
                int tickRate = router.getTickRate();
                this.tooltip1.add(I18n.func_135052_a((String)"guiText.tooltip.maxFluidPerOp", (Object[])new Object[]{ftRate * tickRate, tickRate, ftRate}));
                this.tooltip1.add("");
            });
            MiscUtil.appendMultiline(this.tooltip1, "guiText.tooltip.numberFieldTooltip", new Object[0]);
        }

        public void playDownSound(SoundHandler soundHandlerIn) {
        }
    }
}

