/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.module;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import me.desht.modularrouters.client.gui.module.GuiModule;
import me.desht.modularrouters.client.gui.widgets.button.ItemStackCyclerButton;
import me.desht.modularrouters.client.gui.widgets.button.TexturedToggleButton;
import me.desht.modularrouters.container.ContainerModule;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.integration.XPCollection;
import me.desht.modularrouters.logic.compiled.CompiledVacuumModule;
import me.desht.modularrouters.util.ModNameCache;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class GuiModuleVacuum
extends GuiModule {
    private XPTypeButton xpb;
    private EjectButton ejb;

    public GuiModuleVacuum(ContainerModule container, PlayerInventory inv, ITextComponent displayName) {
        super(container, inv, displayName);
    }

    @Override
    public void init() {
        super.init();
        CompiledVacuumModule vac = new CompiledVacuumModule(null, this.moduleItemStack);
        ItemStack[] icons = (ItemStack[])Arrays.stream(XPCollection.XPCollectionType.values()).map(XPCollection.XPCollectionType::getIcon).toArray(ItemStack[]::new);
        this.xpb = new XPTypeButton(this.field_147003_i + 170, this.field_147009_r + 28, 16, 16, true, icons, vac.getXPCollectionType());
        this.addButton((Widget)this.xpb);
        this.ejb = new EjectButton(this.field_147003_i + 167, this.field_147009_r + 48, vac.isAutoEjecting());
        this.addButton((Widget)this.ejb);
        this.getMouseOverHelp().addHelpRegion(this.field_147003_i + 125, this.field_147009_r + 24, this.field_147003_i + 187, this.field_147009_r + 45, "guiText.popup.xpVacuum", guiContainer -> this.xpb.visible);
        this.getMouseOverHelp().addHelpRegion(this.field_147003_i + 125, this.field_147009_r + 46, this.field_147003_i + 187, this.field_147009_r + 65, "guiText.popup.xpVacuum.eject", guiContainer -> this.xpb.visible);
    }

    @Override
    protected void setupButtonVisibility() {
        super.setupButtonVisibility();
        this.xpb.visible = this.augmentCounter.getAugmentCount(ModItems.XP_VACUUM_AUGMENT) > 0;
        this.ejb.visible = this.xpb.visible && !((XPCollection.XPCollectionType)((Object)this.xpb.getState())).isSolid();
    }

    @Override
    protected void func_146979_b(int par1, int par2) {
        super.func_146979_b(par1, par2);
        if (this.augmentCounter.getAugmentCount(ModItems.XP_VACUUM_AUGMENT) > 0) {
            this.font.func_211126_b(I18n.func_135052_a((String)"guiText.label.xpVacuum", (Object[])new Object[0]), 127.0f, 32.0f, 0xFFFFFF);
            if (!((XPCollection.XPCollectionType)((Object)this.xpb.getState())).isSolid()) {
                this.font.func_211126_b(I18n.func_135052_a((String)"guiText.label.xpVacuum.eject", (Object[])new Object[0]), 127.0f, 52.0f, 0xFFFFFF);
            }
        }
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        if (this.augmentCounter.getAugmentCount(ModItems.XP_VACUUM_AUGMENT) > 0) {
            this.blit(this.field_147003_i + 168, this.field_147009_r + 26, GuiModuleVacuum.BUTTON_XY.x, GuiModuleVacuum.BUTTON_XY.y, 18, 18);
        }
    }

    @Override
    protected CompoundNBT buildMessageData() {
        CompoundNBT compound = super.buildMessageData();
        compound.func_74768_a("XPFluidType", ((XPCollection.XPCollectionType)((Object)this.xpb.getState())).ordinal());
        compound.func_74757_a("AutoEject", this.ejb.isToggled());
        return compound;
    }

    private class EjectButton
    extends TexturedToggleButton {
        EjectButton(int x, int y, boolean initialVal) {
            super(x, y, 16, 16, initialVal, GuiModuleVacuum.this);
        }

        @Override
        protected int getTextureX() {
            return this.isToggled() ? 192 : 112;
        }

        @Override
        protected int getTextureY() {
            return 16;
        }
    }

    private class XPTypeButton
    extends ItemStackCyclerButton<XPCollection.XPCollectionType> {
        private final List<List<String>> tips;

        XPTypeButton(int x, int y, int width, int height, boolean flat, ItemStack[] stacks, XPCollection.XPCollectionType initialVal) {
            super(x, y, width, height, flat, stacks, initialVal, GuiModuleVacuum.this);
            this.tips = Lists.newArrayList();
            for (XPCollection.XPCollectionType type : XPCollection.XPCollectionType.values()) {
                String modName = ModNameCache.getModName(type.getModId());
                ITextComponent title = type.getDisplayName();
                this.tips.add((List<String>)ImmutableList.of((Object)title.func_150254_d(), (Object)(TextFormatting.BLUE + "" + TextFormatting.ITALIC + modName)));
            }
        }

        @Override
        public void setState(XPCollection.XPCollectionType newState) {
            super.setState(newState);
            ((GuiModuleVacuum)GuiModuleVacuum.this).ejb.visible = ((GuiModuleVacuum)GuiModuleVacuum.this).xpb.visible && !((XPCollection.XPCollectionType)((Object)GuiModuleVacuum.this.xpb.getState())).isSolid();
        }

        @Override
        public List<String> getTooltip() {
            return this.tips.get(((XPCollection.XPCollectionType)((Object)this.getState())).ordinal());
        }

        @Override
        public boolean isApplicable(XPCollection.XPCollectionType state) {
            return state.isAvailable();
        }
    }
}

