/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.upgrade;

import com.mojang.blaze3d.platform.GlStateManager;
import me.desht.modularrouters.client.gui.widgets.GuiScreenBase;
import me.desht.modularrouters.client.gui.widgets.button.ItemStackButton;
import me.desht.modularrouters.client.gui.widgets.textfield.IntegerTextField;
import me.desht.modularrouters.client.gui.widgets.textfield.TextFieldManager;
import me.desht.modularrouters.config.ConfigHandler;
import me.desht.modularrouters.item.upgrade.SyncUpgrade;
import me.desht.modularrouters.network.PacketHandler;
import me.desht.modularrouters.network.SyncUpgradeSettingsMessage;
import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class GuiSyncUpgrade
extends GuiScreenBase {
    private static final ResourceLocation textureLocation = new ResourceLocation("modularrouters", "textures/gui/sync_upgrade.png");
    private static final ItemStack clockStack = new ItemStack((IItemProvider)Items.field_151113_aN);
    private static final int GUI_WIDTH = 176;
    private static final int GUI_HEIGHT = 48;
    private final String title;
    private int xPos;
    private int yPos;
    private int tunedValue;
    private final Hand hand;

    public GuiSyncUpgrade(ItemStack upgradeStack, Hand hand) {
        super(upgradeStack.func_200301_q());
        this.title = upgradeStack.func_200301_q().getString();
        this.tunedValue = SyncUpgrade.getTunedValue(upgradeStack);
        this.hand = hand;
    }

    public void init() {
        this.xPos = (this.width - 176) / 2;
        this.yPos = (this.height - 48) / 2;
        TextFieldManager manager = this.getTextFieldManager().clear();
        IntegerTextField intField = new IntegerTextField(manager, this.font, this.xPos + 77, this.yPos + 27, 25, 16, 0, (Integer)ConfigHandler.ROUTER.baseTickRate.get() - 1);
        intField.func_212954_a(str -> {
            this.tunedValue = str.isEmpty() ? 0 : Integer.parseInt(str);
            this.sendSettingsDelayed(5);
        });
        intField.setValue(this.tunedValue);
        intField.useGuiTextBackground();
        this.addButton((Widget)new TooltipButton(this.xPos + 55, this.yPos + 24, 16, 16));
        super.init();
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(textureLocation);
        this.blit(this.xPos, this.yPos, 0, 0, 176, 48);
        this.font.func_211126_b(this.title, (float)this.xPos + 88.0f - (float)this.font.func_78256_a(this.title) / 2.0f, (float)(this.yPos + 6), 0x404040);
        super.render(mouseX, mouseY, partialTicks);
    }

    public boolean isPauseScreen() {
        return false;
    }

    @Override
    protected void sendSettingsToServer() {
        PacketHandler.NETWORK.sendToServer((Object)new SyncUpgradeSettingsMessage(this.tunedValue, this.hand));
    }

    private static class TooltipButton
    extends ItemStackButton {
        TooltipButton(int x, int y, int width, int height) {
            super(x, y, width, height, clockStack, true, p -> {});
            MiscUtil.appendMultiline(this.tooltip1, "guiText.tooltip.tunedValue", 0, (Integer)ConfigHandler.ROUTER.baseTickRate.get() - 1);
            MiscUtil.appendMultiline(this.tooltip1, "guiText.tooltip.numberFieldTooltip", new Object[0]);
        }

        public void playDownSound(SoundHandler soundHandlerIn) {
        }
    }
}

