/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.item_beam;

import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.Vec3d;

public class ItemBeam {
    private final Vec3d startPos;
    private final Vec3d endPos;
    private final ItemStack renderItem;
    private final int[] colors;
    private final int lifeTime;
    private final boolean itemFade;
    private int ticksLived = 0;

    public ItemBeam(Vec3d startPos, Vec3d endPos, ItemStack renderItem, int color, int lifeTime, boolean itemFade) {
        this.startPos = startPos;
        this.endPos = endPos;
        this.renderItem = renderItem;
        this.colors = this.decompose(color);
        this.lifeTime = lifeTime;
        this.itemFade = itemFade;
    }

    private int[] decompose(int color) {
        int[] res = new int[]{color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF};
        return res;
    }

    public void tick() {
        ++this.ticksLived;
    }

    public void render(float partialTicks) {
        float f = ((float)this.ticksLived + partialTicks) / (float)this.lifeTime;
        int alpha = (int)((1.0 - Math.abs((double)f - 0.5)) * 32.0 + 16.0);
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((int)770, (int)771);
        GlStateManager.disableTexture();
        BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
        GlStateManager.lineWidth((float)10.0f);
        wr.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        wr.func_181662_b(this.startPos.field_72450_a, this.startPos.field_72448_b, this.startPos.field_72449_c).func_181669_b(this.colors[0], this.colors[1], this.colors[2], alpha).func_181675_d();
        wr.func_181662_b(this.interp(this.startPos.field_72450_a, this.endPos.field_72450_a, 1.0f), this.interp(this.startPos.field_72448_b, this.endPos.field_72448_b, 1.0f), this.interp(this.startPos.field_72449_c, this.endPos.field_72449_c, 1.0f)).func_181669_b(this.colors[0], this.colors[1], this.colors[2], this.itemFade ? alpha / 2 : alpha).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.lineWidth((float)3.0f);
        wr.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        wr.func_181662_b(this.startPos.field_72450_a, this.startPos.field_72448_b, this.startPos.field_72449_c).func_181669_b(this.colors[0], this.colors[1], this.colors[2], alpha).func_181675_d();
        wr.func_181662_b(this.interp(this.startPos.field_72450_a, this.endPos.field_72450_a, 1.0f), this.interp(this.startPos.field_72448_b, this.endPos.field_72448_b, 1.0f), this.interp(this.startPos.field_72449_c, this.endPos.field_72449_c, 1.0f)).func_181669_b(this.colors[0], this.colors[1], this.colors[2], this.itemFade ? alpha / 2 : alpha).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.enableTexture();
        double ix = this.interp(this.startPos.field_72450_a, this.endPos.field_72450_a, f);
        double iy = this.interp(this.startPos.field_72448_b, this.endPos.field_72448_b, f);
        double iz = this.interp(this.startPos.field_72449_c, this.endPos.field_72449_c, f);
        float yRot = f * 360.0f;
        GlStateManager.pushMatrix();
        GlStateManager.enableRescaleNormal();
        GlStateManager.enableLighting();
        GlStateManager.translated((double)ix, (double)(iy - 0.15), (double)iz);
        GlStateManager.rotatef((float)yRot, (float)0.25f, (float)1.0f, (float)0.0f);
        if (this.itemFade) {
            ClientWorld w = Minecraft.func_71410_x().field_71441_e;
            GlStateManager.scalef((float)(1.25f - f), (float)(1.25f - f), (float)(1.25f - f));
            if ((double)f > 0.9) {
                w.func_195594_a((IParticleData)ParticleTypes.field_197599_J, this.endPos.field_72450_a, this.endPos.field_72448_b, this.endPos.field_72449_c, 0.5 - w.field_73012_v.nextDouble(), -0.5, 0.5 - w.field_73012_v.nextDouble());
            }
        }
        Minecraft.func_71410_x().func_175599_af().func_181564_a(this.renderItem, ItemCameraTransforms.TransformType.GROUND);
        GlStateManager.disableRescaleNormal();
        GlStateManager.disableLighting();
        GlStateManager.disableBlend();
        GlStateManager.popMatrix();
    }

    boolean isExpired() {
        return this.ticksLived >= this.lifeTime;
    }

    private double interp(double p1, double p2, float f) {
        return p1 + (p2 - p1) * (double)f;
    }
}

