/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.item_beam;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import me.desht.modularrouters.client.item_beam.ItemBeam;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.profiler.IProfiler;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public enum ItemBeamDispatcher {
    INSTANCE;

    private static final int MAX_SIZE = 250;
    private final List<ItemBeam> beams = new ArrayList<ItemBeam>();

    public void addBeam(ItemBeam itemBeam) {
        if (this.beams.size() < 250) {
            this.beams.add(itemBeam);
        }
    }

    public void tick() {
        Iterator<ItemBeam> iterator = this.beams.iterator();
        while (iterator.hasNext()) {
            ItemBeam beam = iterator.next();
            beam.tick();
            if (!beam.isExpired()) continue;
            iterator.remove();
        }
    }

    @SubscribeEvent
    public void onWorldRender(RenderWorldLastEvent event) {
        if (ItemBeamDispatcher.INSTANCE.beams.isEmpty()) {
            return;
        }
        IProfiler profiler = Minecraft.func_71410_x().func_213239_aq();
        profiler.func_76320_a("modularrouters-particles");
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)(-TileEntityRendererDispatcher.field_147554_b), (double)(-TileEntityRendererDispatcher.field_147555_c), (double)(-TileEntityRendererDispatcher.field_147552_d));
        for (ItemBeam beam : ItemBeamDispatcher.INSTANCE.beams) {
            beam.render(event.getPartialTicks());
        }
        GlStateManager.popMatrix();
        profiler.func_76319_b();
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            INSTANCE.tick();
        }
    }
}

