/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.render.area;

import com.mojang.blaze3d.platform.GlStateManager;
import me.desht.modularrouters.client.render.RenderHelper;
import me.desht.modularrouters.client.render.area.AreaShowManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;

public class AreaShowHandler {
    private final double size;
    private final AreaShowManager.CompiledPosition cp;
    private int renderList;

    AreaShowHandler(AreaShowManager.CompiledPosition cp) {
        this.cp = cp;
        this.size = 0.5;
        this.compileRenderList();
    }

    private void compileRenderList() {
        this.renderList = GlStateManager.genLists((int)1);
        GlStateManager.newList((int)this.renderList, (int)4864);
        BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
        wr.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        double start = (1.0 - this.size) / 2.0;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        for (BlockPos pos : this.cp.getPositions()) {
            wr.func_178969_c((double)pos.func_177958_n() + start, (double)pos.func_177956_o() + start, (double)pos.func_177952_p() + start);
            int color = this.cp.getColour(pos);
            int r = (color & 0xFF0000) >> 16;
            int g = (color & 0xFF00) >> 8;
            int b = color & 0xFF;
            int alpha = this.getFaceAlpha(this.cp, pos, Direction.NORTH);
            wr.func_181662_b(0.0, 0.0, 0.0).func_181669_b(r, g, b, alpha).func_181675_d();
            wr.func_181662_b(0.0, this.size, 0.0).func_181669_b(r, g, b, alpha).func_181675_d();
            wr.func_181662_b(this.size, this.size, 0.0).func_181669_b(r, g, b, alpha).func_181675_d();
            wr.func_181662_b(this.size, 0.0, 0.0).func_181669_b(r, g, b, alpha).func_181675_d();
            alpha = this.getFaceAlpha(this.cp, pos, Direction.SOUTH);
            wr.func_181662_b(this.size, 0.0, this.size).func_181669_b(r, g, b, alpha).func_181675_d();
            wr.func_181662_b(this.size, this.size, this.size).func_181669_b(r, g, b, alpha).func_181675_d();
            wr.func_181662_b(0.0, this.size, this.size).func_181669_b(r, g, b, alpha).func_181675_d();
            wr.func_181662_b(0.0, 0.0, this.size).func_181669_b(r, g, b, alpha).func_181675_d();
            alpha = this.getFaceAlpha(this.cp, pos, Direction.WEST);
            wr.func_181662_b(0.0, 0.0, 0.0).func_181669_b(r, g, b, alpha).func_181675_d();
            wr.func_181662_b(0.0, 0.0, this.size).func_181669_b(r, g, b, alpha).func_181675_d();
            wr.func_181662_b(0.0, this.size, this.size).func_181669_b(r, g, b, alpha).func_181675_d();
            wr.func_181662_b(0.0, this.size, 0.0).func_181669_b(r, g, b, alpha).func_181675_d();
            alpha = this.getFaceAlpha(this.cp, pos, Direction.EAST);
            wr.func_181662_b(this.size, this.size, 0.0).func_181669_b(r, g, b, alpha).func_181675_d();
            wr.func_181662_b(this.size, this.size, this.size).func_181669_b(r, g, b, alpha).func_181675_d();
            wr.func_181662_b(this.size, 0.0, this.size).func_181669_b(r, g, b, alpha).func_181675_d();
            wr.func_181662_b(this.size, 0.0, 0.0).func_181669_b(r, g, b, alpha).func_181675_d();
            alpha = this.getFaceAlpha(this.cp, pos, Direction.DOWN);
            wr.func_181662_b(0.0, 0.0, 0.0).func_181669_b(r, g, b, alpha).func_181675_d();
            wr.func_181662_b(this.size, 0.0, 0.0).func_181669_b(r, g, b, alpha).func_181675_d();
            wr.func_181662_b(this.size, 0.0, this.size).func_181669_b(r, g, b, alpha).func_181675_d();
            wr.func_181662_b(0.0, 0.0, this.size).func_181669_b(r, g, b, alpha).func_181675_d();
            alpha = this.getFaceAlpha(this.cp, pos, Direction.UP);
            wr.func_181662_b(0.0, this.size, this.size).func_181669_b(r, g, b, alpha).func_181675_d();
            wr.func_181662_b(this.size, this.size, this.size).func_181669_b(r, g, b, alpha).func_181675_d();
            wr.func_181662_b(this.size, this.size, 0.0).func_181669_b(r, g, b, alpha).func_181675_d();
            wr.func_181662_b(0.0, this.size, 0.0).func_181669_b(r, g, b, alpha).func_181675_d();
        }
        Tessellator.func_178181_a().func_78381_a();
        wr.func_181668_a(1, DefaultVertexFormats.field_181705_e);
        RenderHelper.glColorHex(0x404040, 128);
        for (BlockPos pos : this.cp.getPositions()) {
            wr.func_178969_c((double)pos.func_177958_n() + start, (double)pos.func_177956_o() + start, (double)pos.func_177952_p() + start);
            wr.func_181662_b(0.0, 0.0, 0.0).func_181675_d();
            wr.func_181662_b(0.0, this.size, 0.0).func_181675_d();
            wr.func_181662_b(this.size, this.size, 0.0).func_181675_d();
            wr.func_181662_b(this.size, 0.0, 0.0).func_181675_d();
            wr.func_181662_b(this.size, 0.0, this.size).func_181675_d();
            wr.func_181662_b(this.size, this.size, this.size).func_181675_d();
            wr.func_181662_b(0.0, this.size, this.size).func_181675_d();
            wr.func_181662_b(0.0, 0.0, this.size).func_181675_d();
            wr.func_181662_b(0.0, 0.0, 0.0).func_181675_d();
            wr.func_181662_b(0.0, 0.0, this.size).func_181675_d();
            wr.func_181662_b(0.0, this.size, this.size).func_181675_d();
            wr.func_181662_b(0.0, this.size, 0.0).func_181675_d();
            wr.func_181662_b(this.size, this.size, 0.0).func_181675_d();
            wr.func_181662_b(this.size, this.size, this.size).func_181675_d();
            wr.func_181662_b(this.size, 0.0, this.size).func_181675_d();
            wr.func_181662_b(this.size, 0.0, 0.0).func_181675_d();
            wr.func_181662_b(0.0, 0.0, 0.0).func_181675_d();
            wr.func_181662_b(this.size, 0.0, 0.0).func_181675_d();
            wr.func_181662_b(this.size, 0.0, this.size).func_181675_d();
            wr.func_181662_b(0.0, 0.0, this.size).func_181675_d();
            wr.func_181662_b(0.0, this.size, this.size).func_181675_d();
            wr.func_181662_b(this.size, this.size, this.size).func_181675_d();
            wr.func_181662_b(this.size, this.size, 0.0).func_181675_d();
            wr.func_181662_b(0.0, this.size, 0.0).func_181675_d();
        }
        wr.func_178969_c(0.0, 0.0, 0.0);
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.endList();
    }

    private int getFaceAlpha(AreaShowManager.CompiledPosition cp, BlockPos pos, Direction face) {
        return cp.checkFace(pos, face) ? 160 : 64;
    }

    void render() {
        GlStateManager.callList((int)this.renderList);
    }
}

