/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.render.area;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.desht.modularrouters.ModularRouters;
import me.desht.modularrouters.client.render.area.AreaShowHandler;
import me.desht.modularrouters.client.render.area.IPositionProvider;
import me.desht.modularrouters.logic.ModuleTarget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public enum AreaShowManager {
    INSTANCE;

    private final Map<BlockPos, AreaShowHandler> showHandlers = new HashMap<BlockPos, AreaShowHandler>();
    private World world;

    public static AreaShowManager getInstance() {
        return INSTANCE;
    }

    @SubscribeEvent
    public void renderWorldLastEvent(RenderWorldLastEvent event) {
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)(-TileEntityRendererDispatcher.field_147554_b), (double)(-TileEntityRendererDispatcher.field_147555_c), (double)(-TileEntityRendererDispatcher.field_147552_d));
        GlStateManager.disableTexture();
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((int)770, (int)771);
        for (AreaShowHandler handler : this.showHandlers.values()) {
            handler.render();
        }
        ItemStack curItem = Minecraft.func_71410_x().field_71439_g.func_184614_ca();
        IPositionProvider positionProvider = this.getPositionProvider(curItem);
        if (positionProvider != null) {
            CompiledPosition cp = new CompiledPosition(curItem, positionProvider);
            GlStateManager.disableDepthTest();
            new AreaShowHandler(cp).render();
            GlStateManager.enableDepthTest();
        }
        GlStateManager.enableTexture();
        GlStateManager.disableBlend();
        GlStateManager.popMatrix();
    }

    private IPositionProvider getPositionProvider(ItemStack stack) {
        if (stack.func_77973_b() instanceof IPositionProvider) {
            return (IPositionProvider)stack.func_77973_b();
        }
        return null;
    }

    @SubscribeEvent
    public void tickEnd(TickEvent.ClientTickEvent event) {
        PlayerEntity player = ModularRouters.proxy.getClientPlayer();
        if (player != null) {
            if (player.field_70170_p != this.world) {
                this.world = player.field_70170_p;
                this.showHandlers.clear();
            } else if (event.phase == TickEvent.Phase.END) {
                this.showHandlers.keySet().removeIf(pos -> AreaShowManager.distBetweenSq(pos, player.field_70165_t, player.field_70163_u, player.field_70161_v) < 1024.0 && this.world.func_175623_d(pos));
            }
        }
    }

    public static double distBetweenSq(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Math.pow(x1 - x2, 2.0) + Math.pow(y1 - y2, 2.0) + Math.pow(z1 - z2, 2.0);
    }

    public static double distBetweenSq(BlockPos pos1, double x1, double y1, double z1) {
        return AreaShowManager.distBetweenSq(pos1.func_177958_n(), pos1.func_177956_o(), pos1.func_177952_p(), x1, y1, z1);
    }

    static class CompiledPosition {
        Map<BlockPos, FaceAndColour> positions = new HashMap<BlockPos, FaceAndColour>();

        CompiledPosition(ItemStack stack, IPositionProvider provider) {
            List<ModuleTarget> targets = provider.getStoredPositions(stack);
            for (int i = 0; i < targets.size(); ++i) {
                ModuleTarget target = targets.get(i);
                if (!target.isSameWorld((World)Minecraft.func_71410_x().field_71441_e)) continue;
                BlockPos pos = target.gPos.func_218180_b();
                if (this.positions.containsKey(pos)) {
                    this.positions.get((Object)pos).faces.set(target.face.ordinal());
                    continue;
                }
                FaceAndColour fc = new FaceAndColour(new BitSet(6), provider.getRenderColor(i));
                fc.faces.set(target.face.ordinal());
                this.positions.put(pos, fc);
            }
        }

        Set<BlockPos> getPositions() {
            return this.positions.keySet();
        }

        boolean checkFace(BlockPos pos, Direction face) {
            return this.positions.containsKey(pos) && this.positions.get((Object)pos).faces.get(face.func_176745_a());
        }

        int getColour(BlockPos pos) {
            return this.positions.containsKey(pos) ? this.positions.get((Object)pos).colour : 0;
        }

        static class FaceAndColour {
            final BitSet faces;
            final int colour;

            FaceAndColour(BitSet faces, int colour) {
                this.faces = faces;
                this.colour = colour;
            }
        }
    }
}

