/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class ConfigHandler {
    private static final ForgeConfigSpec.Builder S_BUILDER = new ForgeConfigSpec.Builder();
    public static final Module MODULE = new Module(S_BUILDER);
    public static final Router ROUTER = new Router(S_BUILDER);
    public static final Misc MISC = new Misc(S_BUILDER);
    public static final ForgeConfigSpec COMMON_SPEC = S_BUILDER.build();
    private static final ForgeConfigSpec.Builder C_BUILDER = new ForgeConfigSpec.Builder();
    public static final ClientMisc CLIENT_MISC = new ClientMisc(C_BUILDER);
    public static final ForgeConfigSpec CLIENT_SPEC = C_BUILDER.build();

    public static class ClientMisc {
        public final ForgeConfigSpec.BooleanValue alwaysShowModuleSettings;
        public final ForgeConfigSpec.BooleanValue moduleGuiBackgroundTint;

        ClientMisc(ForgeConfigSpec.Builder builder) {
            builder.push("Misc");
            this.alwaysShowModuleSettings = builder.comment("Should module tooltips always show module settings (without needing to hold Shift)?").translation("gui.config.alwaysShowSettings").define("alwaysShowSettings", true);
            this.moduleGuiBackgroundTint = builder.comment("Should module GUI's be tinted according to the module item colour?").translation("gui.config.moduleGuiBackgroundTint").define("moduleGuiBackgroundTint", true);
            builder.pop();
        }
    }

    public static class Misc {
        public final ForgeConfigSpec.BooleanValue startWithGuide;

        Misc(ForgeConfigSpec.Builder builder) {
            builder.push("Misc");
            this.startWithGuide = builder.comment("Should new players get a Modular Routers guidebook?").translation("gui.config.startWithGuide").define("startWithGuide", true);
            builder.pop();
        }
    }

    public static class Router {
        public final ForgeConfigSpec.IntValue baseTickRate;
        public final ForgeConfigSpec.IntValue ticksPerUpgrade;
        public final ForgeConfigSpec.IntValue hardMinTickRate;
        public final ForgeConfigSpec.IntValue ecoTimeout;
        public final ForgeConfigSpec.IntValue lowPowerTickRate;
        public final ForgeConfigSpec.IntValue fluidBaseTransferRate;
        public final ForgeConfigSpec.IntValue fluidMaxTransferRate;
        public final ForgeConfigSpec.IntValue mBperFluidUpgade;

        Router(ForgeConfigSpec.Builder builder) {
            builder.push("Router");
            this.baseTickRate = builder.comment("Base tick interval (in server ticks) for a router; router will run this often").translation("gui.config.baseTickRate").defineInRange("baseTickRate", 20, 1, Integer.MAX_VALUE);
            this.ticksPerUpgrade = builder.comment("Number of ticks by which 1 Speed Upgrade will reduce the router's tick interval").translation("gui.config.ticksPerUpgrade").defineInRange("ticksPerUpgrade", 2, 1, Integer.MAX_VALUE);
            this.hardMinTickRate = builder.comment("Hard minimum tick interval for a router regardless of Speed Upgrades").translation("gui.config.hardMinTickRate").defineInRange("hardMinTickRate", 2, 1, Integer.MAX_VALUE);
            this.ecoTimeout = builder.comment("Router with eco mode enabled will go into low-power mode if idle for this many server ticks").translation("gui.config.ecoTimeout").defineInRange("ecoTimeout", 100, 1, Integer.MAX_VALUE);
            this.lowPowerTickRate = builder.comment("Tick interval for an eco-mode router which has gone into low-power mode").translation("gui.config.lowPowerTickRate").defineInRange("lowPowerTickRate", 100, 1, Integer.MAX_VALUE);
            this.fluidBaseTransferRate = builder.comment("Base fluid transfer rate (mB/t in each direction) for a router").translation("gui.config.fluidBaseTransferRate").defineInRange("fluidBaseTransferRate", 50, 1, Integer.MAX_VALUE);
            this.fluidMaxTransferRate = builder.comment("Max fluid transfer rate (mB/t in each direction) for a router").translation("gui.config.baseTickRate").defineInRange("fluidMaxTransferRate", 400, 1, Integer.MAX_VALUE);
            this.mBperFluidUpgade = builder.comment("Fluid transfer rate increase per Fluid Transfer Upgrade").translation("gui.config.mBperFluidUpgade").defineInRange("mBperFluidUpgade", 10, 1, Integer.MAX_VALUE);
            builder.pop();
        }
    }

    public static class Module {
        public final ForgeConfigSpec.IntValue sender1BaseRange;
        public final ForgeConfigSpec.IntValue sender1MaxRange;
        public final ForgeConfigSpec.IntValue sender2BaseRange;
        public final ForgeConfigSpec.IntValue sender2MaxRange;
        public final ForgeConfigSpec.IntValue vacuumBaseRange;
        public final ForgeConfigSpec.IntValue vacuumMaxRange;
        public final ForgeConfigSpec.IntValue extruder1BaseRange;
        public final ForgeConfigSpec.IntValue extruder1MaxRange;
        public final ForgeConfigSpec.IntValue extruder2BaseRange;
        public final ForgeConfigSpec.IntValue extruder2MaxRange;
        public final ForgeConfigSpec.IntValue puller2BaseRange;
        public final ForgeConfigSpec.IntValue puller2MaxRange;
        public final ForgeConfigSpec.BooleanValue senderParticles;
        public final ForgeConfigSpec.BooleanValue pullerParticles;
        public final ForgeConfigSpec.BooleanValue placerParticles;
        public final ForgeConfigSpec.BooleanValue breakerParticles;
        public final ForgeConfigSpec.BooleanValue vacuumParticles;
        public final ForgeConfigSpec.BooleanValue flingerEffects;
        public final ForgeConfigSpec.BooleanValue extruderSound;
        public final ForgeConfigSpec.BooleanValue extruderPushEntities;

        Module(ForgeConfigSpec.Builder builder) {
            builder.push("Module");
            this.sender1BaseRange = builder.comment("Base range for Sender Mk1 (no range upgrades)").translation("gui.config.sender1BaseRange").defineInRange("sender1BaseRange", 8, 1, Integer.MAX_VALUE);
            this.sender1MaxRange = builder.comment("Max range for Sender Mk1").translation("gui.config.sender1MaxRange").defineInRange("sender1MaxRange", 16, 1, Integer.MAX_VALUE);
            this.sender2BaseRange = builder.comment("Base range for Sender Mk2 (no range upgrades)").translation("gui.config.sender2BaseRange").defineInRange("sender2BaseRange", 24, 1, Integer.MAX_VALUE);
            this.sender2MaxRange = builder.comment("Max range for Sender Mk2").translation("gui.config.sender2MaxRange").defineInRange("sender2MaxRange", 48, 1, Integer.MAX_VALUE);
            this.vacuumBaseRange = builder.comment("Base range for Vacuum (no range upgrades)").translation("gui.config.vacuumBaseRange").defineInRange("vacuumBaseRange", 6, 1, Integer.MAX_VALUE);
            this.vacuumMaxRange = builder.comment("Max range for Vacuum").translation("gui.config.vacuumMaxRange").defineInRange("vacuumMaxRange", 12, 1, Integer.MAX_VALUE);
            this.extruder1BaseRange = builder.comment("Base range for Extruder Mk1 (no range upgrades)").translation("gui.config.extruder1BaseRange").defineInRange("extruder1BaseRange", 16, 1, Integer.MAX_VALUE);
            this.extruder1MaxRange = builder.comment("Max range for Extruder Mk1").translation("gui.config.extruder1MaxRange").defineInRange("extruder1MaxRange", 32, 1, Integer.MAX_VALUE);
            this.extruder2BaseRange = builder.comment("Base range for Extruder Mk2 (no range upgrades)").translation("gui.config.extruder2BaseRange").defineInRange("extruder2BaseRange", 32, 1, Integer.MAX_VALUE);
            this.extruder2MaxRange = builder.comment("Max range for Extruder Mk2").translation("gui.config.extruder2MaxRange").defineInRange("extruder2MaxRange", 64, 1, Integer.MAX_VALUE);
            this.puller2BaseRange = builder.comment("Base range for Puller Mk2 (no range upgrades)").translation("gui.config.puller2BaseRange").defineInRange("puller2BaseRange", 12, 1, Integer.MAX_VALUE);
            this.puller2MaxRange = builder.comment("Max range for Puller Mk2").translation("gui.config.puller2MaxRange").defineInRange("puller2MaxRange", 24, 1, Integer.MAX_VALUE);
            this.senderParticles = builder.comment("Should Sender modules show particle effects when working?").translation("gui.config.senderParticles").define("senderParticles", true);
            this.pullerParticles = builder.comment("Should Puller modules show particle effects when working?").translation("gui.config.pullerParticles").define("pullerParticles", true);
            this.placerParticles = builder.comment("Should Placer modules show particle effects when working?").translation("gui.config.placerParticles").define("placerParticles", true);
            this.breakerParticles = builder.comment("Should Breaker modules show particle effects when working?").translation("gui.config.breakerParticles").define("breakerParticles", true);
            this.vacuumParticles = builder.comment("Should Vacuum modules show particle effects when working?").translation("gui.config.vacuumParticles").define("vacuumParticles", true);
            this.flingerEffects = builder.comment("Should Flinger modules show smoke effects & play a sound when working?").translation("gui.config.flingerEffects").define("flingerEffects", true);
            this.extruderSound = builder.comment("Should Extruder Mk1/2 modules play a sound when placing/removing blocks?").translation("gui.config.extruderSound").define("extruderSound", true);
            this.extruderPushEntities = builder.comment("Should Extruder Mk1/2 modules push entities along when extruding blocks?").translation("gui.config.extruderPushEntities").define("extruderPushEntities", true);
            builder.pop();
        }
    }
}

