/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.container;

import me.desht.modularrouters.container.ContainerSmartFilter;
import me.desht.modularrouters.container.handler.BaseModuleHandler;
import me.desht.modularrouters.container.slot.BaseModuleSlot;
import me.desht.modularrouters.core.ModContainerTypes;
import me.desht.modularrouters.logic.filter.Filter;
import me.desht.modularrouters.util.MFLocator;
import me.desht.modularrouters.util.SetofItemStack;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ContainerBulkItemFilter
extends ContainerSmartFilter {
    private static final int INV_START = 54;
    private static final int INV_END = 80;
    private static final int HOTBAR_START = 81;
    private static final int HOTBAR_END = 89;
    private static final int PLAYER_INV_X = 8;
    private static final int PLAYER_INV_Y = 151;
    private static final int PLAYER_HOTBAR_Y = 209;
    private final int currentSlot;
    private final BaseModuleHandler.BulkFilterHandler handler;

    public ContainerBulkItemFilter(int windowId, PlayerInventory invPlayer, PacketBuffer extraData) {
        this(windowId, invPlayer, MFLocator.fromBuffer(extraData));
    }

    public ContainerBulkItemFilter(int windowId, PlayerInventory invPlayer, MFLocator loc) {
        super(ModContainerTypes.CONTAINER_BULK_ITEM_FILTER, windowId, invPlayer, loc);
        int i;
        this.handler = new BaseModuleHandler.BulkFilterHandler(this.filterStack);
        this.currentSlot = invPlayer.field_70461_c + 81;
        for (i = 0; i < this.handler.getSlots(); ++i) {
            BaseModuleSlot.BulkFilterSlot slot = this.router == null ? new BaseModuleSlot.BulkFilterSlot(this.handler, i, 8 + 18 * (i % 9), 19 + 18 * (i / 9)) : new BaseModuleSlot.BulkFilterSlot(this.handler, this.router, i, 8 + 18 * (i % 9), 19 + 18 * (i / 9));
            this.func_75146_a((Slot)slot);
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)invPlayer, j + i * 9 + 9, 8 + j * 18, 151 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)invPlayer, i, 8 + i * 18, 209));
        }
    }

    public void clearSlots() {
        for (int i = 0; i < this.handler.getSlots(); ++i) {
            this.handler.setStackInSlot(i, ItemStack.field_190927_a);
        }
        this.handler.save();
        if (this.getRouter() != null && !this.getRouter().func_145831_w().field_72995_K) {
            this.getRouter().recompileNeeded(1);
        }
    }

    public int mergeInventory(IItemHandler srcInv, Filter.Flags flags, boolean clearFirst) {
        if (srcInv == null) {
            return 0;
        }
        SetofItemStack stacks = clearFirst ? new SetofItemStack(flags) : SetofItemStack.fromItemHandler((IItemHandler)this.handler, flags);
        int origSize = stacks.size();
        for (int i = 0; i < srcInv.getSlots() && stacks.size() < this.handler.getSlots(); ++i) {
            ItemStack stack = srcInv.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            stacks.add(ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1));
        }
        int slot = 0;
        for (ItemStack stack : stacks.sortedList()) {
            this.handler.setStackInSlot(slot++, stack);
        }
        while (slot < this.handler.getSlots()) {
            this.handler.setStackInSlot(slot++, ItemStack.field_190927_a);
        }
        this.handler.save();
        if (this.getRouter() != null && !this.getRouter().func_145831_w().field_72995_K) {
            this.getRouter().recompileNeeded(1);
        }
        return stacks.size() - origSize;
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        Slot srcSlot = (Slot)this.field_75151_b.get(index);
        if (srcSlot != null && srcSlot.func_75216_d()) {
            ItemStack stackInSlot = srcSlot.func_75211_c();
            ItemStack stack = stackInSlot.func_77946_l();
            stack.func_190920_e(1);
            if (index < this.handler.getSlots()) {
                srcSlot.func_75215_d(ItemStack.field_190927_a);
            } else if (index >= this.handler.getSlots()) {
                ItemStack stack0;
                int freeSlot;
                for (freeSlot = 0; freeSlot < this.handler.getSlots() && !(stack0 = this.handler.getStackInSlot(freeSlot)).func_190926_b() && !ItemStack.func_77989_b((ItemStack)stack0, (ItemStack)stack); ++freeSlot) {
                }
                if (freeSlot < this.handler.getSlots()) {
                    ((Slot)this.field_75151_b.get(freeSlot)).func_75215_d(stack);
                    srcSlot.func_75215_d(stackInSlot);
                }
            }
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_184996_a(int slot, int dragType, ClickType clickTypeIn, PlayerEntity player) {
        switch (clickTypeIn) {
            case PICKUP: {
                if (this.router == null && slot == this.currentSlot) {
                    return ItemStack.field_190927_a;
                }
                if (slot < this.handler.getSlots() && slot >= 0) {
                    Slot s = (Slot)this.field_75151_b.get(slot);
                    ItemStack stackOnCursor = player.field_71071_by.func_70445_o();
                    if (!stackOnCursor.func_190926_b()) {
                        ItemStack stack1 = stackOnCursor.func_77946_l();
                        stack1.func_190920_e(1);
                        s.func_75215_d(stack1);
                    } else {
                        s.func_75215_d(ItemStack.field_190927_a);
                    }
                    return ItemStack.field_190927_a;
                }
            }
            case THROW: {
                if (slot >= this.handler.getSlots() || slot < 0) break;
                return ItemStack.field_190927_a;
            }
        }
        return super.func_184996_a(slot, dragType, clickTypeIn, player);
    }
}

