/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.container;

import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.container.ContainerModule;
import me.desht.modularrouters.container.handler.BaseModuleHandler;
import me.desht.modularrouters.container.slot.BaseModuleSlot;
import me.desht.modularrouters.core.ModContainerTypes;
import me.desht.modularrouters.util.MFLocator;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;

public class ContainerExtruder2Module
extends ContainerModule {
    private static final int TEMPLATE_SLOTS = 9;

    ContainerExtruder2Module(int windowId, PlayerInventory inv, PacketBuffer extra) {
        this(windowId, inv, MFLocator.fromBuffer(extra));
    }

    public ContainerExtruder2Module(int windowId, PlayerInventory inv, MFLocator locator) {
        super(ModContainerTypes.CONTAINER_MODULE_EXTRUDER2, windowId, inv, locator);
        TemplateHandler handler = new TemplateHandler(locator.getModuleStack(inv.field_70458_d));
        for (int i = 0; i < 9; ++i) {
            int x = 129 + 18 * (i % 3);
            int y = 17 + 18 * (i / 3);
            TemplateSlot slot = this.router == null ? new TemplateSlot(handler, i, x, y) : new TemplateSlot(handler, this.router, i, x, y);
            this.func_75146_a((Slot)slot);
        }
    }

    @Override
    protected void transferStackInExtraSlot(PlayerEntity player, int index) {
        ((Slot)this.field_75151_b.get(index)).func_75215_d(ItemStack.field_190927_a);
    }

    @Override
    protected ItemStack slotClickExtraSlot(int slot, int dragType, ClickType clickTypeIn, PlayerEntity player) {
        Slot s = (Slot)this.field_75151_b.get(slot);
        ItemStack stackOnCursor = player.field_71071_by.func_70445_o();
        ItemStack stackInSlot = s.func_75211_c().func_77946_l();
        if (clickTypeIn == ClickType.QUICK_MOVE) {
            s.func_75215_d(ItemStack.field_190927_a);
        } else if (!stackOnCursor.func_190926_b() && !ItemStack.func_179545_c((ItemStack)stackInSlot, (ItemStack)stackOnCursor)) {
            ItemStack stack1 = stackOnCursor.func_77946_l();
            if (dragType == 1) {
                stack1.func_190920_e(1);
            }
            s.func_75215_d(stack1);
        } else if (!stackInSlot.func_190926_b()) {
            if (dragType == 1) {
                stackInSlot.func_190920_e(Math.min(stackInSlot.func_77976_d(), stackInSlot.func_190916_E() + 1));
            } else if (dragType == 0) {
                stackInSlot.func_190918_g(1);
            }
            s.func_75215_d(stackInSlot);
            s.func_75218_e();
        }
        return ItemStack.field_190927_a;
    }

    private static boolean isItemOKForTemplate(ItemStack stack) {
        if (stack.func_190926_b()) {
            return true;
        }
        if (!(stack.func_77973_b() instanceof BlockItem)) {
            return true;
        }
        Block b = ((BlockItem)stack.func_77973_b()).func_179223_d();
        return b.func_176223_P().func_185901_i() == BlockRenderType.MODEL;
    }

    public static class TemplateHandler
    extends BaseModuleHandler {
        private static final String NBT_TEMPLATE = "Template";

        public TemplateHandler(ItemStack holderStack) {
            super(holderStack, 9, NBT_TEMPLATE);
        }

        @Override
        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return ContainerExtruder2Module.isItemOKForTemplate(stack) ? super.insertItem(slot, stack, simulate) : stack;
        }

        public void setStackInSlot(int slot, ItemStack stack) {
            if (ContainerExtruder2Module.isItemOKForTemplate(stack)) {
                super.setStackInSlot(slot, stack);
            }
        }
    }

    private static class TemplateSlot
    extends BaseModuleSlot<TemplateHandler> {
        TemplateSlot(TemplateHandler itemHandler, TileEntityItemRouter router, int index, int xPosition, int yPosition) {
            super(itemHandler, router, index, xPosition, yPosition);
        }

        TemplateSlot(TemplateHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, null, index, xPosition, yPosition);
        }
    }
}

