/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.container.handler;

import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.core.ModBlocks;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.ItemStackHandler;

public class BufferHandler
extends ItemStackHandler {
    private final TileEntityItemRouter router;
    private LazyOptional<IFluidHandlerItem> fluidCap = LazyOptional.empty();
    private LazyOptional<IEnergyStorage> energyCap = LazyOptional.empty();

    public BufferHandler(TileEntityItemRouter router) {
        super(router.getBufferSlotCount());
        this.router = router;
    }

    public void onContentsChanged(int slot) {
        this.router.func_70296_d();
        ItemStack stack = this.getStackInSlot(slot);
        LazyOptional newFluidCap = stack.func_190916_E() == 1 ? FluidUtil.getFluidHandler((ItemStack)stack) : LazyOptional.empty();
        boolean updateFluid = newFluidCap.isPresent() && !this.fluidCap.isPresent() || !newFluidCap.isPresent() && this.fluidCap.isPresent();
        this.fluidCap.invalidate();
        this.fluidCap = newFluidCap;
        LazyOptional newEnergyCap = stack.func_190916_E() == 1 ? stack.getCapability(CapabilityEnergy.ENERGY) : LazyOptional.empty();
        boolean updateEnergy = newEnergyCap.isPresent() && !this.energyCap.isPresent() || !newEnergyCap.isPresent() && this.energyCap.isPresent();
        this.energyCap.invalidate();
        this.energyCap = newEnergyCap;
        if (updateFluid || updateEnergy) {
            this.router.func_145831_w().func_195593_d(this.router.func_174877_v(), (Block)ModBlocks.ITEM_ROUTER);
        }
    }

    public void deserializeNBT(CompoundNBT nbt) {
        super.deserializeNBT(nbt);
        ItemStack stack = this.getStackInSlot(0);
        this.fluidCap = stack.func_190916_E() == 1 ? FluidUtil.getFluidHandler((ItemStack)stack) : LazyOptional.empty();
        this.energyCap = stack.func_190916_E() == 1 ? stack.getCapability(CapabilityEnergy.ENERGY) : LazyOptional.empty();
    }

    public LazyOptional<IFluidHandlerItem> getFluidCapability() {
        return this.fluidCap;
    }

    public LazyOptional<IEnergyStorage> getEnergyCapability() {
        return this.energyCap;
    }
}

