/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.integration;

import java.util.Arrays;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.registries.ForgeRegistries;

public class XPCollection {
    private static final boolean[] AVAILABLE = new boolean[XPCollectionType.values().length];
    private static final ItemStack[] ICONS = new ItemStack[XPCollectionType.values().length];
    private static final boolean[] SOLID = new boolean[XPCollectionType.values().length];

    public static void detectXPTypes() {
        for (XPCollectionType type : XPCollectionType.values()) {
            XPCollection.AVAILABLE[type.ordinal()] = !XPCollection.getIconForResource(type.registryName).func_190926_b();
            XPCollection.SOLID[type.ordinal()] = ForgeRegistries.ITEMS.containsKey(type.registryName);
        }
        Arrays.fill(ICONS, null);
    }

    private static ItemStack getIconForResource(ResourceLocation resource) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(resource);
        if (item != null) {
            return new ItemStack((IItemProvider)item);
        }
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(resource);
        return fluid == Fluids.field_204541_a ? ItemStack.field_190927_a : FluidUtil.getFilledBucket((FluidStack)new FluidStack(fluid, 1000));
    }

    public static enum XPCollectionType {
        BOTTLE_O_ENCHANTING(7, "minecraft:experience_bottle"),
        SOLIDIFIED_EXPERIENCE(8, "actuallyadditions:item_solidified_experience");

        private final int xpRatio;
        private final ResourceLocation registryName;

        private XPCollectionType(int xpRatio, String registryName) {
            this.xpRatio = xpRatio;
            this.registryName = new ResourceLocation(registryName);
        }

        public int getXpRatio() {
            return this.xpRatio;
        }

        public ResourceLocation getRegistryName() {
            return this.registryName;
        }

        public boolean isSolid() {
            return SOLID[this.ordinal()];
        }

        public Fluid getFluid() {
            return (Fluid)ForgeRegistries.FLUIDS.getValue(this.registryName);
        }

        public String getModId() {
            return this.registryName.func_110624_b();
        }

        public boolean isAvailable() {
            return AVAILABLE[this.ordinal()];
        }

        public ItemStack getIcon() {
            if (ICONS[this.ordinal()] == null) {
                ICONS[this.ordinal()] = XPCollection.getIconForResource(this.registryName);
            }
            return ICONS[this.ordinal()];
        }

        public ITextComponent getDisplayName() {
            return XPCollection.getIconForResource(this.registryName).func_200301_q();
        }
    }
}

