/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.item;

import java.util.List;
import javax.annotation.Nullable;
import me.desht.modularrouters.config.ConfigHandler;
import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class ItemBase
extends Item {
    private static String ctrlKeyName = null;

    public ItemBase(Item.Properties props) {
        super(props);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        if (world == null) {
            return;
        }
        if (Screen.hasControlDown()) {
            this.addUsageInformation(stack, list);
        } else if (((Boolean)ConfigHandler.CLIENT_MISC.alwaysShowModuleSettings.get()).booleanValue() || Screen.hasShiftDown()) {
            this.addExtraInformation(stack, list);
            list.add(new TranslationTextComponent("itemText.misc.holdCtrl", new Object[]{ItemBase.getCtrlKeyName()}).func_211709_a(new TextFormatting[]{TextFormatting.GRAY}));
        } else if (!((Boolean)ConfigHandler.CLIENT_MISC.alwaysShowModuleSettings.get()).booleanValue()) {
            list.add(new TranslationTextComponent("itemText.misc.holdShiftCtrl", new Object[]{ItemBase.getCtrlKeyName()}).func_211709_a(new TextFormatting[]{TextFormatting.GRAY}));
        }
    }

    protected void addUsageInformation(ItemStack itemstack, List<ITextComponent> list) {
        MiscUtil.appendMultilineText(list, TextFormatting.GRAY, "itemText.usage.item." + itemstack.func_77973_b().getRegistryName().func_110623_a(), this.getExtraUsageParams());
    }

    protected abstract void addExtraInformation(ItemStack var1, List<ITextComponent> var2);

    protected Object[] getExtraUsageParams() {
        return new Object[0];
    }

    private static String getCtrlKeyName() {
        if (ctrlKeyName == null) {
            ctrlKeyName = System.getProperty("os.name").toLowerCase().contains("mac") ? "Cmd" : "Ctrl";
        }
        return ctrlKeyName;
    }
}

