/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.item.module;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import me.desht.modularrouters.ModularRouters;
import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.core.ModSounds;
import me.desht.modularrouters.item.module.IRangedModule;
import me.desht.modularrouters.item.module.ItemModule;
import me.desht.modularrouters.logic.ModuleTarget;
import me.desht.modularrouters.network.PlaySoundMessage;
import me.desht.modularrouters.util.BlockUtil;
import me.desht.modularrouters.util.InventoryUtils;
import me.desht.modularrouters.util.MiscUtil;
import me.desht.modularrouters.util.ModuleHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;

public abstract class TargetedModule
extends ItemModule {
    private static final String NBT_TARGET = "Target";
    private static final String NBT_MULTI_TARGET = "MultiTarget";
    private static final Map<UUID, Long> lastSwing = Maps.newHashMap();

    TargetedModule(Item.Properties props) {
        super(props);
    }

    public ActionResultType func_195939_a(ItemUseContext ctx) {
        if (ctx.func_195999_j() != null && ctx.func_195999_j().func_70093_af()) {
            return (ActionResultType)InventoryUtils.getInventory(ctx.func_195991_k(), ctx.func_195995_a(), ctx.func_196000_l()).map(handler -> {
                if (this.getMaxTargets() == 1) {
                    this.handleSingleTarget(ctx.func_195996_i(), ctx.func_195999_j(), ctx.func_195991_k(), ctx.func_195995_a(), ctx.func_196000_l());
                } else {
                    this.handleMultiTarget(ctx.func_195996_i(), ctx.func_195999_j(), ctx.func_195991_k(), ctx.func_195995_a(), ctx.func_196000_l());
                }
                return ActionResultType.SUCCESS;
            }).orElse((Object)super.func_195939_a(ctx));
        }
        return ActionResultType.PASS;
    }

    private void handleSingleTarget(ItemStack stack, PlayerEntity player, World world, BlockPos pos, Direction face) {
        if (!world.field_72995_K) {
            TargetedModule.setTarget(stack, world, pos, face);
            ModuleTarget tgt = TargetedModule.getTarget(stack, true);
            if (tgt != null) {
                ITextComponent msg = MiscUtil.xlate("chatText.misc.targetSet", new Object[0]).func_150257_a(tgt.getTextComponent());
                player.func_146105_b(msg.func_211708_a(TextFormatting.YELLOW), true);
                PlaySoundMessage.playSound(player, ModSounds.SUCCESS, 1.0f, 1.3f);
            }
        }
    }

    private void handleMultiTarget(ItemStack stack, PlayerEntity player, World world, BlockPos pos, Direction face) {
        if (!world.field_72995_K) {
            boolean removing = false;
            String invName = BlockUtil.getBlockName(world, pos);
            GlobalPos gPos = GlobalPos.func_218179_a((DimensionType)world.func_201675_m().func_186058_p(), (BlockPos)pos);
            ModuleTarget tgt = new ModuleTarget(gPos, face, invName);
            Set<ModuleTarget> targets = TargetedModule.getTargets(stack, true);
            if (targets.contains(tgt)) {
                targets.remove(tgt);
                removing = true;
                player.func_146105_b(MiscUtil.xlate("chatText.misc.targetRemoved", targets.size(), this.getMaxTargets()).func_150257_a(tgt.getTextComponent()).func_211708_a(TextFormatting.YELLOW), true);
            } else if (targets.size() < this.getMaxTargets()) {
                targets.add(tgt);
                player.func_146105_b(new TranslationTextComponent("chatText.misc.targetAdded", new Object[]{targets.size(), this.getMaxTargets()}).func_150257_a(tgt.getTextComponent()).func_211708_a(TextFormatting.YELLOW), true);
            } else {
                player.func_146105_b(new TranslationTextComponent("chatText.misc.tooManyTargets", new Object[]{this.getMaxTargets()}).func_211708_a(TextFormatting.RED), true);
                PlaySoundMessage.playSound(player, ModSounds.ERROR, 1.0f, 1.3f);
                return;
            }
            PlaySoundMessage.playSound(player, ModSounds.SUCCESS, 1.0f, removing ? 1.1f : 1.3f);
            TargetedModule.setTargets(stack, targets);
        }
    }

    @Override
    public void addUsageInformation(ItemStack itemstack, List<ITextComponent> list) {
        super.addUsageInformation(itemstack, list);
        MiscUtil.appendMultilineText(list, TextFormatting.YELLOW, this.getMaxTargets() > 1 ? "itemText.targetingHintMulti" : "itemText.targetingHint", new Object[0]);
    }

    @Override
    protected void addSettingsInformation(ItemStack itemstack, List<ITextComponent> list) {
        super.addSettingsInformation(itemstack, list);
        HashSet targets = this.getMaxTargets() > 1 ? TargetedModule.getTargets(itemstack, false) : Sets.newHashSet((Object[])new ModuleTarget[]{TargetedModule.getTarget(itemstack)});
        for (ModuleTarget target : targets) {
            ModuleTarget moduleTarget;
            TargetValidation val;
            if (target == null) continue;
            ITextComponent msg = MiscUtil.xlate("chatText.misc.target", new Object[0]).func_150257_a(target.getTextComponent()).func_211708_a(TextFormatting.YELLOW);
            list.add(msg);
            TileEntityItemRouter router = ModularRouters.proxy.getOpenItemRouter();
            if (router == null || (val = this.validateTarget(itemstack, moduleTarget = new ModuleTarget(router.getGlobalPos()), target, false)) == TargetValidation.OK) continue;
            list.add(MiscUtil.xlate(val.translationKey(), new Object[0]).func_211708_a(val.getColor()));
        }
    }

    @Override
    public ActionResult<ItemStack> onSneakRightClick(ItemStack stack, World world, PlayerEntity player, Hand hand) {
        if (!world.field_72995_K && TargetedModule.getTarget(stack) != null && this.getMaxTargets() == 1) {
            TargetedModule.setTarget(stack, world, null, null);
            PlaySoundMessage.playSound(player, ModSounds.SUCCESS, 1.0f, 1.1f);
            player.func_146105_b(MiscUtil.xlate("chatText.misc.targetCleared", new Object[0]).func_211708_a(TextFormatting.YELLOW), true);
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    private static void setTarget(ItemStack stack, World world, BlockPos pos, Direction face) {
        if (world.field_72995_K) {
            ModularRouters.LOGGER.warn("TargetModule.setTarget() should not be called client-side!");
            return;
        }
        CompoundNBT compound = ModuleHelper.validateNBT(stack);
        if (pos == null) {
            compound.func_82580_o(NBT_TARGET);
        } else {
            GlobalPos gPos = GlobalPos.func_218179_a((DimensionType)world.func_201675_m().func_186058_p(), (BlockPos)pos);
            ModuleTarget mt = new ModuleTarget(gPos, face, BlockUtil.getBlockName(world, pos));
            compound.func_218657_a(NBT_TARGET, (INBT)mt.toNBT());
        }
        stack.func_77978_p().func_218657_a("modularrouters", (INBT)compound);
    }

    public static ModuleTarget getTarget(ItemStack stack) {
        return TargetedModule.getTarget(stack, false);
    }

    public static ModuleTarget getTarget(ItemStack stack, boolean checkBlockName) {
        CompoundNBT compound = stack.func_179543_a("modularrouters");
        if (compound != null && compound.func_150299_b(NBT_TARGET) == 10) {
            ModuleTarget newTarget;
            ModuleTarget target = ModuleTarget.fromNBT(compound.func_74775_l(NBT_TARGET));
            if (checkBlockName && (newTarget = TargetedModule.updateTargetBlockName(stack, target)) != null) {
                return newTarget;
            }
            return target;
        }
        return null;
    }

    public static Set<ModuleTarget> getTargets(ItemStack stack, boolean checkBlockName) {
        HashSet result = Sets.newHashSet();
        CompoundNBT compound = stack.func_179543_a("modularrouters");
        if (compound != null && compound.func_150299_b(NBT_MULTI_TARGET) == 9) {
            ListNBT list = compound.func_150295_c(NBT_MULTI_TARGET, 10);
            for (int i = 0; i < list.size(); ++i) {
                ModuleTarget target = ModuleTarget.fromNBT(list.func_150305_b(i));
                if (checkBlockName) {
                    ModuleTarget newTarget = TargetedModule.updateTargetBlockName(stack, target);
                    result.add(newTarget != null ? newTarget : target);
                    continue;
                }
                result.add(target);
            }
        }
        return result;
    }

    private static void setTargets(ItemStack stack, Set<ModuleTarget> targets) {
        CompoundNBT compound = ModuleHelper.validateNBT(stack);
        ListNBT list = new ListNBT();
        for (ModuleTarget target : targets) {
            list.add((Object)target.toNBT());
        }
        compound.func_218657_a(NBT_MULTI_TARGET, (INBT)list);
        stack.func_77978_p().func_218657_a("modularrouters", (INBT)compound);
    }

    private static ModuleTarget updateTargetBlockName(ItemStack stack, ModuleTarget target) {
        String invName;
        ServerWorld w = MiscUtil.getWorldForGlobalPos(target.gPos);
        BlockPos pos = target.gPos.func_218180_b();
        if (w != null && w.func_72863_F().func_73149_a(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4) && !target.blockTranslationKey.equals(invName = BlockUtil.getBlockName((World)w, pos))) {
            TargetedModule.setTarget(stack, (World)w, pos, target.face);
            return new ModuleTarget(target.gPos, target.face, invName);
        }
        return null;
    }

    @Override
    public boolean onEntitySwing(ItemStack stack, LivingEntity entityLiving) {
        if (!(entityLiving instanceof ServerPlayerEntity)) {
            return false;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)entityLiving;
        World world = player.func_130014_f_();
        long now = System.currentTimeMillis();
        if (now - lastSwing.getOrDefault(player.func_110124_au(), 0L) < 250L) {
            return true;
        }
        lastSwing.put(player.func_110124_au(), now);
        ModuleTarget src = new ModuleTarget(GlobalPos.func_218179_a((DimensionType)world.func_201675_m().func_186058_p(), (BlockPos)player.func_180425_c()));
        HashSet targets = this.getMaxTargets() > 1 ? TargetedModule.getTargets(stack, true) : Sets.newHashSet((Object[])new ModuleTarget[]{TargetedModule.getTarget(stack, true)});
        for (ModuleTarget target : targets) {
            if (target == null) continue;
            TargetValidation v = this.validateTarget(stack, src, target, true);
            ITextComponent msg = MiscUtil.xlate("chatText.misc.target", new Object[0]).func_150257_a(target.getTextComponent());
            msg.func_150258_a(" ");
            msg.func_150257_a(MiscUtil.xlate(v.translationKey(), new Object[0]).func_211708_a(v.getColor()));
            msg.func_211708_a(TextFormatting.YELLOW);
            player.func_146105_b(msg, false);
        }
        return true;
    }

    private TargetValidation validateTarget(ItemStack moduleStack, ModuleTarget src, ModuleTarget dst, boolean validateBlocks) {
        if (this.isRangeLimited() && (src.gPos.func_218177_a() != dst.gPos.func_218177_a() || src.gPos.func_218180_b().func_177951_i((Vec3i)dst.gPos.func_218180_b()) > (double)this.maxDistanceSq(moduleStack))) {
            return TargetValidation.OUT_OF_RANGE;
        }
        if (validateBlocks) {
            ServerWorld w = MiscUtil.getWorldForGlobalPos(dst.gPos);
            if (w == null || !w.func_72863_F().func_73149_a(dst.gPos.func_218180_b().func_177958_n() >> 4, dst.gPos.func_218180_b().func_177952_p() >> 4)) {
                return TargetValidation.NOT_LOADED;
            }
            if (w.func_175625_s(dst.gPos.func_218180_b()) == null) {
                return TargetValidation.NOT_INVENTORY;
            }
        }
        return TargetValidation.OK;
    }

    private int maxDistanceSq(ItemStack stack) {
        if (stack.func_77973_b() instanceof IRangedModule) {
            int r = ((IRangedModule)stack.func_77973_b()).getCurrentRange(stack);
            return r * r;
        }
        return 0;
    }

    protected int getMaxTargets() {
        return 1;
    }

    protected boolean isRangeLimited() {
        return true;
    }

    static enum TargetValidation {
        OK,
        OUT_OF_RANGE,
        NOT_LOADED,
        NOT_INVENTORY;


        TextFormatting getColor() {
            return this == OK ? TextFormatting.GREEN : TextFormatting.RED;
        }

        String translationKey() {
            return "chatText.targetValidation." + this.toString();
        }
    }
}

