/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.item.smartfilter;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import me.desht.modularrouters.ModularRouters;
import me.desht.modularrouters.client.gui.filter.GuiBulkItemFilter;
import me.desht.modularrouters.container.ContainerBulkItemFilter;
import me.desht.modularrouters.container.ContainerSmartFilter;
import me.desht.modularrouters.container.handler.BaseModuleHandler;
import me.desht.modularrouters.core.ModSounds;
import me.desht.modularrouters.item.smartfilter.ItemSmartFilter;
import me.desht.modularrouters.logic.filter.Filter;
import me.desht.modularrouters.logic.filter.matchers.BulkItemMatcher;
import me.desht.modularrouters.logic.filter.matchers.IItemMatcher;
import me.desht.modularrouters.network.FilterSettingsMessage;
import me.desht.modularrouters.network.GuiSyncMessage;
import me.desht.modularrouters.util.InventoryUtils;
import me.desht.modularrouters.util.MFLocator;
import me.desht.modularrouters.util.SetofItemStack;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class BulkItemFilter
extends ItemSmartFilter {
    public static final int FILTER_SIZE = 54;

    public BulkItemFilter(Item.Properties props) {
        super(props);
    }

    @Override
    public IItemMatcher compile(ItemStack filterStack, ItemStack moduleStack) {
        Filter.Flags flags = moduleStack.func_190926_b() ? Filter.Flags.DEFAULT_FLAGS : new Filter.Flags(moduleStack);
        SetofItemStack stacks = BulkItemFilter.getFilterItems(filterStack, flags);
        return new BulkItemMatcher(stacks, flags);
    }

    private static SetofItemStack getFilterItems(ItemStack filterStack, Filter.Flags flags) {
        if (filterStack.func_77942_o()) {
            BaseModuleHandler.BulkFilterHandler handler = new BaseModuleHandler.BulkFilterHandler(filterStack);
            return SetofItemStack.fromItemHandler((IItemHandler)handler, flags);
        }
        return new SetofItemStack(Filter.Flags.DEFAULT_FLAGS);
    }

    @Override
    public void addExtraInformation(ItemStack itemstack, List<ITextComponent> list) {
        super.addExtraInformation(itemstack, list);
        list.add((ITextComponent)new TranslationTextComponent("itemText.misc.bulkItemFilter.count", new Object[]{this.getSize(itemstack)}));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Class<? extends Screen> getGuiClass() {
        return GuiBulkItemFilter.class;
    }

    @Override
    public boolean hasContainer() {
        return true;
    }

    @Override
    public ContainerSmartFilter createContainer(int windowId, PlayerInventory invPlayer, MFLocator loc) {
        return new ContainerBulkItemFilter(windowId, invPlayer, loc);
    }

    public ActionResultType func_195939_a(ItemUseContext ctx) {
        World world = ctx.func_195991_k();
        PlayerEntity player = ctx.func_195999_j();
        ItemStack stack = ctx.func_195996_i();
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        if (player.func_70093_af()) {
            return (ActionResultType)InventoryUtils.getInventory(world, ctx.func_195995_a(), ctx.func_196000_l()).map(handler -> {
                int nAdded = this.mergeInventory(stack, (IItemHandler)handler);
                player.func_146105_b((ITextComponent)new TranslationTextComponent("chatText.misc.inventoryMerged", new Object[]{nAdded, stack.func_200301_q()}), false);
                world.func_184133_a(null, ctx.func_195995_a(), ModSounds.SUCCESS, SoundCategory.MASTER, 1.0f, 1.0f);
                return ActionResultType.SUCCESS;
            }).orElse((Object)super.func_195939_a(ctx));
        }
        return ActionResultType.PASS;
    }

    @Override
    public GuiSyncMessage onReceiveSettingsMessage(PlayerEntity player, FilterSettingsMessage message, ItemStack filterStack, ItemStack moduleStack) {
        if (!(player.field_71070_bA instanceof ContainerBulkItemFilter)) {
            return null;
        }
        ContainerBulkItemFilter con = (ContainerBulkItemFilter)player.field_71070_bA;
        Filter.Flags flags = moduleStack.func_190926_b() ? Filter.Flags.DEFAULT_FLAGS : new Filter.Flags(moduleStack);
        switch (message.getOp()) {
            case CLEAR_ALL: {
                con.clearSlots();
                break;
            }
            case MERGE: {
                message.getTargetInventory().ifPresent(h -> con.mergeInventory((IItemHandler)h, flags, false));
                break;
            }
            case LOAD: {
                message.getTargetInventory().ifPresent(h -> con.mergeInventory((IItemHandler)h, flags, true));
                break;
            }
            default: {
                ModularRouters.LOGGER.warn("received unexpected message type " + (Object)((Object)message.getOp()) + " for " + filterStack);
            }
        }
        return null;
    }

    @Override
    public int getSize(ItemStack filterStack) {
        return BaseModuleHandler.getFilterSize(filterStack, "ModuleFilter");
    }

    private int mergeInventory(ItemStack filterStack, IItemHandler srcInventory) {
        SetofItemStack stacks = BulkItemFilter.getFilterItems(filterStack, Filter.Flags.DEFAULT_FLAGS);
        int origSize = stacks.size();
        for (int i = 0; i < srcInventory.getSlots() && stacks.size() < 54; ++i) {
            ItemStack stack = srcInventory.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            stacks.add(ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1));
        }
        BaseModuleHandler.BulkFilterHandler handler = new BaseModuleHandler.BulkFilterHandler(filterStack);
        int slot = 0;
        Comparator comp = (o1, o2) -> o1.func_200301_q().toString().compareTo(o2.func_200301_q().getString());
        for (ItemStack stack : stacks.stream().sorted(comp).collect(Collectors.toList())) {
            handler.setStackInSlot(slot++, stack);
        }
        handler.save();
        return stacks.size() - origSize;
    }
}

