/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.item.smartfilter;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import me.desht.modularrouters.ModularRouters;
import me.desht.modularrouters.client.gui.filter.GuiRegexFilter;
import me.desht.modularrouters.item.smartfilter.ItemSmartFilter;
import me.desht.modularrouters.logic.filter.matchers.IItemMatcher;
import me.desht.modularrouters.logic.filter.matchers.RegexMatcher;
import me.desht.modularrouters.network.FilterSettingsMessage;
import me.desht.modularrouters.network.GuiSyncMessage;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class RegexFilter
extends ItemSmartFilter {
    private static final String NBT_REGEX = "Regex";
    public static final int MAX_SIZE = 6;

    public RegexFilter(Item.Properties props) {
        super(props);
    }

    public static List<String> getRegexList(ItemStack filterStack) {
        CompoundNBT tag = filterStack.func_179543_a("modularrouters");
        if (tag != null) {
            ListNBT items = tag.func_150295_c(NBT_REGEX, 8);
            ArrayList res = Lists.newArrayListWithExpectedSize((int)items.size());
            for (int i = 0; i < items.size(); ++i) {
                res.add(items.func_150307_f(i));
            }
            return res;
        }
        return Lists.newArrayList();
    }

    private static void setRegexList(ItemStack filterStack, List<String> regex) {
        ListNBT list = regex.stream().map(StringNBT::new).collect(Collectors.toCollection(ListNBT::new));
        filterStack.func_190925_c("modularrouters").func_218657_a(NBT_REGEX, (INBT)list);
    }

    @Override
    public void addExtraInformation(ItemStack itemstack, List<ITextComponent> list) {
        super.addExtraInformation(itemstack, list);
        CompoundNBT compound = itemstack.func_77978_p();
        if (compound != null) {
            List<String> l = RegexFilter.getRegexList(itemstack);
            list.add((ITextComponent)new TranslationTextComponent("itemText.misc.regexFilter.count", new Object[]{l.size()}));
            list.addAll(l.stream().map(s -> " \u2022 " + TextFormatting.AQUA + "/" + s + "/").map(StringTextComponent::new).collect(Collectors.toList()));
        } else {
            list.add((ITextComponent)new TranslationTextComponent("itemText.misc.regexFilter.count", new Object[]{0}));
        }
    }

    @Override
    public IItemMatcher compile(ItemStack filterStack, ItemStack moduleStack) {
        return new RegexMatcher(RegexFilter.getRegexList(filterStack));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Class<? extends Screen> getGuiClass() {
        return GuiRegexFilter.class;
    }

    @Override
    public boolean hasContainer() {
        return false;
    }

    @Override
    public GuiSyncMessage onReceiveSettingsMessage(PlayerEntity player, FilterSettingsMessage message, ItemStack filterStack, ItemStack moduleStack) {
        switch (message.getOp()) {
            case ADD_STRING: {
                String regex = message.getPayload().func_74779_i("String");
                List<String> l = RegexFilter.getRegexList(filterStack);
                if (l.size() >= 6) break;
                l.add(regex);
                RegexFilter.setRegexList(filterStack, l);
                return new GuiSyncMessage(filterStack);
            }
            case REMOVE_AT: {
                int pos = message.getPayload().func_74762_e("Pos");
                List<String> l = RegexFilter.getRegexList(filterStack);
                if (pos < 0 || pos >= l.size()) break;
                l.remove(pos);
                RegexFilter.setRegexList(filterStack, l);
                return new GuiSyncMessage(filterStack);
            }
            default: {
                ModularRouters.LOGGER.warn("received unexpected message type " + (Object)((Object)message.getOp()) + " for " + filterStack);
            }
        }
        return null;
    }

    @Override
    public int getSize(ItemStack filterStack) {
        CompoundNBT tag = filterStack.func_179543_a("modularrouters");
        return tag != null ? tag.func_150295_c(NBT_REGEX, 8).size() : 0;
    }
}

