/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.compiled;

import javax.annotation.Nonnull;
import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.config.ConfigHandler;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.logic.compiled.CompiledModule;
import me.desht.modularrouters.util.BlockUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class CompiledBreakerModule
extends CompiledModule {
    private final boolean silkTouch;
    private final int fortune;

    public CompiledBreakerModule(TileEntityItemRouter router, ItemStack stack) {
        super(router, stack);
        this.silkTouch = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)stack) > 0;
        this.fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack);
    }

    @Override
    public boolean execute(@Nonnull TileEntityItemRouter router) {
        if (this.isRegulationOK(router, true)) {
            World world = router.func_145831_w();
            if (!(world instanceof ServerWorld)) {
                return false;
            }
            BlockPos pos = this.getTarget().gPos.func_218180_b();
            int oldId = Block.func_196246_j((BlockState)world.func_180495_p(pos));
            BlockUtil.BreakResult breakResult = BlockUtil.tryBreakBlock(world, pos, this.getFilter(), this.silkTouch, this.fortune);
            if (breakResult.isBlockBroken()) {
                breakResult.processDrops(world, pos, router.getBuffer());
                if (((Boolean)ConfigHandler.MODULE.breakerParticles.get()).booleanValue() && router.getUpgradeCount(ModItems.MUFFLER_UPGRADE) == 0) {
                    world.func_217379_c(2001, pos, oldId);
                }
                return true;
            }
        }
        return false;
    }
}

