/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.compiled;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.block.tile.TileEntityTemplateFrame;
import me.desht.modularrouters.container.ContainerExtruder2Module;
import me.desht.modularrouters.core.ModBlocks;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.logic.compiled.CompiledExtruderModule1;
import me.desht.modularrouters.util.BlockUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.fluids.IFluidBlock;

public class CompiledExtruderModule2
extends CompiledExtruderModule1 {
    private static final ItemStack TEMPLATE_STACK = new ItemStack((IItemProvider)ModBlocks.TEMPLATE_FRAME);
    private final List<ItemStack> blockList = new ArrayList<ItemStack>();
    private final boolean mimic = this.getAugmentCount(ModItems.MIMIC_AUGMENT) > 0;

    public CompiledExtruderModule2(TileEntityItemRouter router, ItemStack stack) {
        super(router, stack);
        ContainerExtruder2Module.TemplateHandler handler = new ContainerExtruder2Module.TemplateHandler(stack);
        block0: for (int i = 0; i < handler.getSlots() && this.blockList.size() < this.getRange(); ++i) {
            ItemStack stack1 = handler.getStackInSlot(i);
            for (int j = 0; j < stack1.func_190916_E(); ++j) {
                ItemStack copy = stack1.func_77946_l();
                copy.func_190920_e(1);
                this.blockList.add(copy);
                if (this.blockList.size() >= this.getRange()) continue block0;
            }
        }
    }

    @Override
    public boolean execute(@Nonnull TileEntityItemRouter router) {
        boolean extend = this.shouldExtend(router);
        World world = router.func_145831_w();
        if (extend && this.distance < this.blockList.size()) {
            if (!(this.blockList.get(this.distance).func_77973_b() instanceof BlockItem)) {
                router.getExtData().func_74768_a("ExtruderDist" + this.getFacing(), ++this.distance);
            } else {
                BlockPos placePos = router.func_174877_v().func_177967_a(this.getFacing(), this.distance + 1);
                BlockState state = BlockUtil.tryPlaceAsBlock(TEMPLATE_STACK, world, placePos, this.getFacing(), this.getRouterFacing());
                if (state != null) {
                    TileEntityTemplateFrame te = TileEntityTemplateFrame.getTileEntitySafely((IBlockReader)world, placePos);
                    if (te != null) {
                        te.setCamouflage(this.blockList.get(this.distance), this.getFacing(), this.getRouterFacing());
                        te.setExtendedMimic(this.mimic);
                        if (this.mimic) {
                            world.func_195593_d(placePos, state.func_177230_c());
                        }
                    }
                    router.playSound(null, placePos, state.func_177230_c().getSoundType(state, (IWorldReader)world, placePos, null).func_185841_e(), SoundCategory.BLOCKS, 1.0f, 0.5f + (float)this.distance * 0.1f);
                    router.getExtData().func_74768_a("ExtruderDist" + this.getFacing(), ++this.distance);
                    this.tryPushEntities(router.func_145831_w(), placePos, this.getFacing());
                    return true;
                }
            }
        } else if (!extend && this.distance > 0) {
            BlockPos breakPos = router.func_174877_v().func_177967_a(this.getFacing(), this.distance);
            BlockState oldState = world.func_180495_p(breakPos);
            router.getExtData().func_74768_a("ExtruderDist" + this.getFacing(), --this.distance);
            if (this.okToBreak(oldState, world, breakPos)) {
                BlockUtil.BreakResult breakResult = BlockUtil.tryBreakBlock(world, breakPos, this.getFilter(), false, 0);
                if (breakResult.isBlockBroken()) {
                    router.playSound(null, breakPos, ModBlocks.TEMPLATE_FRAME.getSoundType(oldState, (IWorldReader)world, breakPos, null).func_185845_c(), SoundCategory.BLOCKS, 1.0f, 0.5f + (float)this.distance * 0.1f);
                }
                return true;
            }
        }
        return false;
    }

    private boolean okToBreak(BlockState state, World world, BlockPos pos) {
        Block b = state.func_177230_c();
        return b.isAir(state, (IBlockReader)world, pos) || b == ModBlocks.TEMPLATE_FRAME || b instanceof IFluidBlock;
    }
}

