/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.compiled;

import javax.annotation.Nonnull;
import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.config.ConfigHandler;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.core.ModSounds;
import me.desht.modularrouters.item.module.ItemModule;
import me.desht.modularrouters.logic.ModuleTarget;
import me.desht.modularrouters.logic.compiled.CompiledDropperModule;
import me.desht.modularrouters.util.ModuleHelper;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;

public class CompiledFlingerModule
extends CompiledDropperModule {
    public static final String NBT_SPEED = "Speed";
    public static final String NBT_PITCH = "Pitch";
    public static final String NBT_YAW = "Yaw";
    private final float speed;
    private final float pitch;
    private final float yaw;

    public CompiledFlingerModule(TileEntityItemRouter router, ItemStack stack) {
        super(router, stack);
        CompoundNBT compound = ModuleHelper.validateNBT(stack);
        for (String key : new String[]{NBT_SPEED, NBT_PITCH, NBT_YAW}) {
            if (compound.func_74764_b(key)) continue;
            compound.func_74776_a(key, 0.0f);
        }
        this.speed = compound.func_74760_g(NBT_SPEED);
        this.pitch = compound.func_74760_g(NBT_PITCH);
        this.yaw = compound.func_74760_g(NBT_YAW);
    }

    @Override
    public boolean execute(@Nonnull TileEntityItemRouter router) {
        boolean fired = super.execute(router);
        if (fired && ((Boolean)ConfigHandler.MODULE.flingerEffects.get()).booleanValue()) {
            ModuleTarget target = this.getTarget();
            int n = Math.round(this.speed * 5.0f);
            BlockPos pos = target.gPos.func_218180_b();
            if (router.getUpgradeCount(ModItems.MUFFLER_UPGRADE) < 2) {
                ((ServerWorld)router.func_145831_w()).func_195598_a((IParticleData)ParticleTypes.field_197594_E, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, n, 0.0, 0.0, 0.0, 0.0);
            }
            router.playSound(null, pos, ModSounds.THUD, SoundCategory.BLOCKS, 0.5f + this.speed, 1.0f);
        }
        return fired;
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public float getSpeed() {
        return this.speed;
    }

    @Override
    protected void setupItemVelocity(TileEntityItemRouter router, ItemEntity item) {
        float baseYaw;
        Direction routerFacing = router.getAbsoluteFacing(ItemModule.RelativeDirection.FRONT);
        float basePitch = 0.0f;
        switch (this.getDirection()) {
            case UP: {
                basePitch = 90.0f;
                baseYaw = this.yawFromFacing(routerFacing);
                break;
            }
            case DOWN: {
                basePitch = -90.0f;
                baseYaw = this.yawFromFacing(routerFacing);
                break;
            }
            default: {
                baseYaw = this.yawFromFacing(this.getFacing());
            }
        }
        double yawRad = Math.toRadians(baseYaw + this.yaw);
        double pitchRad = Math.toRadians(basePitch + this.pitch);
        double x = Math.cos(yawRad) * Math.cos(pitchRad);
        double y = Math.sin(pitchRad);
        double z = -(Math.sin(yawRad) * Math.cos(pitchRad));
        item.func_213293_j(x * (double)this.speed, y * (double)this.speed, z * (double)this.speed);
    }

    private float yawFromFacing(Direction absoluteFacing) {
        switch (absoluteFacing) {
            case EAST: {
                return 0.0f;
            }
            case NORTH: {
                return 90.0f;
            }
            case WEST: {
                return 180.0f;
            }
            case SOUTH: {
                return 270.0f;
            }
        }
        return 0.0f;
    }
}

