/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.compiled;

import javax.annotation.Nonnull;
import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.config.ConfigHandler;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.logic.ModuleTarget;
import me.desht.modularrouters.logic.compiled.CompiledModule;
import me.desht.modularrouters.network.ItemBeamMessage;
import me.desht.modularrouters.network.PacketHandler;
import me.desht.modularrouters.util.BlockUtil;
import me.desht.modularrouters.util.InventoryUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class CompiledSenderModule1
extends CompiledModule {
    public CompiledSenderModule1(TileEntityItemRouter router, ItemStack stack) {
        super(router, stack);
    }

    @Override
    public boolean execute(@Nonnull TileEntityItemRouter router) {
        PositionedItemHandler positionedItemHandler;
        IItemHandler buffer = router.getBuffer();
        ItemStack bufferStack = buffer.getStackInSlot(0);
        if (this.getFilter().test(bufferStack) && (positionedItemHandler = this.findTargetInventory(router)).isValid()) {
            int sent;
            int nToSend = this.getItemsPerTick(router);
            if (this.getRegulationAmount() > 0) {
                int existing = InventoryUtils.countItems(bufferStack, positionedItemHandler.handler, this.getRegulationAmount(), !this.getFilter().getFlags().isIgnoreDamage());
                if ((nToSend = Math.min(nToSend, this.getRegulationAmount() - existing)) <= 0) {
                    return false;
                }
            }
            if ((sent = InventoryUtils.transferItems(buffer, positionedItemHandler.handler, 0, nToSend)) > 0) {
                if (((Boolean)ConfigHandler.MODULE.senderParticles.get()).booleanValue()) {
                    this.playParticles(router, positionedItemHandler.pos, ItemHandlerHelper.copyStackWithSize((ItemStack)bufferStack, (int)sent));
                }
                return true;
            }
            return false;
        }
        return false;
    }

    void playParticles(TileEntityItemRouter router, BlockPos targetPos, ItemStack stack) {
        if (router.getUpgradeCount(ModItems.MUFFLER_UPGRADE) < 2) {
            Vec3d vec1 = new Vec3d((Vec3i)router.func_174877_v());
            PacketDistributor.TargetPoint tp = new PacketDistributor.TargetPoint(vec1.field_72450_a, vec1.field_72448_b, vec1.field_72449_c, 32.0, router.func_145831_w().field_73011_w.func_186058_p());
            PacketHandler.NETWORK.send(PacketDistributor.NEAR.with(() -> tp), (Object)new ItemBeamMessage(router.func_174877_v(), targetPos, stack, this.getBeamColor(), router.getTickRate()));
        }
    }

    protected int getBeamColor() {
        return 0xFFC000;
    }

    PositionedItemHandler findTargetInventory(TileEntityItemRouter router) {
        ModuleTarget target = this.getEffectiveTarget(router);
        if (target != null) {
            return (PositionedItemHandler)target.getItemHandler().map(h -> new PositionedItemHandler(target.gPos.func_218180_b(), (IItemHandler)h)).orElse((Object)PositionedItemHandler.INVALID);
        }
        return PositionedItemHandler.INVALID;
    }

    @Override
    public ModuleTarget getEffectiveTarget(TileEntityItemRouter router) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(this.getTarget().gPos.func_218180_b());
        Direction face = this.getTarget().face;
        World world = router.func_145831_w();
        for (int i = 1; i <= this.getRange(); ++i) {
            if (world.func_175625_s((BlockPos)pos) != null) {
                GlobalPos gPos = GlobalPos.func_218179_a((DimensionType)world.func_201675_m().func_186058_p(), (BlockPos)pos.func_185334_h());
                return new ModuleTarget(gPos, face, BlockUtil.getBlockName(world, (BlockPos)pos));
            }
            if (!this.isPassable(world, (BlockPos)pos, face)) {
                return null;
            }
            pos.func_189536_c(this.getFacing());
        }
        return null;
    }

    private boolean isPassable(World w, BlockPos pos, Direction face) {
        BlockState state = w.func_180495_p(pos);
        return !Block.func_220056_d((BlockState)state, (IBlockReader)w, (BlockPos)pos, (Direction)face.func_176734_d()) || !state.func_200015_d((IBlockReader)w, pos);
    }

    static class PositionedItemHandler {
        private final BlockPos pos;
        private final IItemHandler handler;
        public static PositionedItemHandler INVALID = new PositionedItemHandler(null, null);

        PositionedItemHandler(BlockPos pos, IItemHandler handler) {
            this.pos = pos;
            this.handler = handler;
        }

        public boolean isValid() {
            return this.pos != null && this.handler != null;
        }
    }
}

