/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.filter;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Predicate;
import me.desht.modularrouters.container.handler.BaseModuleHandler;
import me.desht.modularrouters.item.module.ItemModule;
import me.desht.modularrouters.item.smartfilter.ItemSmartFilter;
import me.desht.modularrouters.logic.filter.matchers.FluidMatcher;
import me.desht.modularrouters.logic.filter.matchers.IItemMatcher;
import me.desht.modularrouters.util.ModuleHelper;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.Validate;

public class Filter
implements Predicate<ItemStack> {
    public static final int FILTER_SIZE = 9;
    private final Flags flags;
    private final List<IItemMatcher> matchers = Lists.newArrayList();

    public Filter() {
        this.flags = Flags.DEFAULT_FLAGS;
    }

    public Filter(ItemStack moduleStack) {
        if (moduleStack.func_77973_b() instanceof ItemModule && moduleStack.func_77942_o()) {
            this.flags = new Flags(moduleStack);
            BaseModuleHandler.ModuleFilterHandler filterHandler = new BaseModuleHandler.ModuleFilterHandler(moduleStack);
            for (int i = 0; i < filterHandler.getSlots(); ++i) {
                IItemMatcher matcher;
                ItemStack filterStack = filterHandler.getStackInSlot(i);
                if (filterStack.func_190926_b() || (matcher = this.createMatcher(filterStack, moduleStack)) == null) continue;
                this.matchers.add(matcher);
            }
        } else {
            this.flags = Flags.DEFAULT_FLAGS;
        }
    }

    private IItemMatcher createMatcher(ItemStack filterStack, ItemStack moduleStack) {
        if (filterStack.func_77973_b() instanceof ItemSmartFilter) {
            return ((ItemSmartFilter)filterStack.func_77973_b()).compile(filterStack, moduleStack);
        }
        return moduleStack.func_77973_b() instanceof ItemModule ? ((ItemModule)moduleStack.func_77973_b()).getFilterItemMatcher(filterStack) : null;
    }

    @Override
    public boolean test(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        for (IItemMatcher matcher : this.matchers) {
            if (!matcher.matchItem(stack, this.flags)) continue;
            return !this.flags.isBlacklist();
        }
        return this.flags.isBlacklist();
    }

    public boolean testFluid(Fluid fluid) {
        for (IItemMatcher matcher : this.matchers) {
            if (!(matcher instanceof FluidMatcher) || !((FluidMatcher)matcher).matchFluid(fluid, this.flags)) continue;
            return !this.flags.isBlacklist();
        }
        return this.flags.isBlacklist();
    }

    public Flags getFlags() {
        return this.flags;
    }

    public static class Flags {
        public static final Flags DEFAULT_FLAGS = new Flags();
        private final boolean blacklist;
        private final boolean ignoreDamage;
        private final boolean ignoreNBT;
        private final boolean ignoreTags;

        public Flags(ItemStack moduleStack) {
            Validate.isTrue((boolean)(moduleStack.func_77973_b() instanceof ItemModule));
            this.blacklist = ModuleHelper.isBlacklist(moduleStack);
            this.ignoreDamage = ModuleHelper.ignoreDamage(moduleStack);
            this.ignoreNBT = ModuleHelper.ignoreNBT(moduleStack);
            this.ignoreTags = ModuleHelper.ignoreTags(moduleStack);
        }

        public Flags() {
            this.blacklist = ItemModule.ModuleFlags.BLACKLIST.getDefaultValue();
            this.ignoreDamage = ItemModule.ModuleFlags.IGNORE_DAMAGE.getDefaultValue();
            this.ignoreNBT = ItemModule.ModuleFlags.IGNORE_NBT.getDefaultValue();
            this.ignoreTags = ItemModule.ModuleFlags.IGNORE_TAGS.getDefaultValue();
        }

        public Flags(byte mask) {
            this.blacklist = (mask & ItemModule.ModuleFlags.BLACKLIST.getMask()) != 0;
            this.ignoreDamage = (mask & ItemModule.ModuleFlags.IGNORE_DAMAGE.getMask()) != 0;
            this.ignoreNBT = (mask & ItemModule.ModuleFlags.IGNORE_NBT.getMask()) != 0;
            this.ignoreTags = (mask & ItemModule.ModuleFlags.IGNORE_TAGS.getMask()) != 0;
        }

        public boolean isBlacklist() {
            return this.blacklist;
        }

        public boolean isIgnoreDamage() {
            return this.ignoreDamage;
        }

        public boolean isIgnoreNBT() {
            return this.ignoreNBT;
        }

        public boolean matchTags() {
            return !this.ignoreTags;
        }

        public static Flags with(ItemModule.ModuleFlags ... flags) {
            byte mask = 0;
            for (ItemModule.ModuleFlags flag : flags) {
                mask = (byte)(mask | flag.getMask());
            }
            return new Flags(mask);
        }
    }
}

