/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.filter.matchers;

import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Set;
import me.desht.modularrouters.logic.filter.Filter;
import me.desht.modularrouters.logic.filter.matchers.IItemMatcher;
import me.desht.modularrouters.util.SetofItemStack;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class BulkItemMatcher
implements IItemMatcher {
    private final SetofItemStack stacks;
    private final Set<ResourceLocation> tags;

    public BulkItemMatcher(SetofItemStack stacks, Filter.Flags flags) {
        this.stacks = stacks;
        this.tags = Sets.newHashSet();
        if (flags.matchTags()) {
            ObjectIterator objectIterator = stacks.iterator();
            while (objectIterator.hasNext()) {
                ItemStack stack = (ItemStack)objectIterator.next();
                this.tags.addAll(stack.func_77973_b().getTags());
            }
        }
    }

    @Override
    public boolean matchItem(ItemStack stack, Filter.Flags flags) {
        if (this.stacks.contains(stack)) {
            return true;
        }
        return flags.matchTags() && this.matchTags(stack);
    }

    private boolean matchTags(ItemStack stack) {
        return !Sets.intersection((Set)stack.func_77973_b().getTags(), this.tags).isEmpty();
    }
}

