/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.network;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.Validate;

public class PacketUtil {
    public static int varIntByteCount(int toCount) {
        return (toCount & 0xFFFFFF80) == 0 ? 1 : ((toCount & 0xFFFFC000) == 0 ? 2 : ((toCount & 0xFFE00000) == 0 ? 3 : ((toCount & 0xF0000000) == 0 ? 4 : 5)));
    }

    public static int readVarInt(ByteBuf buf, int maxSize) {
        byte b0;
        Validate.isTrue((maxSize < 6 && maxSize > 0 ? 1 : 0) != 0, (String)"Varint length is between 1 and 5, not %d", (long)maxSize);
        int i = 0;
        int j = 0;
        do {
            b0 = buf.readByte();
            i |= (b0 & 0x7F) << j++ * 7;
            if (j <= maxSize) continue;
            throw new RuntimeException("VarInt too big");
        } while ((b0 & 0x80) == 128);
        return i;
    }

    public static void writeVarInt(ByteBuf to, int toWrite, int maxSize) {
        Validate.isTrue((PacketUtil.varIntByteCount(toWrite) <= maxSize ? 1 : 0) != 0, (String)"Integer is too big for %d bytes", (long)maxSize);
        while ((toWrite & 0xFFFFFF80) != 0) {
            to.writeByte(toWrite & 0x7F | 0x80);
            toWrite >>>= 7;
        }
        to.writeByte(toWrite);
    }

    public static String readUTF8String(ByteBuf from) {
        int len = PacketUtil.readVarInt(from, 2);
        String str = from.toString(from.readerIndex(), len, StandardCharsets.UTF_8);
        from.readerIndex(from.readerIndex() + len);
        return str;
    }

    public static void writeUTF8String(ByteBuf to, String string) {
        byte[] utf8Bytes = string.getBytes(StandardCharsets.UTF_8);
        Validate.isTrue((PacketUtil.varIntByteCount(utf8Bytes.length) < 3 ? 1 : 0) != 0, (String)"The string is too long for this encoding.", (Object[])new Object[0]);
        PacketUtil.writeVarInt(to, utf8Bytes.length, 2);
        to.writeBytes(utf8Bytes);
    }
}

