/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.network;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import me.desht.modularrouters.ModularRouters;
import me.desht.modularrouters.network.PacketHandler;
import me.desht.modularrouters.network.PacketUtil;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;

public class PlaySoundMessage {
    private ResourceLocation soundName;
    private float volume;
    private float pitch;

    public static void playSound(PlayerEntity player, SoundEvent soundEvent, float volume, float pitch) {
        if (player instanceof ServerPlayerEntity) {
            PacketHandler.NETWORK.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new PlaySoundMessage(soundEvent, volume, pitch));
        }
    }

    public PlaySoundMessage() {
    }

    private PlaySoundMessage(SoundEvent soundEvent, float volume, float pitch) {
        this.soundName = soundEvent.getRegistryName();
        this.volume = volume;
        this.pitch = pitch;
    }

    public PlaySoundMessage(ByteBuf buf) {
        this.soundName = new ResourceLocation(PacketUtil.readUTF8String(buf));
        this.volume = buf.readFloat();
        this.pitch = buf.readFloat();
    }

    public void toBytes(ByteBuf buffer) {
        PacketUtil.writeUTF8String(buffer, this.soundName.toString());
        buffer.writeFloat(this.volume);
        buffer.writeFloat(this.pitch);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            PlayerEntity player = ModularRouters.proxy.getClientPlayer();
            if (player != null) {
                player.func_184185_a((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(this.soundName), this.volume, this.pitch);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

