/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.network;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.logic.RouterRedstoneBehaviour;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class RouterSettingsMessage {
    private boolean eco;
    private TileEntityItemRouter router;
    private RouterRedstoneBehaviour redstoneBehaviour;

    public RouterSettingsMessage() {
    }

    public RouterSettingsMessage(TileEntityItemRouter router, RouterRedstoneBehaviour redstoneBehaviour, boolean ecoMode) {
        this.router = router;
        this.redstoneBehaviour = redstoneBehaviour;
        this.eco = ecoMode;
    }

    public RouterSettingsMessage(PacketBuffer buffer) {
        BlockPos pos = new BlockPos(buffer.readInt(), buffer.readInt(), buffer.readInt());
        ServerWorld world = RouterSettingsMessage.getWorldForDimensionId(buffer.readInt());
        if (world != null) {
            this.router = TileEntityItemRouter.getRouterAt((IBlockReader)world, pos).orElseThrow(() -> new IllegalStateException("router missing at " + pos));
        }
        this.redstoneBehaviour = RouterRedstoneBehaviour.values()[buffer.readByte()];
        this.eco = buffer.readBoolean();
    }

    public void toBytes(ByteBuf byteBuf) {
        byteBuf.writeInt(this.router.func_174877_v().func_177958_n());
        byteBuf.writeInt(this.router.func_174877_v().func_177956_o());
        byteBuf.writeInt(this.router.func_174877_v().func_177952_p());
        byteBuf.writeInt(RouterSettingsMessage.getDimensionForWorld(this.router.func_145831_w()));
        byteBuf.writeByte(this.redstoneBehaviour.ordinal());
        byteBuf.writeBoolean(this.eco);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (this.router != null) {
                this.router.setRedstoneBehaviour(this.redstoneBehaviour);
                this.router.setEcoMode(this.eco);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private static ServerWorld getWorldForDimensionId(int dimId) {
        DimensionType dt = DimensionType.func_186069_a((int)dimId);
        if (dt == null) {
            return null;
        }
        return DimensionManager.getWorld((MinecraftServer)ServerLifecycleHooks.getCurrentServer(), (DimensionType)dt, (boolean)true, (boolean)true);
    }

    private static int getDimensionForWorld(World w) {
        return w.func_201675_m().func_186058_p().func_186068_a();
    }
}

