/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.network;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import me.desht.modularrouters.ModularRouters;
import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class RouterUpgradesSyncMessage {
    private BlockPos pos;
    private ItemStackHandler handler;

    public RouterUpgradesSyncMessage() {
    }

    public RouterUpgradesSyncMessage(TileEntityItemRouter router) {
        this.pos = router.func_174877_v();
        IItemHandler upgradesHandler = router.getUpgrades();
        this.handler = new ItemStackHandler(upgradesHandler.getSlots());
        for (int i = 0; i < upgradesHandler.getSlots(); ++i) {
            this.handler.setStackInSlot(i, upgradesHandler.getStackInSlot(i));
        }
    }

    public RouterUpgradesSyncMessage(ByteBuf buf) {
        PacketBuffer pb = new PacketBuffer(buf);
        this.pos = pb.func_179259_c();
        this.handler = new ItemStackHandler();
        this.handler.deserializeNBT(pb.func_150793_b());
    }

    public void toBytes(ByteBuf buf) {
        PacketBuffer pb = new PacketBuffer(buf);
        pb.func_179255_a(this.pos);
        pb.func_150786_a(this.handler.serializeNBT());
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            World w = ModularRouters.proxy.theClientWorld();
            if (w != null) {
                TileEntityItemRouter.getRouterAt((IBlockReader)Minecraft.func_71410_x().field_71441_e, this.pos).ifPresent(router -> router.setUpgradesFrom((IItemHandler)this.handler));
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

