/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.util;

import java.util.Optional;
import javax.annotation.Nonnull;
import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.container.handler.BaseModuleHandler;
import me.desht.modularrouters.item.module.ItemModule;
import me.desht.modularrouters.item.smartfilter.ItemSmartFilter;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import org.apache.commons.lang3.Validate;

public class MFLocator {
    public final Hand hand;
    public final BlockPos routerPos;
    public final int routerSlot;
    public final int filterSlot;
    private final ItemType itemType;

    private MFLocator(ItemType itemType, Hand hand, BlockPos routerPos, int routerSlot, int filterSlot) {
        this.itemType = itemType;
        this.hand = hand;
        this.routerPos = routerPos;
        this.routerSlot = routerSlot;
        this.filterSlot = filterSlot;
        Validate.isTrue((hand != null || routerPos != null && routerSlot >= 0 ? 1 : 0) != 0);
    }

    public static MFLocator heldModule(Hand hand) {
        return new MFLocator(ItemType.MODULE, hand, null, -1, -1);
    }

    public static MFLocator heldFilter(Hand hand) {
        return new MFLocator(ItemType.FILTER, hand, null, -1, -1);
    }

    public static MFLocator moduleInRouter(BlockPos routerPos, int routerSlot) {
        return new MFLocator(ItemType.MODULE, null, routerPos, routerSlot, -1);
    }

    public static MFLocator filterInHeldModule(Hand hand, int filterSlot) {
        return new MFLocator(ItemType.FILTER, hand, null, -1, filterSlot);
    }

    public static MFLocator filterInInstalledModule(BlockPos routerPos, int routerSlot, int filterSlot) {
        return new MFLocator(ItemType.FILTER, null, routerPos, routerSlot, filterSlot);
    }

    public static MFLocator fromBuffer(PacketBuffer buf) {
        ItemType type = ItemType.values()[buf.readByte()];
        Hand hand = null;
        BlockPos routerPos = null;
        int routerSlot = -1;
        if (buf.readBoolean()) {
            routerPos = buf.func_179259_c();
            routerSlot = buf.readByte();
        } else {
            hand = buf.readBoolean() ? Hand.MAIN_HAND : Hand.OFF_HAND;
        }
        byte filterSlot = buf.readByte();
        return new MFLocator(type, hand, routerPos, routerSlot, filterSlot);
    }

    public void writeBuf(PacketBuffer buf) {
        buf.writeByte(this.itemType.ordinal());
        buf.writeBoolean(this.routerPos != null);
        if (this.routerPos != null) {
            buf.func_179255_a(this.routerPos);
            buf.writeByte(this.routerSlot);
        } else {
            buf.writeBoolean(this.hand == Hand.MAIN_HAND);
        }
        buf.writeByte(this.filterSlot);
    }

    @Nonnull
    public ItemStack getTargetItem(PlayerEntity player) {
        if (this.itemType == ItemType.MODULE) {
            if (this.hand != null) {
                return player.func_184586_b(this.hand).func_77973_b() instanceof ItemModule ? player.func_184586_b(this.hand) : ItemStack.field_190927_a;
            }
            if (this.routerPos != null && this.routerSlot >= 0) {
                return this.getInstalledModule(player.field_70170_p);
            }
        } else if (this.itemType == ItemType.FILTER) {
            if (this.hand != null) {
                return this.getFilterForStack(player.func_184586_b(this.hand));
            }
            if (this.routerPos != null && this.routerSlot >= 0) {
                return this.getFilterForStack(this.getInstalledModule(player.field_70170_p));
            }
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack getModuleStack(PlayerEntity player) {
        if (this.hand != null) {
            return player.func_184586_b(this.hand).func_77973_b() instanceof ItemModule ? player.func_184586_b(this.hand) : ItemStack.field_190927_a;
        }
        if (this.routerPos != null) {
            return this.getInstalledModule(player.field_70170_p);
        }
        return ItemStack.field_190927_a;
    }

    public Optional<TileEntityItemRouter> getRouter(World world) {
        return this.routerPos == null ? Optional.empty() : TileEntityItemRouter.getRouterAt((IBlockReader)world, this.routerPos);
    }

    @Nonnull
    private ItemStack getInstalledModule(World world) {
        return this.getRouter(world).map(router -> router.getModules().getStackInSlot(this.routerSlot)).orElse(ItemStack.field_190927_a);
    }

    @Nonnull
    private ItemStack getFilterForStack(@Nonnull ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemSmartFilter) {
            return stack;
        }
        if (stack.func_77973_b() instanceof ItemModule && this.filterSlot >= 0) {
            return new BaseModuleHandler.ModuleFilterHandler(stack).getStackInSlot(this.filterSlot);
        }
        return ItemStack.field_190927_a;
    }

    public static enum ItemType {
        MODULE,
        FILTER;

    }
}

