/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.util;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.commons.lang3.text.WordUtils;

public class MiscUtil {
    private static final int WRAP_LENGTH = 45;

    public static void appendMultiline(List<String> result, String key, Object ... args) {
        ITextComponent raw = MiscUtil.xlate(key, args);
        int n = 0;
        for (String s : raw.getString().split("\\\\n")) {
            for (String s1 : WordUtils.wrap((String)s, (int)45).split("\\\n")) {
                result.add((n++ > 0 ? "\u00a77" : "") + s1);
            }
        }
    }

    public static void appendMultilineText(List<ITextComponent> result, TextFormatting formatting, String key, Object ... args) {
        for (String s : I18n.func_135052_a((String)key, (Object[])args).split("\\\\n")) {
            for (String s1 : WordUtils.wrap((String)s, (int)45).split("\\\n")) {
                StringTextComponent textComponent = new StringTextComponent(s1);
                result.add(textComponent.func_211708_a(formatting));
            }
        }
    }

    public static String[] splitLong(String key, int len, Object ... args) {
        return WordUtils.wrap((String)I18n.func_135052_a((String)key, (Object[])args), (int)len, (String)"=CUT", (boolean)false, (String)"\\n").split("=CUT");
    }

    public static List<String> wrapString(String text) {
        return MiscUtil.wrapString(text, 45);
    }

    public static List<String> wrapString(String text, int maxCharPerLine) {
        StringTokenizer tok = new StringTokenizer(text, " ");
        StringBuilder output = new StringBuilder(text.length());
        ArrayList<String> textList = new ArrayList<String>();
        String color = "";
        int lineLen = 0;
        while (tok.hasMoreTokens()) {
            String word = tok.nextToken();
            if (word.contains("\u00a7")) {
                for (int i = 0; i < word.length() - 1; ++i) {
                    if (!word.substring(i, i + 2).contains("\u00a7")) continue;
                    color = word.substring(i, i + 2);
                }
                lineLen -= 2;
            }
            if (lineLen + word.length() > maxCharPerLine || word.contains("\\n")) {
                word = word.replace("\\n", "");
                textList.add(output.toString());
                output.delete(0, output.length());
                output.append(color);
                lineLen = 0;
            } else if (lineLen > 0) {
                output.append(" ");
                ++lineLen;
            }
            output.append(word);
            lineLen += word.length();
        }
        textList.add(output.toString());
        return textList;
    }

    public static String locToString(int dim, BlockPos pos) {
        return String.format("DIM:%d [%d,%d,%d]", dim, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public static ITextComponent xlate(String key, Object ... args) {
        return new TranslationTextComponent(key, args);
    }

    public static ResourceLocation RL(String name) {
        return new ResourceLocation("modularrouters", name);
    }

    public static int getYawFromFacing(Direction facing) {
        switch (facing) {
            case NORTH: {
                return 180;
            }
            case SOUTH: {
                return 0;
            }
            case WEST: {
                return 90;
            }
            case EAST: {
                return -90;
            }
        }
        return 0;
    }

    public static ITextComponent settingsStr(String prefix, ITextComponent c) {
        return new StringTextComponent(prefix).func_150257_a(c);
    }

    public static CompoundNBT serializeGlobalPos(GlobalPos globalPos) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_218657_a("pos", (INBT)NBTUtil.func_186859_a((BlockPos)globalPos.func_218180_b()));
        tag.func_74778_a("dim", DimensionType.func_212678_a((DimensionType)globalPos.func_218177_a()).toString());
        return tag;
    }

    public static GlobalPos deserializeGlobalPos(CompoundNBT tag) {
        return GlobalPos.func_218179_a((DimensionType)DimensionType.func_193417_a((ResourceLocation)new ResourceLocation(tag.func_74779_i("dim"))), (BlockPos)NBTUtil.func_186861_c((CompoundNBT)tag.func_74775_l("pos")));
    }

    public static ServerWorld getWorldForGlobalPos(GlobalPos pos) {
        return DimensionManager.getWorld((MinecraftServer)ServerLifecycleHooks.getCurrentServer(), (DimensionType)pos.func_218177_a(), (boolean)false, (boolean)false);
    }
}

