/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.block;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import me.desht.modularrouters.block.BlockCamo;
import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.core.ModSounds;
import me.desht.modularrouters.logic.RouterRedstoneBehaviour;
import me.desht.modularrouters.network.PacketHandler;
import me.desht.modularrouters.network.RouterSettingsMessage;
import me.desht.modularrouters.network.RouterUpgradesSyncMessage;
import me.desht.modularrouters.util.InventoryUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class BlockItemRouter
extends BlockCamo {
    private static final float HARDNESS = 1.5f;
    private static final float BLAST_RESISTANCE = 6.0f;
    public static final DirectionProperty FACING = DirectionProperty.func_177712_a((String)"facing", (Predicate)Direction.Plane.HORIZONTAL);
    public static final BooleanProperty ACTIVE = BooleanProperty.func_177716_a((String)"active");
    public static final BooleanProperty CAN_EMIT = BooleanProperty.func_177716_a((String)"can_emit");

    public BlockItemRouter() {
        super(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(1.5f, 6.0f).func_200947_a(SoundType.field_185852_e).func_226896_b_());
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH)).func_206870_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)CAN_EMIT, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING, ACTIVE, CAN_EMIT});
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext ctx) {
        Direction enumfacing = ctx.func_195999_j() == null ? ctx.func_196000_l() : Direction.func_176733_a((double)ctx.func_195999_j().field_70177_z).func_176734_d();
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)enumfacing);
    }

    @Override
    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Override
    public VoxelShape getUncamouflagedShape(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext ctx) {
        return VoxelShapes.func_197868_b();
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileEntityItemRouter();
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntityItemRouter.getRouterAt((IBlockReader)world, pos).ifPresent(router -> {
                InventoryUtils.dropInventoryItems(world, pos, router.getBuffer());
                world.func_175666_e(pos, (Block)this);
                super.func_196243_a(state, world, pos, newState, isMoving);
            });
        }
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World world, BlockPos pos) {
        return TileEntityItemRouter.getRouterAt((IBlockReader)world, pos).map(router -> ItemHandlerHelper.calcRedstoneFromInventory((IItemHandler)router.getBuffer())).orElse(0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader player, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74775_l("BlockEntityTag") != null) {
            CompoundNBT compound = stack.func_77978_p().func_74775_l("BlockEntityTag");
            tooltip.add(new TranslationTextComponent("itemText.misc.routerConfigured", new Object[0]).func_211709_a(new TextFormatting[]{TextFormatting.GRAY, TextFormatting.ITALIC}));
            if (compound.func_74764_b("Modules")) {
                ArrayList<ITextComponent> moduleText = new ArrayList<ITextComponent>();
                ItemStackHandler modulesHandler = new ItemStackHandler(9);
                modulesHandler.deserializeNBT(compound.func_74775_l("Modules"));
                for (int i = 0; i < modulesHandler.getSlots(); ++i) {
                    ItemStack moduleStack = modulesHandler.getStackInSlot(i);
                    if (moduleStack.func_190926_b()) continue;
                    moduleText.add(new StringTextComponent("\u2022 ").func_150257_a(moduleStack.func_200301_q()).func_211708_a(TextFormatting.AQUA));
                }
                if (!moduleText.isEmpty()) {
                    tooltip.add(new TranslationTextComponent("itemText.misc.moduleCount", new Object[]{moduleText.size()}).func_211709_a(new TextFormatting[]{TextFormatting.YELLOW}));
                    tooltip.addAll(moduleText);
                }
            }
            if (compound.func_74764_b("Upgrades")) {
                ItemStackHandler upgradesHandler = new ItemStackHandler();
                upgradesHandler.deserializeNBT(compound.func_74775_l("Upgrades"));
                ArrayList<ITextComponent> upgradeText = new ArrayList<ITextComponent>();
                int nUpgrades = 0;
                for (int i = 0; i < upgradesHandler.getSlots(); ++i) {
                    ItemStack upgradeStack = upgradesHandler.getStackInSlot(i);
                    if (upgradeStack.func_190926_b()) continue;
                    nUpgrades += upgradeStack.func_190916_E();
                    upgradeText.add(new StringTextComponent("\u2022 " + upgradeStack.func_190916_E() + " x ").func_150257_a(upgradeStack.func_200301_q()).func_211708_a(TextFormatting.AQUA));
                }
                if (!upgradeText.isEmpty()) {
                    tooltip.add(new TranslationTextComponent("itemText.misc.upgradeCount", new Object[]{nUpgrades}).func_211709_a(new TextFormatting[]{TextFormatting.YELLOW}));
                    tooltip.addAll(upgradeText);
                }
            }
            if (compound.func_74764_b("Redstone")) {
                try {
                    RouterRedstoneBehaviour rrb = RouterRedstoneBehaviour.valueOf(compound.func_74779_i("Redstone"));
                    tooltip.add(new TranslationTextComponent("guiText.tooltip.redstone.label", new Object[0]).func_150258_a(": ").func_211708_a(TextFormatting.YELLOW).func_150257_a(new TranslationTextComponent("guiText.tooltip.redstone." + (Object)((Object)rrb), new Object[0]).func_211708_a(TextFormatting.RED)));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult blockRayTraceResult) {
        if (!player.func_226271_bk_()) {
            return TileEntityItemRouter.getRouterAt((IBlockReader)world, pos).map(router -> {
                if (router.isPermitted(player) && !world.field_72995_K) {
                    PacketHandler.NETWORK.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new RouterSettingsMessage((TileEntityItemRouter)router));
                    PacketHandler.NETWORK.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new RouterUpgradesSyncMessage((TileEntityItemRouter)router));
                    NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)router, (BlockPos)pos);
                } else if (!router.isPermitted(player) && world.field_72995_K) {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("chatText.security.accessDenied", new Object[0]), false);
                    player.func_184185_a((SoundEvent)ModSounds.ERROR.get(), 1.0f, 1.0f);
                }
                return ActionResultType.SUCCESS;
            }).orElse(ActionResultType.FAIL);
        }
        return ActionResultType.PASS;
    }

    @Override
    public boolean func_149744_f(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)CAN_EMIT);
    }

    @Override
    public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return TileEntityItemRouter.getRouterAt(blockAccess, pos).map(router -> {
            int l = router.getRedstoneLevel(side, false);
            return l < 0 ? super.func_180656_a(blockState, blockAccess, pos, side) : l;
        }).orElse(0);
    }

    @Override
    public int func_176211_b(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return TileEntityItemRouter.getRouterAt(blockAccess, pos).map(router -> {
            int l = router.getRedstoneLevel(side, true);
            return l < 0 ? super.func_176211_b(blockState, blockAccess, pos, side) : l;
        }).orElse(0);
    }

    public boolean canConnectRedstone(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
        return true;
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean b) {
        TileEntityItemRouter.getRouterAt((IBlockReader)worldIn, pos).ifPresent(router -> {
            router.checkForRedstonePulse();
            router.notifyModules();
        });
    }

    public boolean canEntityDestroy(BlockState state, IBlockReader world, BlockPos pos, Entity entity) {
        return TileEntityItemRouter.getRouterAt(world, pos).map(router -> router.getUpgradeCount((Item)ModItems.BLAST_UPGRADE.get()) <= 0 && super.canEntityDestroy(state, world, pos, entity)).orElse(true);
    }

    @Override
    public float getExplosionResistance(BlockState state, IWorldReader world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        return TileEntityItemRouter.getRouterAt((IBlockReader)world, pos).map(router -> Float.valueOf(router.getUpgradeCount((Item)ModItems.BLAST_UPGRADE.get()) > 0 ? 20000.0f : 6.0f)).orElse(Float.valueOf(0.0f)).floatValue();
    }
}

