/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.module;

import me.desht.modularrouters.client.gui.module.GuiModule;
import me.desht.modularrouters.client.gui.widgets.button.ItemStackButton;
import me.desht.modularrouters.client.gui.widgets.textfield.IntegerTextField;
import me.desht.modularrouters.client.gui.widgets.textfield.TextFieldManager;
import me.desht.modularrouters.container.ContainerModule;
import me.desht.modularrouters.logic.compiled.CompiledDetectorModule;
import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;

public class GuiModuleDetector
extends GuiModule {
    private static final ItemStack redstoneStack = new ItemStack((IItemProvider)Items.field_151137_ax);
    private boolean isStrong;
    private IntegerTextField intField;

    public GuiModuleDetector(ContainerModule container, PlayerInventory inv, ITextComponent displayName) {
        super(container, inv, displayName);
    }

    @Override
    public void init() {
        super.init();
        CompiledDetectorModule cdm = new CompiledDetectorModule(null, this.moduleItemStack);
        TextFieldManager manager = this.getOrCreateTextFieldManager();
        this.intField = new IntegerTextField(manager, this.font, this.field_147003_i + 152, this.field_147009_r + 19, 20, 12, 0, 15);
        this.intField.setValue(cdm.getSignalLevel());
        this.intField.func_212954_a(str -> this.sendModuleSettingsDelayed(5));
        this.intField.setIncr(1, 4);
        this.intField.useGuiTextBackground();
        manager.focus(0);
        String label = I18n.func_135052_a((String)("itemText.misc.strongSignal." + cdm.isStrongSignal()), (Object[])new Object[0]);
        this.isStrong = cdm.isStrongSignal();
        this.addButton((Widget)new Button(this.field_147003_i + 138, this.field_147009_r + 33, 40, 20, label, button -> {
            this.isStrong = !this.isStrong;
            button.setMessage(I18n.func_135052_a((String)("itemText.misc.strongSignal." + this.isStrong), (Object[])new Object[0]));
            this.sendToServer();
        }));
        this.addButton((Widget)new TooltipButton(this.field_147003_i + 132, this.field_147009_r + 15, 16, 16, redstoneStack));
        this.getMouseOverHelp().addHelpRegion(this.field_147003_i + 129, this.field_147009_r + 14, this.field_147003_i + 172, this.field_147009_r + 31, "guiText.popup.detector.signalLevel");
        this.getMouseOverHelp().addHelpRegion(this.field_147003_i + 135, this.field_147009_r + 31, this.field_147003_i + 180, this.field_147009_r + 54, "guiText.popup.detector.weakStrong");
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        this.blit(this.field_147003_i + 148, this.field_147009_r + 16, GuiModuleDetector.SMALL_TEXTFIELD_XY.x, GuiModuleDetector.SMALL_TEXTFIELD_XY.y, 21, 14);
    }

    @Override
    protected CompoundNBT buildMessageData() {
        CompoundNBT compound = super.buildMessageData();
        compound.func_74774_a("SignalLevel", (byte)this.intField.getValue());
        compound.func_74757_a("StrongSignal", this.isStrong);
        return compound;
    }

    private static class TooltipButton
    extends ItemStackButton {
        TooltipButton(int x, int y, int width, int height, ItemStack renderStack) {
            super(x, y, width, height, renderStack, true, p -> {});
            MiscUtil.appendMultiline(this.tooltip1, "guiText.tooltip.detectorTooltip", new Object[0]);
            MiscUtil.appendMultiline(this.tooltip1, "guiText.tooltip.numberFieldTooltip", new Object[0]);
        }

        public void playDownSound(SoundHandler soundHandlerIn) {
        }
    }
}

