/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.render.item_beam;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import me.desht.modularrouters.client.render.ModRenderTypes;
import me.desht.modularrouters.config.MRConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ILightReader;

public class ItemBeam {
    private final Vector3f startPos;
    private final Vector3f endPos;
    private final ItemStack renderItem;
    private final int[] colors;
    private final int lifeTime;
    private final boolean itemFade;
    private int ticksLived = 0;
    private static final Vector3f ROTATION = new Vector3f(0.15f, 1.0f, 0.0f);

    public ItemBeam(BlockPos pos1, BlockPos pos2, ItemStack renderItem, int color, int lifeTime, boolean itemFade) {
        this.startPos = new Vector3f((float)pos1.func_177958_n() + 0.5f, (float)pos1.func_177956_o() + 0.5f, (float)pos1.func_177952_p() + 0.5f);
        this.endPos = new Vector3f((float)pos2.func_177958_n() + 0.5f, (float)pos2.func_177956_o() + 0.5f, (float)pos2.func_177952_p() + 0.5f);
        this.renderItem = renderItem;
        this.colors = this.decompose(color);
        this.lifeTime = lifeTime;
        this.itemFade = itemFade;
    }

    private int[] decompose(int color) {
        int[] res = new int[]{color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF};
        return res;
    }

    public void tick() {
        ++this.ticksLived;
    }

    public void render(MatrixStack matrixStack, IRenderTypeBuffer.Impl buffer, float partialTicks) {
        float progress = ((float)this.ticksLived + partialTicks) / (float)this.lifeTime;
        if (MRConfig.Client.Misc.renderFlyingItems) {
            this.renderFlyingItem(matrixStack, buffer, progress);
        }
        this.renderBeamLine(matrixStack, buffer, progress);
    }

    private void renderFlyingItem(MatrixStack matrixStack, IRenderTypeBuffer.Impl buffer, float progress) {
        float iz;
        float iy;
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        float ix = MathHelper.func_219799_g((float)progress, (float)this.startPos.func_195899_a(), (float)this.endPos.func_195899_a());
        BlockPos pos = new BlockPos((double)ix, (double)(iy = MathHelper.func_219799_g((float)progress, (float)this.startPos.func_195900_b(), (float)this.endPos.func_195900_b())), (double)(iz = MathHelper.func_219799_g((float)progress, (float)this.startPos.func_195902_c(), (float)this.endPos.func_195902_c())));
        VoxelShape shape = world.func_180495_p(pos).func_196952_d((IBlockReader)world, pos);
        if (shape.func_197766_b() || !shape.func_197752_a().func_186670_a(pos).func_197744_e((double)ix, (double)iy, (double)iz)) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)ix, (double)iy - 0.15, (double)iz);
            matrixStack.func_227863_a_(ROTATION.func_229187_a_(progress * 360.0f));
            if (this.itemFade) {
                matrixStack.func_227862_a_(1.25f - progress, 1.25f - progress, 1.25f - progress);
                if ((double)progress > 0.9) {
                    world.func_195594_a((IParticleData)ParticleTypes.field_197599_J, (double)this.endPos.func_195899_a(), (double)this.endPos.func_195900_b(), (double)this.endPos.func_195902_c(), 0.5 - world.field_73012_v.nextDouble(), -0.5, 0.5 - world.field_73012_v.nextDouble());
                }
            }
            int l = WorldRenderer.func_228421_a_((ILightReader)world, (BlockPos)pos);
            ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
            itemRenderer.func_229110_a_(this.renderItem, ItemCameraTransforms.TransformType.GROUND, l, OverlayTexture.field_229196_a_, matrixStack, (IRenderTypeBuffer)buffer);
            matrixStack.func_227865_b_();
        }
    }

    private void renderBeamLine(MatrixStack matrixStack, IRenderTypeBuffer.Impl buffer, float progress) {
        int alpha = (int)((1.0 - Math.abs((double)progress - 0.5)) * 32.0 + 16.0);
        Matrix4f positionMatrix = matrixStack.func_227866_c_().func_227870_a_();
        IVertexBuilder builder = buffer.getBuffer(ModRenderTypes.BEAM_LINE_THICK);
        builder.func_227888_a_(positionMatrix, this.startPos.func_195899_a(), this.startPos.func_195900_b(), this.startPos.func_195902_c()).func_225586_a_(this.colors[0], this.colors[1], this.colors[2], alpha).func_181675_d();
        builder.func_227888_a_(positionMatrix, this.endPos.func_195899_a(), this.endPos.func_195900_b(), this.endPos.func_195902_c()).func_225586_a_(this.colors[0], this.colors[1], this.colors[2], alpha).func_181675_d();
        RenderSystem.disableDepthTest();
        buffer.func_228462_a_(ModRenderTypes.BEAM_LINE_THICK);
        IVertexBuilder builder2 = buffer.getBuffer(ModRenderTypes.BEAM_LINE_THIN);
        builder2.func_227888_a_(positionMatrix, this.startPos.func_195899_a(), this.startPos.func_195900_b(), this.startPos.func_195902_c()).func_225586_a_(this.colors[0], this.colors[1], this.colors[2], alpha).func_181675_d();
        builder2.func_227888_a_(positionMatrix, this.endPos.func_195899_a(), this.endPos.func_195900_b(), this.endPos.func_195902_c()).func_225586_a_(this.colors[0], this.colors[1], this.colors[2], alpha).func_181675_d();
        RenderSystem.disableDepthTest();
        buffer.func_228462_a_(ModRenderTypes.BEAM_LINE_THIN);
    }

    boolean isExpired() {
        return this.ticksLived >= this.lifeTime;
    }
}

