/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.render.item_beam;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import me.desht.modularrouters.client.render.item_beam.ItemBeam;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.profiler.IProfiler;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public enum ItemBeamDispatcher {
    INSTANCE;

    private static final int MAX_SIZE = 250;
    public final List<ItemBeam> beams = new ArrayList<ItemBeam>();

    public static ItemBeamDispatcher getInstance() {
        return INSTANCE;
    }

    public void addBeam(ItemBeam itemBeam) {
        if (this.beams.size() < 250) {
            this.beams.add(itemBeam);
        }
    }

    public void tick() {
        Iterator<ItemBeam> iterator = this.beams.iterator();
        while (iterator.hasNext()) {
            ItemBeam beam = iterator.next();
            beam.tick();
            if (!beam.isExpired()) continue;
            iterator.remove();
        }
    }

    @SubscribeEvent
    public void onWorldRender(RenderWorldLastEvent event) {
        if (this.beams.isEmpty()) {
            return;
        }
        IProfiler profiler = Minecraft.func_71410_x().func_213239_aq();
        profiler.func_76320_a("modularrouters-particles");
        IRenderTypeBuffer.Impl buffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        MatrixStack matrixStack = event.getMatrixStack();
        matrixStack.func_227860_a_();
        Vec3d projectedView = Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c();
        matrixStack.func_227861_a_(-projectedView.field_72450_a, -projectedView.field_72448_b, -projectedView.field_72449_c);
        for (ItemBeam beam : this.beams) {
            beam.render(matrixStack, buffer, event.getPartialTicks());
        }
        matrixStack.func_227865_b_();
        profiler.func_76319_b();
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            INSTANCE.tick();
        }
    }
}

