/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.container;

import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.container.ContainerMRBase;
import me.desht.modularrouters.container.handler.AugmentHandler;
import me.desht.modularrouters.container.handler.BaseModuleHandler;
import me.desht.modularrouters.core.ModContainerTypes;
import me.desht.modularrouters.item.augment.ItemAugment;
import me.desht.modularrouters.item.smartfilter.ItemSmartFilter;
import me.desht.modularrouters.util.MFLocator;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.SlotItemHandler;

public class ContainerModule
extends ContainerMRBase {
    public static final int AUGMENT_START = 9;
    private static final int INV_START = 13;
    private static final int INV_END = 39;
    private static final int HOTBAR_START = 40;
    private static final int HOTBAR_END = 48;
    private static final int PLAYER_INV_Y = 116;
    private static final int PLAYER_INV_X = 16;
    private static final int PLAYER_HOTBAR_Y = 174;
    private final BaseModuleHandler.ModuleFilterHandler filterHandler;
    private final AugmentHandler augmentHandler;
    private final int currentSlot;
    protected final TileEntityItemRouter router;
    private final MFLocator locator;

    public ContainerModule(int windowId, PlayerInventory inv, PacketBuffer extra) {
        this((ContainerType)ModContainerTypes.CONTAINER_MODULE_BASIC.get(), windowId, inv, MFLocator.fromBuffer(extra));
    }

    public ContainerModule(ContainerType type, int windowId, PlayerInventory inv, PacketBuffer extra) {
        this(type, windowId, inv, MFLocator.fromBuffer(extra));
    }

    public ContainerModule(ContainerType type, int windowId, PlayerInventory inv, MFLocator locator) {
        super(type, windowId);
        int i;
        this.locator = locator;
        this.router = locator.getRouter(inv.field_70458_d.field_70170_p).orElse(null);
        assert (this.router != null || locator.hand != null);
        ItemStack moduleStack = locator.getModuleStack(inv.field_70458_d);
        this.filterHandler = new BaseModuleHandler.ModuleFilterHandler(moduleStack, this.router);
        this.augmentHandler = new AugmentHandler(moduleStack, this.router);
        this.currentSlot = inv.field_70461_c + 40;
        for (i = 0; i < 9; ++i) {
            this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.filterHandler, i, 8 + 18 * (i % 3), 17 + 18 * (i / 3)));
        }
        for (i = 0; i < 4; ++i) {
            this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.augmentHandler, i, 78 + 18 * (i % 2), 75 + 18 * (i / 2)));
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)inv, j + i * 9 + 9, 16 + j * 18, 116 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)inv, i, 16 + i * 18, 174));
        }
    }

    public MFLocator getLocator() {
        return this.locator;
    }

    public TileEntityItemRouter getRouter() {
        return this.router;
    }

    protected void transferStackInExtraSlot(PlayerEntity player, int index) {
    }

    protected ItemStack slotClickExtraSlot(int slot, int dragType, ClickType clickTypeIn, PlayerEntity player) {
        return ItemStack.field_190927_a;
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return true;
    }

    public ItemStack func_82846_b(PlayerEntity player, int index) {
        Slot srcSlot = (Slot)this.field_75151_b.get(index);
        if (srcSlot != null && srcSlot.func_75216_d()) {
            if (index < 9) {
                srcSlot.func_75215_d(ItemStack.field_190927_a);
            } else if (index < 13) {
                ItemStack stackInSlot = srcSlot.func_75211_c();
                if (!this.func_75135_a(stackInSlot, 13, 49, false)) {
                    return ItemStack.field_190927_a;
                }
                srcSlot.func_75215_d(stackInSlot);
                this.func_75142_b();
            } else if (index <= 48) {
                ItemStack stackInSlot = srcSlot.func_75211_c();
                if (stackInSlot.func_77973_b() instanceof ItemAugment && this.augmentHandler.getHolderStack().func_190916_E() == 1) {
                    if (!this.func_75135_a(stackInSlot, 9, 13, false)) {
                        return ItemStack.field_190927_a;
                    }
                    this.func_75142_b();
                } else {
                    ItemStack stack = stackInSlot.func_77946_l();
                    stack.func_190920_e(1);
                    int firstFree = -1;
                    for (int i = 0; i < 9; ++i) {
                        ItemStack stack0 = this.filterHandler.getStackInSlot(i);
                        if (ItemStack.func_179545_c((ItemStack)stack0, (ItemStack)stack)) {
                            firstFree = i;
                            break;
                        }
                        if (firstFree >= 0 || !stack0.func_190926_b() || !this.filterHandler.isItemValid(i, stack)) continue;
                        firstFree = i;
                    }
                    if (firstFree >= 0) {
                        ((Slot)this.field_75151_b.get(firstFree)).func_75215_d(stack);
                        srcSlot.func_75215_d(stackInSlot);
                    }
                }
            } else {
                this.transferStackInExtraSlot(player, index);
            }
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_184996_a(int slot, int dragType, ClickType clickTypeIn, PlayerEntity player) {
        boolean forceUpdate = false;
        if (slot > 48) {
            return this.slotClickExtraSlot(slot, dragType, clickTypeIn, player);
        }
        if (slot >= 9 && slot < 13 && this.augmentHandler.getHolderStack().func_190916_E() > 1) {
            return ItemStack.field_190927_a;
        }
        switch (clickTypeIn) {
            case PICKUP: {
                if (this.router == null && slot == this.currentSlot) {
                    return ItemStack.field_190927_a;
                }
                if (slot >= 0 && slot < 9) {
                    Slot s = (Slot)this.field_75151_b.get(slot);
                    ItemStack stackOnCursor = player.field_71071_by.func_70445_o();
                    if (stackOnCursor.func_190926_b() || this.isItemOKForFilter(stackOnCursor, slot)) {
                        s.func_75215_d(stackOnCursor.func_190926_b() ? ItemStack.field_190927_a : ItemHandlerHelper.copyStackWithSize((ItemStack)stackOnCursor, (int)1));
                    }
                    return ItemStack.field_190927_a;
                }
                if (slot >= 9 && slot < 13 && this.augmentHandler.getHolderStack().func_190916_E() == 1) {
                    forceUpdate = true;
                }
            }
            case THROW: {
                if (slot >= 0 && slot < 9) {
                    return ItemStack.field_190927_a;
                }
                if (slot < 9 || slot >= 13 || this.augmentHandler.getHolderStack().func_190916_E() != 1) break;
                forceUpdate = true;
            }
        }
        ItemStack ret = super.func_184996_a(slot, dragType, clickTypeIn, player);
        if (forceUpdate) {
            ((Slot)this.field_75151_b.get(slot)).func_75215_d(((Slot)this.field_75151_b.get(slot)).func_75211_c());
            this.func_75142_b();
        }
        return ret;
    }

    private boolean isItemOKForFilter(ItemStack stack, int slot) {
        if (this.filterHandler.isItemValid(slot, stack)) {
            for (int i = 0; i < this.filterHandler.getSlots(); ++i) {
                if (this.filterHandler.getStackInSlot(i).func_77973_b() != stack.func_77973_b() || stack.func_77973_b() instanceof ItemSmartFilter) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean func_94531_b(Slot p_94531_1_) {
        return false;
    }
}

