/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.client;

import chumbanotz.mutantbeasts.MutantBeasts;
import chumbanotz.mutantbeasts.block.MBSkullBlock;
import chumbanotz.mutantbeasts.client.gui.screen.CreeperMinionTrackerScreen;
import chumbanotz.mutantbeasts.client.particle.EndersoulParticle;
import chumbanotz.mutantbeasts.client.particle.SkullSpiritParticle;
import chumbanotz.mutantbeasts.client.renderer.entity.BodyPartRenderer;
import chumbanotz.mutantbeasts.client.renderer.entity.CreeperMinionEggRenderer;
import chumbanotz.mutantbeasts.client.renderer.entity.CreeperMinionRenderer;
import chumbanotz.mutantbeasts.client.renderer.entity.EndersoulCloneRenderer;
import chumbanotz.mutantbeasts.client.renderer.entity.EndersoulFragmentRenderer;
import chumbanotz.mutantbeasts.client.renderer.entity.MutantArrowRenderer;
import chumbanotz.mutantbeasts.client.renderer.entity.MutantCreeperRenderer;
import chumbanotz.mutantbeasts.client.renderer.entity.MutantEndermanRenderer;
import chumbanotz.mutantbeasts.client.renderer.entity.MutantSkeletonRenderer;
import chumbanotz.mutantbeasts.client.renderer.entity.MutantSnowGolemRenderer;
import chumbanotz.mutantbeasts.client.renderer.entity.MutantZombieRenderer;
import chumbanotz.mutantbeasts.client.renderer.entity.SpiderPigRenderer;
import chumbanotz.mutantbeasts.client.renderer.entity.ThrowableBlockRenderer;
import chumbanotz.mutantbeasts.client.renderer.entity.layers.CreeperMinionShoulderLayer;
import chumbanotz.mutantbeasts.client.renderer.entity.model.SkullModel;
import chumbanotz.mutantbeasts.entity.CreeperMinionEntity;
import chumbanotz.mutantbeasts.entity.EndersoulCloneEntity;
import chumbanotz.mutantbeasts.entity.MBEntityType;
import chumbanotz.mutantbeasts.entity.mutant.MutantCreeperEntity;
import chumbanotz.mutantbeasts.entity.mutant.MutantEndermanEntity;
import chumbanotz.mutantbeasts.particles.MBParticleTypes;
import chumbanotz.mutantbeasts.tileentity.MBTileEntityTypes;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.entity.SpriteRenderer;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.SkullTileEntityRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="mutantbeasts", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public enum ClientEventHandler {
    INSTANCE;


    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        Map MODELS_MAP = (Map)ObfuscationReflectionHelper.getPrivateValue(SkullTileEntityRenderer.class, null, (String)"field_199358_e");
        Map SKIN_MAP = (Map)ObfuscationReflectionHelper.getPrivateValue(SkullTileEntityRenderer.class, null, (String)"field_199357_d");
        MODELS_MAP.put(MBSkullBlock.Types.MUTANT_SKELETON, new SkullModel());
        SKIN_MAP.put(MBSkullBlock.Types.MUTANT_SKELETON, MutantBeasts.getEntityTexture("mutant_skeleton"));
        ClientRegistry.bindTileEntityRenderer(MBTileEntityTypes.SKULL, SkullTileEntityRenderer::new);
        ClientRegistry.registerEntityShader(CreeperMinionEntity.class, (ResourceLocation)new ResourceLocation("shaders/post/creeper.json"));
        ClientRegistry.registerEntityShader(EndersoulCloneEntity.class, (ResourceLocation)new ResourceLocation("shaders/post/invert.json"));
        ClientRegistry.registerEntityShader(MutantCreeperEntity.class, (ResourceLocation)new ResourceLocation("shaders/post/creeper.json"));
        ClientRegistry.registerEntityShader(MutantEndermanEntity.class, (ResourceLocation)new ResourceLocation("shaders/post/invert.json"));
        RenderingRegistry.registerEntityRenderingHandler(MBEntityType.BODY_PART, BodyPartRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(MBEntityType.CHEMICAL_X, render -> new SpriteRenderer(render, Minecraft.func_71410_x().func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(MBEntityType.CREEPER_MINION, CreeperMinionRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(MBEntityType.CREEPER_MINION_EGG, CreeperMinionEggRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(MBEntityType.ENDERSOUL_CLONE, EndersoulCloneRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(MBEntityType.ENDERSOUL_FRAGMENT, EndersoulFragmentRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(MBEntityType.MUTANT_ARROW, MutantArrowRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(MBEntityType.MUTANT_CREEPER, MutantCreeperRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(MBEntityType.MUTANT_ENDERMAN, MutantEndermanRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(MBEntityType.MUTANT_SKELETON, MutantSkeletonRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(MBEntityType.MUTANT_SNOW_GOLEM, MutantSnowGolemRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(MBEntityType.MUTANT_ZOMBIE, MutantZombieRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(MBEntityType.SKULL_SPIRIT, manager -> new EntityRenderer<Entity>(manager){

            public ResourceLocation func_110775_a(Entity entity) {
                return null;
            }
        });
        RenderingRegistry.registerEntityRenderingHandler(MBEntityType.SPIDER_PIG, SpiderPigRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(MBEntityType.THROWABLE_BLOCK, ThrowableBlockRenderer::new);
        for (PlayerRenderer renderer : Minecraft.func_71410_x().func_175598_ae().getSkinMap().values()) {
            renderer.func_177094_a(new CreeperMinionShoulderLayer(renderer));
        }
    }

    @SubscribeEvent
    public static void onModelRegistry(ModelRegistryEvent event) {
        ModelLoader.addSpecialModel((ResourceLocation)new ModelResourceLocation(MutantBeasts.prefix("endersoul_hand_gui"), "inventory"));
        ModelLoader.addSpecialModel((ResourceLocation)new ModelResourceLocation(MutantBeasts.prefix("endersoul_hand_model"), "inventory"));
    }

    @SubscribeEvent
    public static void onParticleFactoryRegistry(ParticleFactoryRegisterEvent event) {
        Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)MBParticleTypes.ENDERSOUL, EndersoulParticle.Factory::new);
        Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)MBParticleTypes.SKULL_SPIRIT, SkullSpiritParticle.Factory::new);
    }

    public void displayCreeperMinionTrackerGUI(CreeperMinionEntity creeperMinion) {
        Minecraft.func_71410_x().func_147108_a((Screen)new CreeperMinionTrackerScreen(creeperMinion));
    }
}

