/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.client.renderer.entity;

import chumbanotz.mutantbeasts.MutantBeasts;
import chumbanotz.mutantbeasts.client.renderer.entity.model.MutantArrowModel;
import chumbanotz.mutantbeasts.entity.projectile.MutantArrowEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;

public class MutantArrowRenderer
extends EntityRenderer<MutantArrowEntity> {
    public static final ResourceLocation TEXTURE = MutantBeasts.getEntityTexture("mutant_arrow");
    private final MutantArrowModel arrowModel = new MutantArrowModel();

    public MutantArrowRenderer(EntityRendererManager renderManager) {
        super(renderManager);
    }

    public boolean shouldRender(MutantArrowEntity livingEntityIn, ClippingHelper camera, double camX, double camY, double camZ) {
        return true;
    }

    public void render(MutantArrowEntity entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        super.func_225623_a_((Entity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        for (int i = 0; i < entityIn.getClones(); ++i) {
            matrixStackIn.func_227860_a_();
            float scale = entityIn.getSpeed() - (float)i * 0.08f;
            double x = (entityIn.getTargetX() - entityIn.func_226277_ct_()) * (double)((float)entityIn.field_70173_aa + partialTicks) * (double)scale;
            double y = (entityIn.getTargetY() - entityIn.func_226278_cu_()) * (double)((float)entityIn.field_70173_aa + partialTicks) * (double)scale;
            double z = (entityIn.getTargetZ() - entityIn.func_226281_cx_()) * (double)((float)entityIn.field_70173_aa + partialTicks) * (double)scale;
            matrixStackIn.func_227861_a_((double)((float)x), (double)((float)y), (double)((float)z));
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(entityIn.field_70177_z));
            matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(entityIn.field_70125_A));
            matrixStackIn.func_227862_a_(1.2f, 1.2f, 1.2f);
            this.arrowModel.setAngles();
            IVertexBuilder vertexBuilder = bufferIn.getBuffer(this.arrowModel.func_228282_a_(TEXTURE));
            this.arrowModel.func_225598_a_(matrixStackIn, vertexBuilder, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f - (float)i * 0.08f);
            matrixStackIn.func_227865_b_();
        }
    }

    public ResourceLocation getEntityTexture(MutantArrowEntity entity) {
        return TEXTURE;
    }
}

