/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.client.renderer.entity;

import chumbanotz.mutantbeasts.MutantBeasts;
import chumbanotz.mutantbeasts.client.renderer.MBRenderType;
import chumbanotz.mutantbeasts.client.renderer.entity.model.MutantSnowGolemModel;
import chumbanotz.mutantbeasts.entity.mutant.MutantSnowGolemEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class MutantSnowGolemRenderer
extends MobRenderer<MutantSnowGolemEntity, MutantSnowGolemModel> {
    static final ResourceLocation TEXTURE = MutantBeasts.getEntityTexture("mutant_snow_golem/mutant_snow_golem");
    private static final ResourceLocation JACK_O_LANTERN_TEXTURE = MutantBeasts.getEntityTexture("mutant_snow_golem/jack_o_lantern");
    private static final RenderType GLOW_RENDER_TYPE = MBRenderType.getEyes(MutantBeasts.getEntityTexture("mutant_snow_golem/glow"));

    public MutantSnowGolemRenderer(EntityRendererManager manager) {
        super(manager, (EntityModel)new MutantSnowGolemModel(), 0.7f);
        this.func_177094_a(new JackOLanternLayer((IEntityRenderer<MutantSnowGolemEntity, MutantSnowGolemModel>)this));
        this.func_177094_a(new HeldBlockLayer((IEntityRenderer<MutantSnowGolemEntity, MutantSnowGolemModel>)this));
    }

    public ResourceLocation getEntityTexture(MutantSnowGolemEntity entity) {
        return TEXTURE;
    }

    static class HeldBlockLayer
    extends LayerRenderer<MutantSnowGolemEntity, MutantSnowGolemModel> {
        public HeldBlockLayer(IEntityRenderer<MutantSnowGolemEntity, MutantSnowGolemModel> entityRendererIn) {
            super(entityRendererIn);
        }

        public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, MutantSnowGolemEntity livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (livingEntity.getAnimation() == MutantSnowGolemEntity.THROW_ANIMATION && livingEntity.getAnimationTick() < 8) {
                matrixStackIn.func_227860_a_();
                matrixStackIn.func_227861_a_(livingEntity.func_184591_cq() == HandSide.RIGHT ? 0.4 : -0.12, 0.0, 0.0);
                ((MutantSnowGolemModel)this.func_215332_c()).func_225599_a_(livingEntity.func_184591_cq(), matrixStackIn);
                matrixStackIn.func_227861_a_(0.0, 0.9, 0.0);
                matrixStackIn.func_227862_a_(-0.8f, -0.8f, 0.8f);
                matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
                matrixStackIn.func_227861_a_(-0.5, -0.5, 0.5);
                matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
                Minecraft.func_71410_x().func_175602_ab().renderBlock(Blocks.field_150432_aD.func_176223_P(), matrixStackIn, bufferIn, packedLightIn, OverlayTexture.field_229196_a_, (IModelData)EmptyModelData.INSTANCE);
                matrixStackIn.func_227865_b_();
            }
        }
    }

    static class JackOLanternLayer
    extends LayerRenderer<MutantSnowGolemEntity, MutantSnowGolemModel> {
        public JackOLanternLayer(IEntityRenderer<MutantSnowGolemEntity, MutantSnowGolemModel> entityRendererIn) {
            super(entityRendererIn);
        }

        public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, MutantSnowGolemEntity livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (livingEntity.hasJackOLantern()) {
                if (!livingEntity.func_82150_aj()) {
                    JackOLanternLayer.func_229141_a_((EntityModel)this.func_215332_c(), (ResourceLocation)JACK_O_LANTERN_TEXTURE, (MatrixStack)matrixStackIn, (IRenderTypeBuffer)bufferIn, (int)packedLightIn, (LivingEntity)livingEntity, (float)1.0f, (float)1.0f, (float)1.0f);
                }
                float tick = (float)livingEntity.field_70173_aa + partialTicks;
                float blue = MathHelper.func_76134_b((float)(tick * 0.1f));
                float green = MathHelper.func_76134_b((float)(tick * 0.15f));
                IVertexBuilder ivertexbuilder = bufferIn.getBuffer(GLOW_RENDER_TYPE);
                ((MutantSnowGolemModel)this.func_215332_c()).func_225598_a_(matrixStackIn, ivertexbuilder, 0xF00000, OverlayTexture.field_229196_a_, 1.0f, Math.max(0.0f, 0.8f + 0.05f * green), Math.max(0.0f, 0.15f + 0.2f * blue), 1.0f);
            }
        }
    }
}

