/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.entity;

import chumbanotz.mutantbeasts.entity.CreeperMinionEntity;
import chumbanotz.mutantbeasts.entity.MBEntityType;
import chumbanotz.mutantbeasts.entity.mutant.MutantCreeperEntity;
import chumbanotz.mutantbeasts.item.MBItems;
import chumbanotz.mutantbeasts.util.EntityUtil;
import chumbanotz.mutantbeasts.util.MBSoundEvents;
import chumbanotz.mutantbeasts.util.MutatedExplosion;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class CreeperMinionEggEntity
extends Entity {
    private static final DataParameter<Optional<UUID>> OWNER_UNIQUE_ID = EntityDataManager.func_187226_a(CreeperMinionEggEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Boolean> CHARGED = EntityDataManager.func_187226_a(CreeperMinionEggEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private int health = 8;
    private int age = (60 + this.field_70146_Z.nextInt(40)) * 1200;
    private int recentlyHit;
    private double velocityX;
    private double velocityY;
    private double velocityZ;

    public CreeperMinionEggEntity(EntityType<? extends CreeperMinionEggEntity> type, World world) {
        super(type, world);
        this.field_70156_m = true;
    }

    public CreeperMinionEggEntity(World world, Entity owner) {
        this(MBEntityType.CREEPER_MINION_EGG, world);
        this.setOwnerUniqueId(owner.func_110124_au());
    }

    public CreeperMinionEggEntity(FMLPlayMessages.SpawnEntity packet, World world) {
        this(MBEntityType.CREEPER_MINION_EGG, world);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(OWNER_UNIQUE_ID, Optional.empty());
        this.field_70180_af.func_187214_a(CHARGED, (Object)false);
    }

    @Nullable
    public UUID getOwnerUniqueId() {
        return ((Optional)this.field_70180_af.func_187225_a(OWNER_UNIQUE_ID)).orElse(null);
    }

    public void setOwnerUniqueId(@Nullable UUID uuid) {
        this.field_70180_af.func_187227_b(OWNER_UNIQUE_ID, Optional.ofNullable(uuid));
    }

    public boolean isCharged() {
        return (Boolean)this.field_70180_af.func_187225_a(CHARGED);
    }

    public void setCharged(boolean charged) {
        this.field_70180_af.func_187227_b(CHARGED, (Object)charged);
    }

    public double func_70033_W() {
        return this.func_184218_aH() ? (double)this.func_213302_cg() - (this.func_184187_bx().func_213283_Z() == Pose.CROUCHING ? 0.35 : 0.2) : 0.0;
    }

    public double func_70042_X() {
        return this.func_213302_cg();
    }

    protected boolean func_225502_at_() {
        return false;
    }

    @Nullable
    public AxisAlignedBB func_70114_g(Entity entity) {
        return entity.func_70104_M() ? entity.func_174813_aQ() : null;
    }

    public boolean func_70067_L() {
        return this.func_70089_S();
    }

    public boolean func_70104_M() {
        return this.func_70089_S();
    }

    public boolean canRiderInteract() {
        return true;
    }

    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        super.func_180426_a(x, y, z, yaw, pitch, posRotationIncrements, teleport);
        this.func_213293_j(this.velocityX, this.velocityY, this.velocityZ);
    }

    public void func_70016_h(double x, double y, double z) {
        super.func_70016_h(x, y, z);
        this.velocityX = x;
        this.velocityY = y;
        this.velocityZ = z;
    }

    private void hatch() {
        CreeperMinionEntity minion = (CreeperMinionEntity)MBEntityType.CREEPER_MINION.func_200721_a(this.field_70170_p);
        UUID uuid = this.getOwnerUniqueId();
        if (uuid != null) {
            PlayerEntity playerEntity = this.field_70170_p.func_217371_b(uuid);
            if (playerEntity != null) {
                minion.func_193101_c(playerEntity);
                minion.func_233687_w_(true);
            } else {
                minion.func_184754_b(uuid);
            }
        }
        minion.setCharged(this.isCharged());
        minion.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        this.field_70170_p.func_217376_c((Entity)minion);
        this.func_184185_a(MBSoundEvents.ENTITY_CREEPER_MINION_EGG_HATCH, 0.7f, 0.9f + this.field_70146_Z.nextFloat() * 0.1f);
        this.func_70106_y();
    }

    public void func_70077_a(LightningBoltEntity lightningBolt) {
        super.func_70077_a(lightningBolt);
        this.setCharged(true);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.func_189652_ae()) {
            this.func_213317_d(this.func_213322_ci().func_178786_a(0.0, 0.04, 0.0));
        }
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        this.func_213317_d(this.func_213322_ci().func_186678_a(0.98));
        if (this.field_70122_E) {
            this.func_213317_d(this.func_213322_ci().func_216372_d(0.7, 0.0, 0.7));
        }
        if (this.func_184218_aH() && (this.func_70094_T() || this.func_184187_bx().func_213283_Z() != Pose.STANDING && this.func_184187_bx().func_213283_Z() != Pose.CROUCHING || this.func_184187_bx().func_175149_v())) {
            this.func_184210_p();
            this.playMountSound(false);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.health < 8 && this.field_70173_aa - this.recentlyHit > 80 && this.field_70173_aa % 20 == 0) {
                ++this.health;
            }
            if (--this.age <= 0 && !this.func_184218_aH()) {
                this.hatch();
            }
        }
    }

    public ActionResultType func_184230_a(PlayerEntity player, Hand hand) {
        if (this.func_184218_aH() && player == this.func_184187_bx()) {
            this.func_184210_p();
            this.playMountSound(false);
            return ActionResultType.SUCCESS;
        }
        if (!(player.func_184207_aI() || player.func_213283_Z() != Pose.STANDING && player.func_213283_Z() != Pose.CROUCHING)) {
            this.func_184205_a((Entity)player, true);
            this.playMountSound(true);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    private void playMountSound(boolean mount) {
        this.func_184185_a(SoundEvents.field_187638_cR, 0.7f, (mount ? 0.6f : 0.3f) + this.field_70146_Z.nextFloat() * 0.1f);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source) || source.func_76346_g() == this.func_184187_bx()) {
            return false;
        }
        Entity entity = source.func_76346_g();
        if (entity == null || !(entity instanceof MutantCreeperEntity) && !(entity instanceof CreeperMinionEntity)) {
            this.func_70018_K();
            if (source.func_94541_c()) {
                if (!this.field_70170_p.field_72995_K) {
                    this.age -= (int)(amount * 80.0f);
                    EntityUtil.sendParticlePacket(this, (IParticleData)ParticleTypes.field_197633_z, (int)(amount / 2.0f));
                }
                return false;
            }
            this.recentlyHit = this.field_70173_aa;
            this.func_213293_j(0.0, 0.2, 0.0);
            if (!this.field_70170_p.field_72995_K) {
                this.health -= (int)amount;
            }
            if (this.health <= 0) {
                MutatedExplosion.create(this, this.isCharged() ? 2.0f : 0.0f, false, Explosion.Mode.BREAK);
                if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
                    if (this.isCharged() || this.field_70146_Z.nextInt(3) == 0) {
                        this.func_199703_a((IItemProvider)MBItems.CREEPER_SHARD);
                    } else {
                        for (int i = 5 + this.field_70146_Z.nextInt(6); i > 0; --i) {
                            this.func_199703_a((IItemProvider)Items.field_151016_H);
                        }
                    }
                }
                this.func_70106_y();
            }
            return true;
        }
        return false;
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74768_a("Health", this.health);
        compound.func_74768_a("Age", this.age);
        compound.func_74768_a("RecentlyHit", this.recentlyHit);
        if (this.isCharged()) {
            compound.func_74757_a("Charged", true);
        }
        if (this.getOwnerUniqueId() != null) {
            compound.func_186854_a("OwnerUUID", this.getOwnerUniqueId());
        }
    }

    protected void func_70037_a(CompoundNBT compound) {
        if (compound.func_74764_b("Health")) {
            this.health = compound.func_74762_e("Health");
        }
        if (compound.func_74764_b("Age")) {
            this.age = compound.func_74762_e("Age");
        }
        this.recentlyHit = compound.func_74762_e("RecentlyHit");
        this.setCharged(compound.func_74767_n("Charged"));
        if (compound.func_186855_b("OwnerUUID")) {
            this.setOwnerUniqueId(compound.func_186857_a("OwnerUUID"));
        }
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

