/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.entity.ai.goal;

import chumbanotz.mutantbeasts.entity.MBEntityType;
import chumbanotz.mutantbeasts.entity.mutant.MutantSnowGolemEntity;
import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;

public class RangedAttackGoal
extends Goal {
    private final MutantSnowGolemEntity entityHost;
    private LivingEntity attackTarget;
    private int rangedAttackTime = -1;
    private final double entityMoveSpeed;
    private int seeTime;
    private final int maxRangedAttackTime;
    private final float attackRadius;
    private final float maxAttackDistance;

    public RangedAttackGoal(MutantSnowGolemEntity attacker, double movespeed, int maxAttackTime, float maxAttackDistanceIn) {
        this.entityHost = attacker;
        this.entityMoveSpeed = movespeed;
        this.maxRangedAttackTime = maxAttackTime;
        this.attackRadius = maxAttackDistanceIn;
        this.maxAttackDistance = maxAttackDistanceIn * maxAttackDistanceIn;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean func_75250_a() {
        LivingEntity livingentity = this.entityHost.func_70638_az();
        if (livingentity != null && livingentity.func_70089_S()) {
            this.attackTarget = livingentity;
            return true;
        }
        return false;
    }

    public boolean func_75253_b() {
        return this.func_75250_a() || this.entityHost.func_70781_l();
    }

    public void func_75251_c() {
        this.attackTarget = null;
        this.seeTime = 0;
        this.rangedAttackTime = -1;
    }

    public void func_75246_d() {
        double d0 = this.entityHost.func_70092_e(this.attackTarget.func_226277_ct_(), this.attackTarget.func_226278_cu_(), this.attackTarget.func_226281_cx_());
        boolean canSee = this.entityHost.func_70635_at().func_75522_a((Entity)this.attackTarget);
        this.seeTime = canSee ? ++this.seeTime : 0;
        if (d0 < 144.0 && canSee) {
            double backOffDist = Math.min(144.0, (double)(this.attackTarget.func_213311_cf() * 4.0f * this.attackTarget.func_213311_cf() * 4.0f + this.entityHost.func_213311_cf()));
            this.entityHost.func_70661_as().func_75499_g();
            if (this.entityHost.func_233570_aj_() && d0 <= backOffDist && this.entityHost.getAnimationTick() < 7) {
                this.entityHost.func_70605_aq().func_188488_a(-((float)this.entityMoveSpeed), 0.0f);
                this.entityHost.field_70177_z = MathHelper.func_219800_b((float)this.entityHost.field_70177_z, (float)this.entityHost.field_70759_as, (float)0.0f);
            }
        } else {
            this.entityHost.func_70661_as().func_75497_a((Entity)this.attackTarget, this.entityMoveSpeed);
        }
        this.entityHost.func_70671_ap().func_75651_a((Entity)this.attackTarget, 30.0f, 30.0f);
        if (--this.rangedAttackTime == 0) {
            Vector3d vector3d = new Vector3d(this.entityHost.func_226277_ct_(), this.entityHost.func_226280_cw_() + 1.0, this.entityHost.func_226281_cx_());
            boolean lineOfSight = this.entityHost.field_70170_p.func_217299_a(new RayTraceContext(vector3d, this.attackTarget.func_174824_e(1.0f), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this.entityHost)).func_216346_c() == RayTraceResult.Type.MISS;
            float f = MBEntityType.THROWABLE_BLOCK.func_220333_h() / 2.0f;
            float f1 = MBEntityType.THROWABLE_BLOCK.func_220344_i();
            boolean canFitBlock = this.entityHost.field_70170_p.func_226664_a_(new AxisAlignedBB(this.entityHost.func_226277_ct_() - (double)f, this.entityHost.func_226280_cw_() + 0.9, this.entityHost.func_226281_cx_() - (double)f, this.entityHost.func_226277_ct_() + (double)f, this.entityHost.func_226280_cw_() + 0.9 + (double)f1, this.entityHost.func_226281_cx_() + (double)f));
            if (d0 > 144.0 || !canFitBlock || !lineOfSight || !canSee) {
                if (d0 <= (double)(this.entityHost.func_213311_cf() * 2.0f * this.entityHost.func_213311_cf() * 2.0f + this.attackTarget.func_213311_cf())) {
                    this.entityHost.func_70652_k((Entity)this.attackTarget);
                    this.entityHost.func_184609_a(Hand.MAIN_HAND);
                }
                this.entityHost.func_70661_as().func_75497_a((Entity)this.attackTarget, this.entityMoveSpeed);
                return;
            }
            float f11 = MathHelper.func_76133_a((double)d0) / this.attackRadius;
            this.entityHost.func_82196_d(this.attackTarget, 0.0f);
            this.rangedAttackTime = MathHelper.func_76141_d((float)(f11 * (float)(this.maxRangedAttackTime - this.maxRangedAttackTime) + (float)this.maxRangedAttackTime));
        } else if (this.rangedAttackTime < 0) {
            float f2 = MathHelper.func_76133_a((double)d0) / this.attackRadius;
            this.rangedAttackTime = MathHelper.func_76141_d((float)(f2 * (float)(this.maxRangedAttackTime - this.maxRangedAttackTime) + (float)this.maxRangedAttackTime));
        }
    }
}

