/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.entity.mutant;

import chumbanotz.mutantbeasts.entity.CreeperMinionEggEntity;
import chumbanotz.mutantbeasts.entity.CreeperMinionEntity;
import chumbanotz.mutantbeasts.entity.MBEntityType;
import chumbanotz.mutantbeasts.entity.ai.goal.AvoidDamageGoal;
import chumbanotz.mutantbeasts.entity.ai.goal.MBHurtByTargetGoal;
import chumbanotz.mutantbeasts.entity.ai.goal.MBMeleeAttackGoal;
import chumbanotz.mutantbeasts.pathfinding.MBGroundPathNavigator;
import chumbanotz.mutantbeasts.util.EntityUtil;
import chumbanotz.mutantbeasts.util.MBSoundEvents;
import chumbanotz.mutantbeasts.util.MutatedExplosion;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.ZoglinEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeMod;

public class MutantCreeperEntity
extends MonsterEntity {
    private static final DataParameter<Byte> STATUS = EntityDataManager.func_187226_a(MutantCreeperEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    public static final int MAX_CHARGE_TIME = 100;
    public static final int MAX_DEATH_TIME = 100;
    private int chargeTime;
    private int chargeHits;
    private boolean summonLightning;
    private DamageSource deathCause;

    public MutantCreeperEntity(EntityType<? extends MutantCreeperEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70138_W = 1.5f;
        this.field_70728_aV = 30;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new JumpAttackGoal());
        this.field_70714_bg.func_75776_a(1, (Goal)new SpawnMinionsGoal());
        this.field_70714_bg.func_75776_a(1, (Goal)new ChargeAttackGoal());
        this.field_70714_bg.func_75776_a(2, (Goal)new MBMeleeAttackGoal((CreatureEntity)this, 1.3));
        this.field_70714_bg.func_75776_a(3, (Goal)new AvoidDamageGoal((CreatureEntity)this, 1.3));
        this.field_70714_bg.func_75776_a(4, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new MBHurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AnimalEntity.class, 100, true, true, EntityUtil::isFeline));
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MutantCreeperEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 120.0).func_233815_a_(Attributes.field_233823_f_, 5.0).func_233815_a_(Attributes.field_233821_d_, 0.26).func_233815_a_(Attributes.field_233820_c_, 1.0).func_233815_a_((Attribute)ForgeMod.SWIM_SPEED.get(), 5.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STATUS, (Object)0);
    }

    public boolean isCharged() {
        return ((Byte)this.field_70180_af.func_187225_a(STATUS) & 1) != 0;
    }

    private void setCharged(boolean charged) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(STATUS);
        this.field_70180_af.func_187227_b(STATUS, (Object)(charged ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE)));
    }

    public boolean isJumpAttacking() {
        return ((Byte)this.field_70180_af.func_187225_a(STATUS) & 2) != 0;
    }

    private void setJumpAttacking(boolean jumping) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(STATUS);
        this.field_70180_af.func_187227_b(STATUS, (Object)(jumping ? (byte)(b0 | 2) : (byte)(b0 & 0xFFFFFFFD)));
    }

    public boolean isCharging() {
        return ((Byte)this.field_70180_af.func_187225_a(STATUS) & 4) != 0;
    }

    private void setCharging(boolean flag) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(STATUS);
        this.field_70180_af.func_187227_b(STATUS, (Object)(flag ? (byte)(b0 | 4) : (byte)(b0 & 0xFFFFFFFB)));
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 2.6f;
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new MBGroundPathNavigator((MobEntity)this, worldIn);
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    public boolean func_230279_az_() {
        return this.isCharged() || super.func_230279_az_();
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)this.func_110148_a(Attributes.field_233823_f_).func_111126_e());
        double x = entityIn.func_226277_ct_() - this.func_226277_ct_();
        double y = entityIn.func_226278_cu_() - this.func_226278_cu_();
        double z = entityIn.func_226281_cx_() - this.func_226281_cx_();
        double d = Math.sqrt(x * x + y * y + z * z);
        entityIn.func_70024_g(x / d * 0.5, y / d * (double)0.05f + (double)0.15f, z / d * 0.5);
        if (flag) {
            this.func_174815_a((LivingEntity)this, entityIn);
        }
        this.func_184609_a(Hand.MAIN_HAND);
        return flag;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (source.func_94541_c()) {
            float healAmount = amount / 2.0f;
            if (this.func_70089_S() && this.func_110143_aJ() < this.func_110138_aP() && !(source.func_76346_g() instanceof MutantCreeperEntity)) {
                this.func_70691_i(healAmount);
                EntityUtil.sendParticlePacket((Entity)this, (IParticleData)ParticleTypes.field_197633_z, (int)(healAmount / 2.0f));
            }
            return true;
        }
        if (this.isCharging()) {
            if (!source.func_82725_o() && source.func_76364_f() instanceof LivingEntity) {
                source.func_76364_f().func_70097_a(DamageSource.func_76358_a((LivingEntity)this).func_76348_h(), 2.0f);
            }
            if (!this.field_70170_p.field_72995_K && amount > 0.0f && source.func_76364_f() != null && super.func_70097_a(source, amount)) {
                --this.chargeHits;
            }
        }
        return super.func_70097_a(source, amount);
    }

    public double func_213340_A(@Nullable Entity lookingEntity) {
        return lookingEntity instanceof IronGolemEntity || lookingEntity instanceof ZoglinEntity ? 0.0 : super.func_213340_A(lookingEntity);
    }

    public void func_70077_a(LightningBoltEntity lightningBolt) {
        this.setCharged(true);
    }

    public int func_70641_bl() {
        return 1;
    }

    protected void func_213623_ec() {
    }

    public void func_70103_a(byte id) {
        if (id == 0) {
            this.field_70737_aN = 0;
        } else if (id == 6) {
            EntityUtil.spawnParticlesAtEntity((Entity)this, (IParticleData)ParticleTypes.field_197633_z, 15);
        } else {
            super.func_70103_a(id);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.isJumpAttacking()) {
                if (this.field_70122_E || this.field_213328_B != Vector3d.field_186680_a || !this.func_213339_cH().func_204520_s().func_206888_e()) {
                    this.setJumpAttacking(false);
                    MutatedExplosion.create((Entity)this, this.isCharged() ? 6.0f : 4.0f, false, Explosion.Mode.DESTROY);
                }
            } else if (this.func_70089_S() && !this.func_175446_cd() && this.func_70094_T() && this.field_70173_aa % 80 == 0) {
                this.setJumpAttacking(true);
            }
        }
        if (this.isJumpAttacking()) {
            float cos = MathHelper.func_76134_b((float)(this.field_70761_aq * ((float)Math.PI / 180))) * 1.0f;
            float sin = MathHelper.func_76126_a((float)(this.field_70761_aq * ((float)Math.PI / 180))) * 1.0f;
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197594_E, this.func_226277_ct_() + (double)cos, this.func_226278_cu_(), this.func_226281_cx_() + (double)sin, 0.0, 0.0, 0.0);
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197594_E, this.func_226277_ct_() - (double)cos, this.func_226278_cu_(), this.func_226281_cx_() - (double)sin, 0.0, 0.0, 0.0);
        }
    }

    protected boolean func_184228_n(Entity entityIn) {
        return false;
    }

    public boolean func_96092_aw() {
        return false;
    }

    protected void func_213371_e(LivingEntity livingEntity) {
        livingEntity.func_70108_f((Entity)this);
        livingEntity.field_70133_I = true;
    }

    protected void func_180466_bG(ITag<Fluid> fluidTag) {
        this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, (double)0.04f, 0.0));
    }

    public float getOverlayColor(float partialTicks) {
        float f = (float)this.field_70725_aQ / 100.0f;
        if (this.isCharging()) {
            f = this.field_70173_aa % 20 < 10 ? 0.6f : 0.0f;
        }
        return f;
    }

    public void func_70645_a(DamageSource cause) {
        if (!this.field_70170_p.field_72995_K) {
            this.deathCause = cause;
            this.setCharging(false);
            if (!this.func_174814_R()) {
                this.field_70170_p.func_217384_a(null, (Entity)this, MBSoundEvents.ENTITY_MUTANT_CREEPER_DEATH, this.func_184176_by(), 2.0f, 1.0f);
            }
            if (this.field_70718_bc > 0) {
                this.field_70718_bc += 100;
            }
        }
    }

    protected void func_70609_aI() {
        float power = this.isCharged() ? 12.0f : 8.0f;
        float radius = power * 1.5f;
        for (Entity entity : this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_186662_g((double)radius), EntityPredicates.field_188444_d)) {
            double x = this.func_226277_ct_() - entity.func_226277_ct_();
            double y = this.func_226278_cu_() - entity.func_226278_cu_();
            double z = this.func_226281_cx_() - entity.func_226281_cx_();
            double d = Math.sqrt(x * x + y * y + z * z);
            float scale = (float)this.field_70725_aQ / 100.0f;
            entity.func_70024_g(x / d * (double)scale * 0.09, y / d * (double)scale * 0.09, z / d * (double)scale * 0.09);
        }
        this.func_213317_d(this.func_213322_ci().func_72441_c((double)(this.field_70146_Z.nextFloat() * 0.2f) - (double)0.1f, 0.0, (double)(this.field_70146_Z.nextFloat() * 0.2f) - (double)0.1f));
        if (++this.field_70725_aQ >= 100) {
            if (!this.field_70170_p.field_72995_K) {
                MutatedExplosion.create((Entity)this, power, this.func_70027_ad(), Explosion.Mode.DESTROY);
                EntityUtil.spawnLingeringCloud((LivingEntity)this);
                if (this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223602_e) && this.field_70717_bb != null) {
                    CreeperMinionEggEntity egg = new CreeperMinionEggEntity(this.field_70170_p, (Entity)this.field_70717_bb);
                    egg.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
                    egg.setCharged(this.isCharged());
                    this.field_70170_p.func_217376_c((Entity)egg);
                }
            }
            super.func_70645_a(this.deathCause != null ? this.deathCause : DamageSource.field_76377_j);
            this.func_70106_y();
        }
    }

    public float func_180428_a(Explosion explosionIn, IBlockReader worldIn, BlockPos pos, BlockState blockStateIn, FluidState fluidState, float resistance) {
        return this.isCharged() && blockStateIn.func_185887_b(worldIn, pos) > -1.0f ? Math.min(0.8f, resistance) : resistance;
    }

    public void func_70642_aH() {
        if (this.func_70638_az() == null) {
            super.func_70642_aH();
        }
    }

    protected SoundEvent func_184639_G() {
        return MBSoundEvents.ENTITY_MUTANT_CREEPER_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return MBSoundEvents.ENTITY_MUTANT_CREEPER_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return MBSoundEvents.ENTITY_MUTANT_CREEPER_HURT;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("JumpAttacking", this.isJumpAttacking());
        compound.func_74757_a("Charging", this.isCharging());
        compound.func_74768_a("ChargeTime", this.chargeTime);
        compound.func_74768_a("ChargeHits", this.chargeHits);
        compound.func_74757_a("SummonLightning", this.summonLightning);
        if (this.isCharged()) {
            compound.func_74757_a("Powered", true);
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setCharged(compound.func_74767_n("powered") || compound.func_74767_n("Powered"));
        this.setJumpAttacking(compound.func_74767_n("JumpAttacking"));
        this.setCharging(compound.func_74767_n("Charging"));
        this.chargeTime = compound.func_74762_e("ChargeTime");
        this.chargeHits = compound.func_74762_e("ChargeHits");
        this.summonLightning = compound.func_74767_n("SummonLightning");
    }

    class JumpAttackGoal
    extends Goal {
        JumpAttackGoal() {
        }

        public boolean func_75250_a() {
            LivingEntity target = MutantCreeperEntity.this.func_70638_az();
            return target != null && MutantCreeperEntity.this.func_70068_e((Entity)target) <= 1024.0 && MutantCreeperEntity.this.field_70122_E && !MutantCreeperEntity.this.isCharging() && MutantCreeperEntity.this.field_70146_Z.nextFloat() * 100.0f < 0.9f;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            MutantCreeperEntity.this.field_213328_B = Vector3d.field_186680_a;
            MutantCreeperEntity.this.setJumpAttacking(true);
            MutantCreeperEntity.this.func_213293_j((MutantCreeperEntity.this.func_70638_az().func_226277_ct_() - MutantCreeperEntity.this.func_226277_ct_()) * 0.2, 1.4, (MutantCreeperEntity.this.func_70638_az().func_226281_cx_() - MutantCreeperEntity.this.func_226281_cx_()) * 0.2);
        }
    }

    class ChargeAttackGoal
    extends Goal {
        public ChargeAttackGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean func_220685_C_() {
            return false;
        }

        public boolean func_75250_a() {
            LivingEntity target = MutantCreeperEntity.this.func_70638_az();
            return target != null && !MutantCreeperEntity.this.isJumpAttacking() && !(MutantCreeperEntity.this.func_110138_aP() - MutantCreeperEntity.this.func_110143_aJ() < MutantCreeperEntity.this.func_110138_aP() / 6.0f) && MutantCreeperEntity.this.func_70068_e((Entity)target) >= 25.0 && MutantCreeperEntity.this.func_70068_e((Entity)target) <= 1024.0 && MutantCreeperEntity.this.field_70146_Z.nextFloat() * 100.0f < 0.7f || MutantCreeperEntity.this.isCharging();
        }

        public boolean func_75253_b() {
            if (MutantCreeperEntity.this.summonLightning && MutantCreeperEntity.this.func_70638_az() != null && MutantCreeperEntity.this.func_70068_e((Entity)MutantCreeperEntity.this.func_70638_az()) < 25.0) {
                return false;
            }
            return MutantCreeperEntity.this.chargeTime < 100 && MutantCreeperEntity.this.chargeHits > 0;
        }

        public void func_75249_e() {
            MutantCreeperEntity.this.setCharging(true);
            if (MutantCreeperEntity.this.chargeHits == 0) {
                MutantCreeperEntity.this.chargeHits = 3 + MutantCreeperEntity.this.field_70146_Z.nextInt(3);
            }
            if (MutantCreeperEntity.this.field_70146_Z.nextInt(MutantCreeperEntity.this.field_70170_p.func_72911_I() ? 2 : 6) == 0 && !MutantCreeperEntity.this.isCharged()) {
                MutantCreeperEntity.this.summonLightning = true;
            }
        }

        public void func_75246_d() {
            int i = MutantCreeperEntity.this.chargeTime % 20;
            if (i == 0 || i == 20) {
                MutantCreeperEntity.this.func_184185_a(MBSoundEvents.ENTITY_MUTANT_CREEPER_CHARGE, 0.6f, 0.7f + MutantCreeperEntity.this.field_70146_Z.nextFloat() * 0.6f);
            }
            ++MutantCreeperEntity.this.chargeTime;
        }

        public void func_75251_c() {
            if (MutantCreeperEntity.this.summonLightning && MutantCreeperEntity.this.func_70638_az() != null && MutantCreeperEntity.this.func_70068_e((Entity)MutantCreeperEntity.this.func_70638_az()) < 25.0 && MutantCreeperEntity.this.field_70170_p.func_226660_f_(MutantCreeperEntity.this.func_233580_cy_())) {
                LightningBoltEntity lightningBoltEntity = (LightningBoltEntity)EntityType.field_200728_aG.func_200721_a(MutantCreeperEntity.this.field_70170_p);
                lightningBoltEntity.func_225653_b_(MutantCreeperEntity.this.func_226277_ct_(), MutantCreeperEntity.this.func_226278_cu_(), MutantCreeperEntity.this.func_226281_cx_());
                MutantCreeperEntity.this.field_70170_p.func_217376_c((Entity)lightningBoltEntity);
            } else if (MutantCreeperEntity.this.chargeTime >= 100) {
                MutantCreeperEntity.this.func_70691_i(30.0f);
                MutantCreeperEntity.this.field_70170_p.func_72960_a((Entity)MutantCreeperEntity.this, (byte)6);
            }
            MutantCreeperEntity.this.chargeTime = 0;
            MutantCreeperEntity.this.chargeHits = 4 + MutantCreeperEntity.this.field_70146_Z.nextInt(3);
            MutantCreeperEntity.this.setCharging(false);
            MutantCreeperEntity.this.summonLightning = false;
        }
    }

    class SpawnMinionsGoal
    extends Goal {
        SpawnMinionsGoal() {
        }

        public boolean func_75250_a() {
            float chance = !MutantCreeperEntity.this.func_70781_l() || MutantCreeperEntity.this.func_189748_bU() != null && MutantCreeperEntity.this.func_189748_bU().func_76352_a() ? 0.9f : 0.6f;
            return MutantCreeperEntity.this.func_70638_az() != null && MutantCreeperEntity.this.func_70068_e((Entity)MutantCreeperEntity.this.func_70638_az()) <= 1024.0 && !MutantCreeperEntity.this.isCharging() && !MutantCreeperEntity.this.isJumpAttacking() && MutantCreeperEntity.this.field_70146_Z.nextFloat() * 100.0f < chance;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            for (int i = (int)Math.ceil((double)(MutantCreeperEntity.this.func_110143_aJ() / MutantCreeperEntity.this.func_110138_aP()) * 4.0); i > 0; --i) {
                CreeperMinionEntity minion = (CreeperMinionEntity)MBEntityType.CREEPER_MINION.func_200721_a(MutantCreeperEntity.this.field_70170_p);
                double x = MutantCreeperEntity.this.func_226277_ct_() + (double)(MutantCreeperEntity.this.field_70146_Z.nextFloat() - MutantCreeperEntity.this.field_70146_Z.nextFloat());
                double y = MutantCreeperEntity.this.func_226278_cu_() + (double)(MutantCreeperEntity.this.field_70146_Z.nextFloat() * 0.5f);
                double z = MutantCreeperEntity.this.func_226281_cx_() + (double)(MutantCreeperEntity.this.field_70146_Z.nextFloat() - MutantCreeperEntity.this.field_70146_Z.nextFloat());
                double xx = MutantCreeperEntity.this.func_70638_az().func_226277_ct_() - MutantCreeperEntity.this.func_226277_ct_();
                double yy = MutantCreeperEntity.this.func_70638_az().func_226278_cu_() - MutantCreeperEntity.this.func_226278_cu_();
                double zz = MutantCreeperEntity.this.func_70638_az().func_226281_cx_() - MutantCreeperEntity.this.func_226281_cx_();
                minion.func_213293_j(xx * 0.15 + (double)(MutantCreeperEntity.this.field_70146_Z.nextFloat() * 0.05f), yy * 0.15 + (double)(MutantCreeperEntity.this.field_70146_Z.nextFloat() * 0.05f), zz * 0.15 + (double)(MutantCreeperEntity.this.field_70146_Z.nextFloat() * 0.05f));
                minion.func_70012_b(x, y, z, MutantCreeperEntity.this.field_70177_z, MutantCreeperEntity.this.field_70125_A);
                minion.func_184754_b(MutantCreeperEntity.this.field_96093_i);
                minion.func_70624_b(MutantCreeperEntity.this.func_70638_az());
                minion.setCharged(MutantCreeperEntity.this.isCharged());
                MutantCreeperEntity.this.field_70170_p.func_217376_c((Entity)minion);
            }
        }
    }
}

