/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.entity.mutant;

import chumbanotz.mutantbeasts.MutantBeasts;
import chumbanotz.mutantbeasts.client.animationapi.Animation;
import chumbanotz.mutantbeasts.client.animationapi.IAnimatedEntity;
import chumbanotz.mutantbeasts.entity.EndersoulCloneEntity;
import chumbanotz.mutantbeasts.entity.EndersoulFragmentEntity;
import chumbanotz.mutantbeasts.entity.MBEntityType;
import chumbanotz.mutantbeasts.entity.ai.goal.AnimationGoal;
import chumbanotz.mutantbeasts.entity.ai.goal.AvoidDamageGoal;
import chumbanotz.mutantbeasts.entity.ai.goal.MBHurtByTargetGoal;
import chumbanotz.mutantbeasts.entity.ai.goal.MBMeleeAttackGoal;
import chumbanotz.mutantbeasts.entity.projectile.ThrowableBlockEntity;
import chumbanotz.mutantbeasts.packet.HeldBlockPacket;
import chumbanotz.mutantbeasts.packet.MBPacketHandler;
import chumbanotz.mutantbeasts.particles.MBParticleTypes;
import chumbanotz.mutantbeasts.pathfinding.MBGroundPathNavigator;
import chumbanotz.mutantbeasts.util.EntityUtil;
import chumbanotz.mutantbeasts.util.MBSoundEvents;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IAngerable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtWithoutMovingGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.ResetAngerGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.EndermiteEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.RangedInteger;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.TickRangeConverter;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.PacketDistributor;

public class MutantEndermanEntity
extends MonsterEntity
implements IAngerable,
IAnimatedEntity {
    private static final DataParameter<Optional<BlockPos>> TELEPORT_POSITION = EntityDataManager.func_187226_a(MutantEndermanEntity.class, (IDataSerializer)DataSerializers.field_187201_k);
    private static final DataParameter<Byte> ACTIVE_ARM = EntityDataManager.func_187226_a(MutantEndermanEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Boolean> CLONE = EntityDataManager.func_187226_a(MutantEndermanEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final Animation MELEE_ANIMATION = new Animation(10);
    public static final Animation THROW_ANIMATION = new Animation(14);
    public static final Animation STARE_ANIMATION = new Animation(100);
    public static final Animation TELEPORT_ANIMATION = new Animation(10);
    public static final Animation SCREAM_ANIMATION = new Animation(165);
    public static final Animation CLONE_ANIMATION = new Animation(600);
    public static final Animation TELESMASH_ANIMATION = new Animation(30);
    public static final Animation DEATH_ANIMATION = new Animation(280);
    private static final Animation[] ANIMATIONS = new Animation[]{MELEE_ANIMATION, THROW_ANIMATION, STARE_ANIMATION, TELEPORT_ANIMATION, SCREAM_ANIMATION, CLONE_ANIMATION, TELESMASH_ANIMATION, DEATH_ANIMATION};
    private Animation animation = Animation.NONE;
    private int animationTick;
    private int prevArmScale;
    private int armScale;
    public int hasTarget;
    private int screamDelayTick;
    public final int[] heldBlock = new int[5];
    public final int[] heldBlockTick = new int[5];
    private boolean triggerThrowBlock;
    private int blockFrenzy;
    @Nullable
    private List<Entity> capturedEntities;
    private int dirty = -1;
    private DamageSource deathCause;
    private static final RangedInteger field_234230_bG_ = TickRangeConverter.func_233037_a_((int)20, (int)39);
    private int field_234347_bw_;
    private UUID field_234231_bH_;

    public MutantEndermanEntity(EntityType<? extends MutantEndermanEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70728_aV = 40;
        this.field_70138_W = 2.0f;
        this.field_70158_ak = true;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new MeleeGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new ThrowBlockGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new StareGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new TeleportGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new ScreamGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new CloneGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new TeleSmashGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new MBMeleeAttackGoal((CreatureEntity)this, 1.2).setMaxAttackTick(10));
        this.field_70714_bg.func_75776_a(3, (Goal)new AvoidDamageGoal((CreatureEntity)this, 1.2));
        this.field_70714_bg.func_75776_a(4, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0, 0.0f));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtWithoutMovingGoal((MobEntity)this, PlayerEntity.class, 8.0f, 0.02f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new MBHurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new FindTargetGoal(this));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, EndermiteEntity.class, true));
        this.field_70715_bh.func_75776_a(4, (Goal)new ResetAngerGoal((MobEntity)this, false));
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MutantEndermanEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 200.0).func_233815_a_(Attributes.field_233823_f_, 7.0).func_233815_a_(Attributes.field_233819_b_, 96.0).func_233815_a_(Attributes.field_233821_d_, 0.3).func_233815_a_(Attributes.field_233820_c_, 1.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TELEPORT_POSITION, Optional.empty());
        this.field_70180_af.func_187214_a(ACTIVE_ARM, (Object)0);
        this.field_70180_af.func_187214_a(CLONE, (Object)false);
    }

    @Nullable
    public BlockPos getTeleportPosition() {
        return ((Optional)this.field_70180_af.func_187225_a(TELEPORT_POSITION)).orElse(null);
    }

    private void setTeleportPosition(@Nullable BlockPos pos) {
        this.field_70180_af.func_187227_b(TELEPORT_POSITION, Optional.ofNullable(pos));
    }

    public int getActiveArm() {
        return ((Byte)this.field_70180_af.func_187225_a(ACTIVE_ARM)).byteValue();
    }

    private void setActiveArm(int armId) {
        this.field_70180_af.func_187227_b(ACTIVE_ARM, (Object)((byte)armId));
    }

    public boolean isClone() {
        return (Boolean)this.field_70180_af.func_187225_a(CLONE);
    }

    private void setClone(boolean isClone) {
        this.field_70180_af.func_187227_b(CLONE, (Object)isClone);
        this.func_184185_a(MBSoundEvents.ENTITY_MUTANT_ENDERMAN_MORPH, 2.0f, this.func_70647_i());
        this.field_70170_p.func_72960_a((Entity)this, (byte)0);
    }

    public int func_230256_F__() {
        return this.field_234347_bw_;
    }

    public void func_230260_a__(int p_230260_1_) {
        this.field_234347_bw_ = p_230260_1_;
    }

    public UUID func_230257_G__() {
        return this.field_234231_bH_;
    }

    public void func_230259_a_(UUID p_230259_1_) {
        this.field_234231_bH_ = p_230259_1_;
    }

    public void func_230258_H__() {
        this.func_230260_a__(field_234230_bG_.func_233018_a_(this.field_70146_Z));
    }

    @Override
    public Animation getAnimation() {
        return this.animation;
    }

    @Override
    public void setAnimation(Animation animation) {
        this.animation = animation;
    }

    @Override
    public Animation[] getAnimations() {
        return ANIMATIONS;
    }

    @Override
    public int getAnimationTick() {
        return this.animationTick;
    }

    @Override
    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return this.isClone() ? 2.55f : 3.9f;
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return this.isClone() ? EntitySize.func_220314_b((float)0.6f, (float)2.9f) : super.func_213305_a(poseIn);
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new MBGroundPathNavigator((MobEntity)this, worldIn);
    }

    public int func_70641_bl() {
        return 1;
    }

    public int func_82143_as() {
        return this.isClone() ? 3 : super.func_82143_as();
    }

    public boolean func_70067_L() {
        return super.func_70067_L() && this.animation != TELEPORT_ANIMATION;
    }

    protected void func_213623_ec() {
    }

    public boolean func_230270_dK_() {
        return this.field_70173_aa % 100 == 0 && !this.isClone();
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (CLONE.equals(key)) {
            this.func_213323_x_();
        }
        if (TELEPORT_POSITION.equals(key) && this.getTeleportPosition() != null && this.func_70089_S() && this.field_70170_p.field_72995_K) {
            this.animation = TELEPORT_ANIMATION;
            this.animationTick = 0;
            this.spawnBigParticles();
        }
    }

    public void func_70624_b(@Nullable LivingEntity entitylivingbaseIn) {
        super.func_70624_b(entitylivingbaseIn);
        this.func_213395_q(entitylivingbaseIn != null);
    }

    public float getArmScale(float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)this.prevArmScale, (float)this.armScale) / 10.0f;
    }

    private void updateTargetTick() {
        int i;
        this.prevArmScale = this.armScale;
        if (this.func_213398_dR()) {
            this.hasTarget = 20;
        }
        boolean emptyHanded = true;
        for (i = 1; i < this.heldBlock.length; ++i) {
            if (this.heldBlock[i] > 0) {
                emptyHanded = false;
            }
            if (this.hasTarget > 0) {
                if (this.heldBlock[i] <= 0) continue;
                this.heldBlockTick[i] = Math.min(10, this.heldBlockTick[i] + 1);
                continue;
            }
            this.heldBlockTick[i] = Math.max(0, this.heldBlockTick[i] - 1);
        }
        if (this.hasTarget > 0) {
            this.armScale = Math.min(10, this.armScale + 1);
        } else if (emptyHanded) {
            this.armScale = Math.max(0, this.armScale - 1);
        } else if (!this.field_70170_p.field_72995_K) {
            for (i = 1; i < this.heldBlock.length; ++i) {
                if (this.heldBlock[i] == 0 || this.heldBlockTick[i] != 0) continue;
                BlockPos blockPos = new BlockPos(this.func_226277_ct_() - 1.5 + this.field_70146_Z.nextDouble() * 4.0, this.func_226278_cu_() - 0.5 + this.field_70146_Z.nextDouble() * 2.5, this.func_226281_cx_() - 1.5 + this.field_70146_Z.nextDouble() * 4.0);
                if (this.field_70170_p.func_175623_d(blockPos) && !this.field_70170_p.func_175623_d(blockPos.func_177977_b()) && ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this)) {
                    this.field_70170_p.func_175656_a(blockPos, Block.func_196257_b((int)this.heldBlock[i]));
                    this.sendHoldBlock(i, 0);
                    continue;
                }
                this.triggerThrowBlock = true;
            }
        }
        this.hasTarget = Math.max(0, this.hasTarget - 1);
    }

    private void updateScreamEntities() {
        this.screamDelayTick = Math.max(0, this.screamDelayTick - 1);
        if (this.animation == SCREAM_ANIMATION && this.animationTick >= 40 && this.animationTick <= 160) {
            if (this.animationTick == 160) {
                this.capturedEntities = null;
            } else if (this.capturedEntities == null) {
                this.capturedEntities = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72314_b(20.0, 12.0, 20.0), EndersoulFragmentEntity.IS_VALID_TARGET);
            } else {
                for (int i = 0; i < this.capturedEntities.size(); ++i) {
                    Entity entity = this.capturedEntities.get(i);
                    if (this.func_70068_e(entity) > 400.0) {
                        this.capturedEntities.remove(i);
                        --i;
                        continue;
                    }
                    entity.field_70125_A += (this.field_70146_Z.nextFloat() - 0.3f) * 6.0f;
                }
            }
        }
    }

    public void func_70103_a(byte id) {
        if (id == 0) {
            this.spawnBigParticles();
        } else {
            super.func_70103_a(id);
        }
    }

    public void func_70636_d() {
        boolean targetBlind;
        super.func_70636_d();
        if (this.isAnimationPlaying()) {
            ++this.animationTick;
        }
        if (this.animation == DEATH_ANIMATION) {
            this.field_70725_aQ = this.animationTick;
        }
        this.updateTargetTick();
        this.updateScreamEntities();
        double h = this.animation != DEATH_ANIMATION ? (double)this.func_213302_cg() : (double)(this.func_213302_cg() + 1.0f);
        double w = this.animation != DEATH_ANIMATION ? (double)this.func_213311_cf() : (double)(this.func_213311_cf() * 1.5f);
        boolean bl = targetBlind = this.func_70638_az() != null && this.func_70638_az().func_70644_a(Effects.field_76440_q);
        if (!targetBlind && !this.isClone()) {
            for (int i = 0; i < 3; ++i) {
                double x = this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * w;
                double y = this.func_226278_cu_() + this.field_70146_Z.nextDouble() * h - 0.25;
                double z = this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * w;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197599_J, x, y, z, (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0);
            }
        }
    }

    private void updateBlockFrenzy() {
        this.blockFrenzy = Math.max(0, this.blockFrenzy - 1);
        if (this.func_70638_az() != null && !this.isAnimationPlaying()) {
            if (this.blockFrenzy == 0 && this.field_70146_Z.nextInt(!this.func_70781_l() ? 300 : 600) == 0) {
                this.blockFrenzy = 200 + this.field_70146_Z.nextInt(80);
            }
            if (this.blockFrenzy > 0 && this.field_70146_Z.nextInt(8) == 0) {
                int index = this.getFavorableHand();
                BlockPos pos = new BlockPos(this.func_226277_ct_() - 2.5 + this.field_70146_Z.nextDouble() * 5.0, this.func_226278_cu_() - 0.5 + this.field_70146_Z.nextDouble() * 3.0, this.func_226281_cx_() - 2.5 + this.field_70146_Z.nextDouble() * 5.0);
                if (index != -1 && this.field_70170_p.func_180495_p(pos).func_235714_a_(MutantBeasts.MUTANT_ENDERMAN_HOLABLE)) {
                    this.sendHoldBlock(index, Block.func_196246_j((BlockState)this.field_70170_p.func_180495_p(pos)));
                    if (ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this)) {
                        this.field_70170_p.func_217377_a(pos, false);
                    }
                }
            }
        }
    }

    private void updateTeleport() {
        LivingEntity entity = this.func_70638_az();
        this.teleportByChance(entity == null ? 1600 : 800, (Entity)entity);
        if (this.func_70090_H() || entity != null && (this.func_184223_x((Entity)entity) || this.func_70068_e((Entity)entity) > 1024.0 || !this.func_70781_l())) {
            this.teleportByChance(10, (Entity)entity);
        }
    }

    protected void func_70619_bc() {
        this.func_241359_a_((ServerWorld)this.field_70170_p, true);
        if (this.dirty >= 0) {
            ++this.dirty;
        }
        if (this.dirty >= 8) {
            this.dirty = -1;
            for (int i = 1; i < this.heldBlock.length; ++i) {
                if (this.heldBlock[i] <= 0) continue;
                this.sendHoldBlock(i, this.heldBlock[i]);
            }
        }
        this.updateBlockFrenzy();
        this.updateTeleport();
    }

    private int getAvailableHand() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 1; i < this.heldBlock.length; ++i) {
            if (this.heldBlock[i] != 0) continue;
            list.add(i);
        }
        if (list.isEmpty()) {
            return -1;
        }
        return (Integer)list.get(this.field_70146_Z.nextInt(list.size()));
    }

    private int getFavorableHand() {
        ArrayList<Integer> outer = new ArrayList<Integer>();
        ArrayList<Integer> inner = new ArrayList<Integer>();
        for (int i = 1; i < this.heldBlock.length; ++i) {
            if (this.heldBlock[i] != 0) continue;
            if (i <= 2) {
                outer.add(i);
                continue;
            }
            inner.add(i);
        }
        if (outer.isEmpty() && inner.isEmpty()) {
            return -1;
        }
        if (!outer.isEmpty()) {
            return (Integer)outer.get(this.field_70146_Z.nextInt(outer.size()));
        }
        return (Integer)inner.get(this.field_70146_Z.nextInt(inner.size()));
    }

    private int getThrowingHand() {
        ArrayList<Integer> outer = new ArrayList<Integer>();
        ArrayList<Integer> inner = new ArrayList<Integer>();
        for (int i = 1; i < this.heldBlock.length; ++i) {
            if (this.heldBlock[i] == 0) continue;
            if (i <= 2) {
                outer.add(i);
                continue;
            }
            inner.add(i);
        }
        if (outer.isEmpty() && inner.isEmpty()) {
            return -1;
        }
        if (!inner.isEmpty()) {
            return (Integer)inner.get(this.field_70146_Z.nextInt(inner.size()));
        }
        return (Integer)outer.get(this.field_70146_Z.nextInt(outer.size()));
    }

    public boolean func_70652_k(Entity entityIn) {
        if (!this.field_70170_p.field_72995_K && !this.isAnimationPlaying()) {
            int i = this.getAvailableHand();
            if (!this.teleportByChance(6, entityIn)) {
                if (i != -1) {
                    boolean allHandsFree;
                    boolean bl = allHandsFree = this.heldBlock[1] == 0 && this.heldBlock[2] == 0;
                    if (allHandsFree && this.field_70146_Z.nextInt(10) == 0) {
                        this.animation = CLONE_ANIMATION;
                    } else if (allHandsFree && this.field_70146_Z.nextInt(7) == 0) {
                        this.animation = TELESMASH_ANIMATION;
                    } else {
                        this.setActiveArm(i);
                        this.animation = MELEE_ANIMATION;
                    }
                } else {
                    this.triggerThrowBlock = true;
                }
            }
        }
        if (this.isClone()) {
            boolean flag = super.func_70652_k(entityIn);
            if (!this.field_70170_p.field_72995_K && this.field_70146_Z.nextInt(2) == 0) {
                double x = entityIn.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * 24.0;
                double y = entityIn.func_226278_cu_() + (double)this.field_70146_Z.nextInt(5) + 4.0;
                double z = entityIn.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * 24.0;
                this.teleportTo(x, y, z);
            }
            if (flag) {
                this.func_70691_i(2.0f);
                this.func_174815_a((LivingEntity)this, entityIn);
            }
            this.func_184609_a(Hand.MAIN_HAND);
            return flag;
        }
        return true;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!(source.func_76346_g() instanceof EnderDragonEntity) && !(source.func_76346_g() instanceof MutantEndermanEntity)) {
            if ((this.animation == TELEPORT_ANIMATION || this.animation == SCREAM_ANIMATION) && source != DamageSource.field_76380_i) {
                return false;
            }
            if (!this.field_70170_p.field_72995_K) {
                Entity entity;
                boolean betterDodge;
                if (this.isClone()) {
                    this.setClone(false);
                }
                if (this.animation == STARE_ANIMATION) {
                    this.animation = Animation.NONE;
                }
                boolean bl = betterDodge = (entity = source.func_76346_g()) == null;
                if (source.func_76352_a() || source.func_94541_c() || source == DamageSource.field_76379_h) {
                    betterDodge = true;
                }
                if (this.teleportByChance(betterDodge ? 3 : 6, entity) && source != DamageSource.field_76380_i) {
                    if (entity instanceof LivingEntity) {
                        this.func_70604_c((LivingEntity)entity);
                    }
                    return false;
                }
                boolean betterTeleport = source == DamageSource.field_76369_e || source == DamageSource.field_180137_b;
                this.teleportByChance(betterTeleport ? 3 : 5, entity);
            }
            return super.func_70097_a(source, amount);
        }
        return false;
    }

    public boolean func_195064_c(EffectInstance effectInstanceIn) {
        return !this.isClone() && super.func_195064_c(effectInstanceIn);
    }

    private boolean teleportByChance(int chance, @Nullable Entity entity) {
        if (this.isAnimationPlaying() && !this.isClone()) {
            return false;
        }
        if (this.field_70146_Z.nextInt(Math.max(1, chance)) == 0) {
            return entity == null ? this.teleportRandomly() : this.teleportToEntity(entity);
        }
        return false;
    }

    private boolean teleportRandomly() {
        if (this.isAnimationPlaying() && !this.isClone()) {
            return false;
        }
        double radius = 24.0;
        double x = this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * 2.0 * radius;
        double y = this.func_226278_cu_() + (double)this.field_70146_Z.nextInt((int)radius * 2) - radius;
        double z = this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * 2.0 * radius;
        return this.teleportTo(x, y, z);
    }

    private boolean teleportToEntity(Entity entity) {
        double radius;
        if (this.isAnimationPlaying() && !this.isClone()) {
            return false;
        }
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double d = radius = this.func_189748_bU() != null && this.func_189748_bU().func_76352_a() ? 4.0 : 16.0;
        if (this.func_70068_e(entity) < 100.0) {
            x = entity.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * 2.0 * radius;
            y = entity.func_226278_cu_() + this.field_70146_Z.nextDouble() * radius;
            z = entity.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * 2.0 * radius;
        } else {
            Vector3d vec = new Vector3d(this.func_226277_ct_() - entity.func_226277_ct_(), this.func_226283_e_(0.5) - entity.func_226280_cw_(), this.func_226281_cx_() - entity.func_226281_cx_());
            vec = vec.func_72432_b();
            x = this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec.field_72450_a * radius;
            y = this.func_226278_cu_() + (double)this.field_70146_Z.nextInt(8) - vec.field_72448_b * radius;
            z = this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec.field_72449_c * radius;
        }
        return this.teleportTo(x, y, z);
    }

    private boolean teleportTo(double targetX, double targetY, double targetZ) {
        if (this.func_175446_cd()) {
            return false;
        }
        if (this.isClone()) {
            boolean flag = EntityUtil.teleportTo((MobEntity)this, targetX, targetY, targetZ);
            if (flag) {
                this.func_184210_p();
                this.field_70699_by.func_75499_g();
                if (!this.func_174814_R()) {
                    this.field_70170_p.func_184134_a(this.field_70169_q, this.field_70167_r, this.field_70166_s, MBSoundEvents.ENTITY_ENDERSOUL_CLONE_TELEPORT, this.func_184176_by(), 1.0f, 1.0f, false);
                    this.func_184185_a(MBSoundEvents.ENTITY_ENDERSOUL_CLONE_TELEPORT, 1.0f, 1.0f);
                }
            }
            return flag;
        }
        if (!this.isAnimationPlaying()) {
            this.animation = TELEPORT_ANIMATION;
            double oldX = this.func_226277_ct_();
            double oldY = this.func_226278_cu_();
            double oldZ = this.func_226281_cx_();
            double newY = targetY;
            BlockPos pos = new BlockPos(targetX, targetY, targetZ);
            boolean success = false;
            if (this.field_70170_p.func_195588_v(pos)) {
                boolean temp = false;
                while (!temp && pos.func_177956_o() > 0) {
                    BlockPos posDown = pos.func_177977_b();
                    if (this.field_70170_p.func_180495_p(posDown).func_185904_a().func_76230_c()) {
                        temp = true;
                        continue;
                    }
                    newY -= 1.0;
                    pos = posDown;
                }
                if (temp) {
                    this.func_70107_b(targetX, newY, targetZ);
                    if (this.field_70170_p.func_226669_j_((Entity)this) && !this.field_70170_p.func_72953_d(this.func_174813_aQ())) {
                        success = true;
                    }
                }
            }
            this.func_70107_b(oldX, oldY, oldZ);
            if (!success) {
                this.animation = Animation.NONE;
                return false;
            }
            this.func_184210_p();
            this.setTeleportPosition(pos);
            return true;
        }
        return false;
    }

    public static void teleportAttack(LivingEntity attacker) {
        double radius = 3.0;
        int duration = 140 + attacker.func_70681_au().nextInt(60);
        DamageSource damageSource = DamageSource.func_76358_a((LivingEntity)attacker);
        if (attacker instanceof PlayerEntity) {
            radius = 2.0;
            duration = 100;
            damageSource = DamageSource.func_76365_a((PlayerEntity)((PlayerEntity)attacker));
        }
        for (Entity entity : attacker.field_70170_p.func_175674_a((Entity)attacker, attacker.func_174813_aQ().func_186662_g(radius), EndersoulFragmentEntity.IS_VALID_TARGET)) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.func_70097_a(damageSource, 4.0f);
            if (attacker.func_70681_au().nextInt(3) == 0) {
                livingEntity.func_195064_c(new EffectInstance(Effects.field_76440_q, duration));
            }
            double x = entity.func_226277_ct_() - attacker.func_226277_ct_();
            double z = entity.func_226281_cx_() - attacker.func_226281_cx_();
            double signX = x / Math.abs(x);
            double signZ = z / Math.abs(z);
            livingEntity.func_213293_j((radius * signX * 2.0 - x) * (double)0.2f, (double)0.2f, (radius * signZ * 2.0 - z) * (double)0.2f);
        }
    }

    private void spawnBigParticles() {
        int temp = 256;
        if (this.animation == TELEPORT_ANIMATION) {
            temp *= 2;
        }
        for (int i = 0; i < temp; ++i) {
            double tempX;
            boolean usePosition;
            float f = (this.field_70146_Z.nextFloat() - 0.5f) * 1.8f;
            float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 1.8f;
            float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 1.8f;
            boolean bl = usePosition = i < temp / 2;
            if (this.animation != TELEPORT_ANIMATION) {
                usePosition = true;
            }
            boolean death = this.animation != DEATH_ANIMATION;
            double h = death ? (double)this.func_213302_cg() : (double)(this.func_213302_cg() + 1.0f);
            double w = death ? (double)this.func_213311_cf() : (double)(this.func_213311_cf() * 1.5f);
            double d = tempX = usePosition ? this.func_226277_ct_() : (double)this.getTeleportPosition().func_177958_n() + (this.field_70146_Z.nextDouble() - 0.5) * w;
            double tempY = usePosition ? this.func_226278_cu_() : (double)this.getTeleportPosition().func_177956_o() + (this.field_70146_Z.nextDouble() - 0.5) * h + (double)(death ? 1.5f : 0.5f);
            double tempZ = usePosition ? this.func_226281_cx_() : (double)this.getTeleportPosition().func_177952_p() + (this.field_70146_Z.nextDouble() - 0.5) * w;
            this.field_70170_p.func_195594_a((IParticleData)MBParticleTypes.ENDERSOUL, tempX, tempY, tempZ, (double)f, (double)f1, (double)f2);
        }
    }

    protected boolean func_184228_n(Entity entityIn) {
        return false;
    }

    public boolean func_96092_aw() {
        return false;
    }

    protected void func_213371_e(LivingEntity livingEntity) {
        if (!this.isClone()) {
            livingEntity.func_70108_f((Entity)this);
            livingEntity.field_70133_I = true;
        }
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        this.capturedEntities = null;
        if (!this.field_70170_p.field_72995_K) {
            this.deathCause = cause;
            this.setTeleportPosition(null);
            IAnimatedEntity.sendAnimationPacket(this, DEATH_ANIMATION);
            if (this.isClone()) {
                this.setClone(false);
            }
            if (this.field_70718_bc > 0) {
                this.field_70718_bc += DEATH_ANIMATION.getDuration();
            }
        }
    }

    protected void func_70609_aI() {
        this.func_213293_j(0.0, Math.min(this.func_213322_ci().field_72448_b, 0.0), 0.0);
        if (this.field_70725_aQ == 80) {
            this.func_184185_a(MBSoundEvents.ENTITY_MUTANT_ENDERMAN_DEATH, 5.0f, this.func_70647_i());
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70725_aQ >= 60) {
                if (this.field_70725_aQ < 80 && this.capturedEntities == null) {
                    this.capturedEntities = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72314_b(10.0, 8.0, 10.0), EndersoulFragmentEntity.IS_VALID_TARGET);
                }
                if (this.field_70146_Z.nextInt(3) != 0) {
                    EndersoulFragmentEntity orb = new EndersoulFragmentEntity(this.field_70170_p, this);
                    orb.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_() + 3.8, this.func_226281_cx_());
                    orb.func_213293_j((this.field_70146_Z.nextFloat() - 0.5f) * 1.5f, (this.field_70146_Z.nextFloat() - 0.5f) * 1.5f, (this.field_70146_Z.nextFloat() - 0.5f) * 1.5f);
                    this.field_70170_p.func_217376_c((Entity)orb);
                }
            }
            if (this.field_70725_aQ >= 80 && this.field_70725_aQ < DEATH_ANIMATION.getDuration() - 20 && this.capturedEntities != null) {
                for (int i = 0; i < this.capturedEntities.size(); ++i) {
                    Entity entity = this.capturedEntities.get(i);
                    if (entity.field_70143_R > 4.5f) {
                        entity.field_70143_R = 4.5f;
                    }
                    if (!(this.func_70068_e(entity) > 64.0)) continue;
                    if (EndersoulFragmentEntity.isProtected(entity) || entity instanceof PlayerEntity && !entity.func_70089_S()) {
                        this.capturedEntities.remove(i);
                        --i;
                        continue;
                    }
                    double x = this.func_226277_ct_() - entity.func_226277_ct_();
                    double y = entity.func_213322_ci().field_72448_b;
                    double z = this.func_226281_cx_() - entity.func_226281_cx_();
                    double d = Math.sqrt(x * x + z * z);
                    if (this.func_226278_cu_() + 4.0 > entity.func_226278_cu_()) {
                        y = Math.max(entity.func_213322_ci().field_72448_b, (double)0.4f);
                    }
                    entity.func_213293_j((double)0.8f * x / d, y, (double)0.8f * z / d);
                    EntityUtil.sendPlayerVelocityPacket(entity);
                }
            }
            if (this.field_70725_aQ >= 100 && this.field_70725_aQ < 150 && this.field_70725_aQ % 6 == 0) {
                super.func_213345_d(this.deathCause != null ? this.deathCause : DamageSource.field_76377_j);
            }
        }
        if (this.field_70725_aQ >= DEATH_ANIMATION.getDuration()) {
            super.func_226294_cV_();
            this.func_70106_y();
        }
    }

    protected void func_213345_d(DamageSource damageSourceIn) {
    }

    protected void func_213333_a(DamageSource source, int looting, boolean recentlyHitIn) {
    }

    protected void func_226294_cV_() {
    }

    public ItemEntity func_199701_a_(ItemStack stack) {
        return this.func_70099_a(stack, this.field_70725_aQ > 0 ? 3.84f : 0.0f);
    }

    public static boolean canSpawn(EntityType<MutantEndermanEntity> type, IWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        return randomIn.nextInt(3) == 0 && MutantEndermanEntity.func_223325_c(type, (IWorld)worldIn, (SpawnReason)reason, (BlockPos)pos, (Random)randomIn);
    }

    protected ITextComponent func_225513_by_() {
        return this.isClone() ? MBEntityType.ENDERSOUL_CLONE.func_212546_e() : super.func_225513_by_();
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        this.func_233682_c_(compound);
        compound.func_74768_a("BlockFrenzy", this.blockFrenzy);
        compound.func_74768_a("ScreamDelay", this.screamDelayTick);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.func_241358_a_((ServerWorld)this.field_70170_p, compound);
        this.blockFrenzy = compound.func_74762_e("BlockFrenzy");
        this.screamDelayTick = compound.func_74762_e("ScreamDelay");
        if (this.field_70725_aQ > 0) {
            IAnimatedEntity.sendAnimationPacket(this, DEATH_ANIMATION, this.field_70725_aQ);
        }
    }

    public int func_70627_aG() {
        return 200;
    }

    public void func_70642_aH() {
        if (this.animation != SCREAM_ANIMATION && !this.isClone()) {
            super.func_70642_aH();
        }
    }

    protected SoundEvent func_184639_G() {
        return MBSoundEvents.ENTITY_MUTANT_ENDERMAN_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return MBSoundEvents.ENTITY_MUTANT_ENDERMAN_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return null;
    }

    public void sendHoldBlock(int blockIndex, int blockId) {
        if (!this.field_70170_p.field_72995_K) {
            this.heldBlock[blockIndex] = blockId;
            this.heldBlockTick[blockIndex] = 0;
            MBPacketHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new HeldBlockPacket(this, blockId, blockIndex));
        }
    }

    private boolean isBeingLookedAtBy(LivingEntity target) {
        if (target instanceof MobEntity) {
            MobEntity mob = (MobEntity)target;
            return mob.func_70685_l((Entity)this) && mob.func_70638_az() == this;
        }
        Vector3d lookVec = target.func_70676_i(1.0f).func_72432_b();
        Vector3d targetVec = new Vector3d(this.func_226277_ct_() - target.func_226277_ct_(), this.func_226280_cw_() - target.func_226280_cw_(), this.func_226281_cx_() - target.func_226281_cx_());
        double length = targetVec.func_72433_c();
        double d = lookVec.func_72430_b(targetVec = targetVec.func_72432_b());
        return d > 1.0 - 0.08 / length ? target.func_70685_l((Entity)this) : false;
    }

    static class ThrowBlockGoal
    extends AnimationGoal<MutantEndermanEntity> {
        public ThrowBlockGoal(MutantEndermanEntity mob) {
            super(mob);
        }

        @Override
        protected Animation getAnimation() {
            return THROW_ANIMATION;
        }

        @Override
        public boolean func_75250_a() {
            if (((MutantEndermanEntity)this.mob).isAnimationPlaying()) {
                return false;
            }
            if (!((MutantEndermanEntity)this.mob).triggerThrowBlock && ((MutantEndermanEntity)this.mob).func_70681_au().nextInt(28) != 0) {
                return false;
            }
            if (((MutantEndermanEntity)this.mob).func_70638_az() != null && !((MutantEndermanEntity)this.mob).func_70685_l((Entity)((MutantEndermanEntity)this.mob).func_70638_az())) {
                return false;
            }
            int id = ((MutantEndermanEntity)this.mob).getThrowingHand();
            if (id == -1) {
                return false;
            }
            ((MutantEndermanEntity)this.mob).setActiveArm(id);
            return true;
        }

        @Override
        public void func_75249_e() {
            super.func_75249_e();
            int id = ((MutantEndermanEntity)this.mob).getActiveArm();
            ((MutantEndermanEntity)this.mob).field_70170_p.func_217376_c((Entity)new ThrowableBlockEntity(((MutantEndermanEntity)this.mob).field_70170_p, (MutantEndermanEntity)this.mob, id));
            ((MutantEndermanEntity)this.mob).sendHoldBlock(id, 0);
        }

        @Override
        public void func_75251_c() {
            super.func_75251_c();
            ((MutantEndermanEntity)this.mob).setActiveArm(0);
            ((MutantEndermanEntity)this.mob).triggerThrowBlock = false;
        }
    }

    static class TeleSmashGoal
    extends AnimationGoal<MutantEndermanEntity> {
        private LivingEntity attackTarget;

        public TeleSmashGoal(MutantEndermanEntity mob) {
            super(mob);
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        @Override
        protected Animation getAnimation() {
            return TELESMASH_ANIMATION;
        }

        @Override
        public boolean func_75250_a() {
            this.attackTarget = ((MutantEndermanEntity)this.mob).func_70638_az();
            return this.attackTarget != null && super.func_75250_a();
        }

        @Override
        public void func_75249_e() {
            super.func_75249_e();
            this.attackTarget.func_195064_c(new EffectInstance(Effects.field_76421_d, 20, 5));
            this.attackTarget.func_195064_c(new EffectInstance(Effects.field_76431_k, 160 + this.attackTarget.func_70681_au().nextInt(160), 0));
        }

        public void func_75246_d() {
            if (((MutantEndermanEntity)this.mob).animationTick < 20) {
                ((MutantEndermanEntity)this.mob).func_70671_ap().func_75651_a((Entity)this.attackTarget, 30.0f, 30.0f);
            }
            if (((MutantEndermanEntity)this.mob).animationTick == 17) {
                this.attackTarget.func_184210_p();
            }
            if (((MutantEndermanEntity)this.mob).animationTick == 18) {
                double x = this.attackTarget.func_226277_ct_() + (double)((this.attackTarget.func_70681_au().nextFloat() - 0.5f) * 14.0f);
                double y = this.attackTarget.func_226278_cu_() + (double)this.attackTarget.func_70681_au().nextFloat() + (this.attackTarget instanceof PlayerEntity ? 13.0 : 7.0);
                double z = this.attackTarget.func_226281_cx_() + (double)((this.attackTarget.func_70681_au().nextFloat() - 0.5f) * 14.0f);
                EntityUtil.stunRavager(this.attackTarget);
                EntityUtil.sendParticlePacket((Entity)this.attackTarget, (IParticleData)MBParticleTypes.ENDERSOUL, 256);
                this.attackTarget.func_70634_a(x, y, z);
                ((MutantEndermanEntity)this.mob).field_70170_p.func_184133_a(null, this.attackTarget.func_233580_cy_(), SoundEvents.field_187539_bB, this.attackTarget.func_184176_by(), 1.2f, 0.9f + this.attackTarget.func_70681_au().nextFloat() * 0.2f);
                this.attackTarget.func_70097_a(DamageSource.func_76358_a((LivingEntity)this.mob).func_76348_h(), 6.0f);
            }
        }

        @Override
        public void func_75251_c() {
            super.func_75251_c();
            this.attackTarget = null;
        }
    }

    static class TeleportGoal
    extends AnimationGoal<MutantEndermanEntity> {
        public TeleportGoal(MutantEndermanEntity mob) {
            super(mob);
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        @Override
        protected Animation getAnimation() {
            return TELEPORT_ANIMATION;
        }

        @Override
        public void func_75249_e() {
            super.func_75249_e();
            if (((MutantEndermanEntity)this.mob).func_70638_az() != null) {
                ((MutantEndermanEntity)this.mob).func_70671_ap().func_75651_a((Entity)((MutantEndermanEntity)this.mob).func_70638_az(), 30.0f, 30.0f);
            }
            MutantEndermanEntity.teleportAttack((LivingEntity)this.mob);
            ((MutantEndermanEntity)this.mob).func_70107_b((double)((MutantEndermanEntity)this.mob).getTeleportPosition().func_177958_n() + 0.5, ((MutantEndermanEntity)this.mob).getTeleportPosition().func_177956_o(), (double)((MutantEndermanEntity)this.mob).getTeleportPosition().func_177952_p() + 0.5);
            ((MutantEndermanEntity)this.mob).field_70170_p.func_184148_a(null, ((MutantEndermanEntity)this.mob).field_70169_q, ((MutantEndermanEntity)this.mob).field_70167_r + (double)((MutantEndermanEntity)this.mob).func_213302_cg() / 2.0, ((MutantEndermanEntity)this.mob).field_70166_s, MBSoundEvents.ENTITY_MUTANT_ENDERMAN_TELEPORT, ((MutantEndermanEntity)this.mob).func_184176_by(), 1.0f, 1.0f);
            ((MutantEndermanEntity)this.mob).func_184185_a(MBSoundEvents.ENTITY_MUTANT_ENDERMAN_TELEPORT, 1.0f, 1.0f);
            MutantEndermanEntity.teleportAttack((LivingEntity)this.mob);
            ((MutantEndermanEntity)this.mob).func_70107_b(((MutantEndermanEntity)this.mob).field_70169_q, ((MutantEndermanEntity)this.mob).field_70167_r, ((MutantEndermanEntity)this.mob).field_70166_s);
        }

        @Override
        public void func_75251_c() {
            super.func_75251_c();
            ((MutantEndermanEntity)this.mob).func_70634_a((double)((MutantEndermanEntity)this.mob).getTeleportPosition().func_177958_n() + 0.5, ((MutantEndermanEntity)this.mob).getTeleportPosition().func_177956_o(), (double)((MutantEndermanEntity)this.mob).getTeleportPosition().func_177952_p() + 0.5);
            ((MutantEndermanEntity)this.mob).setTeleportPosition(null);
        }
    }

    static class ScreamGoal
    extends AnimationGoal<MutantEndermanEntity> {
        public ScreamGoal(MutantEndermanEntity mob) {
            super(mob);
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        @Override
        protected Animation getAnimation() {
            return SCREAM_ANIMATION;
        }

        @Override
        public boolean func_75250_a() {
            if (((MutantEndermanEntity)this.mob).func_70638_az() != null && !((MutantEndermanEntity)this.mob).isAnimationPlaying()) {
                return ((MutantEndermanEntity)this.mob).screamDelayTick > 0 ? false : ((MutantEndermanEntity)this.mob).field_70146_Z.nextInt(((MutantEndermanEntity)this.mob).func_70026_G() ? 400 : 1200) == 0;
            }
            return false;
        }

        public void func_75246_d() {
            if (((MutantEndermanEntity)this.mob).animationTick == 40) {
                ((MutantEndermanEntity)this.mob).field_70170_p.func_72912_H().func_76084_b(false);
                ((MutantEndermanEntity)this.mob).field_70170_p.func_72960_a((Entity)this.mob, (byte)0);
                ((MutantEndermanEntity)this.mob).func_184185_a(MBSoundEvents.ENTITY_MUTANT_ENDERMAN_SCREAM, 5.0f, 0.7f + ((MutantEndermanEntity)this.mob).field_70146_Z.nextFloat() * 0.2f);
                for (Entity entity : ((MutantEndermanEntity)this.mob).field_70170_p.func_175647_a(Entity.class, ((MutantEndermanEntity)this.mob).func_174813_aQ().func_72314_b(20.0, 12.0, 20.0), EndersoulFragmentEntity.IS_VALID_TARGET)) {
                    if (!(((MutantEndermanEntity)this.mob).func_70068_e(entity) < 400.0)) continue;
                    entity.func_70097_a(DamageSource.func_76358_a((LivingEntity)this.mob).func_76348_h().func_151518_m(), 4.0f);
                    if (!(entity instanceof MobEntity)) continue;
                    MobEntity mobEntity = (MobEntity)entity;
                    mobEntity.func_195064_c(new EffectInstance(Effects.field_76421_d, 120, 3));
                    if (((MutantEndermanEntity)this.mob).field_70146_Z.nextInt(2) != 0) {
                        mobEntity.func_195064_c(new EffectInstance(Effects.field_76436_u, 120 + ((MutantEndermanEntity)this.mob).field_70146_Z.nextInt(180), ((MutantEndermanEntity)this.mob).field_70146_Z.nextInt(2)));
                    }
                    if (((MutantEndermanEntity)this.mob).field_70146_Z.nextInt(4) != 0) {
                        mobEntity.func_195064_c(new EffectInstance(Effects.field_76437_t, 300 + ((MutantEndermanEntity)this.mob).field_70146_Z.nextInt(300), ((MutantEndermanEntity)this.mob).field_70146_Z.nextInt(2)));
                    }
                    if (((MutantEndermanEntity)this.mob).field_70146_Z.nextInt(3) != 0) {
                        mobEntity.func_195064_c(new EffectInstance(Effects.field_76438_s, 120 + ((MutantEndermanEntity)this.mob).field_70146_Z.nextInt(60), 10 + ((MutantEndermanEntity)this.mob).field_70146_Z.nextInt(2)));
                    }
                    if (((MutantEndermanEntity)this.mob).field_70146_Z.nextInt(4) == 0) continue;
                    mobEntity.func_195064_c(new EffectInstance(Effects.field_76431_k, 120 + ((MutantEndermanEntity)this.mob).field_70146_Z.nextInt(400)));
                }
            }
        }

        @Override
        public void func_75251_c() {
            super.func_75251_c();
            ((MutantEndermanEntity)this.mob).screamDelayTick = 600;
        }
    }

    static class CloneGoal
    extends AnimationGoal<MutantEndermanEntity> {
        private final List<EndersoulCloneEntity> cloneList = new ArrayList<EndersoulCloneEntity>();
        private LivingEntity attackTarget;

        public CloneGoal(MutantEndermanEntity mob) {
            super(mob);
        }

        @Override
        protected Animation getAnimation() {
            return CLONE_ANIMATION;
        }

        @Override
        public boolean func_75250_a() {
            this.attackTarget = ((MutantEndermanEntity)this.mob).func_70638_az();
            if (this.attackTarget == null) {
                return false;
            }
            if (((MutantEndermanEntity)this.mob).heldBlock[1] == 0 && ((MutantEndermanEntity)this.mob).heldBlock[2] == 0) {
                return super.func_75250_a() || !((MutantEndermanEntity)this.mob).isAnimationPlaying() && ((MutantEndermanEntity)this.mob).field_70146_Z.nextInt(300) == 0;
            }
            return false;
        }

        @Override
        public void func_75249_e() {
            super.func_75249_e();
            ((MutantEndermanEntity)this.mob).field_70138_W = 1.0f;
            ((MutantEndermanEntity)this.mob).setClone(true);
            ((MutantEndermanEntity)this.mob).func_70066_B();
            ((MutantEndermanEntity)this.mob).func_195061_cb();
            for (int i = 0; i < 7; ++i) {
                double x = this.attackTarget.func_226277_ct_() + (((MutantEndermanEntity)this.mob).field_70146_Z.nextDouble() - 0.5) * 24.0;
                double y = this.attackTarget.func_226278_cu_() + 8.0;
                double z = this.attackTarget.func_226281_cx_() + (((MutantEndermanEntity)this.mob).field_70146_Z.nextDouble() - 0.5) * 24.0;
                this.createClone(x, y, z);
            }
            this.createClone(((MutantEndermanEntity)this.mob).field_70169_q, ((MutantEndermanEntity)this.mob).field_70167_r, ((MutantEndermanEntity)this.mob).field_70166_s);
            double x = this.attackTarget.func_226277_ct_() + (((MutantEndermanEntity)this.mob).field_70146_Z.nextDouble() - 0.5) * 24.0;
            double y = this.attackTarget.func_226278_cu_() + 8.0;
            double z = this.attackTarget.func_226281_cx_() + (((MutantEndermanEntity)this.mob).field_70146_Z.nextDouble() - 0.5) * 24.0;
            ((MutantEndermanEntity)this.mob).teleportTo(x, y, z);
            EntityUtil.divertAttackers(this.mob, (LivingEntity)this.getRandomClone());
        }

        @Override
        public boolean func_75253_b() {
            return super.func_75253_b() && ((MutantEndermanEntity)this.mob).func_70638_az() != null && !this.cloneList.isEmpty() && ((MutantEndermanEntity)this.mob).isClone();
        }

        public void func_75246_d() {
            for (int i = this.cloneList.size() - 1; i >= 0; --i) {
                if (this.cloneList.get(i).func_70089_S()) continue;
                EntityUtil.divertAttackers((MobEntity)this.cloneList.remove(i), (LivingEntity)this.getRandomClone());
            }
        }

        @Override
        public void func_75251_c() {
            super.func_75251_c();
            ((MutantEndermanEntity)this.mob).setClone(false);
            ((MutantEndermanEntity)this.mob).field_70138_W = 2.0f;
            for (EndersoulCloneEntity clone : this.cloneList) {
                if (!clone.func_70089_S()) continue;
                clone.func_174812_G();
                EntityUtil.divertAttackers((MobEntity)clone, (LivingEntity)this.mob);
            }
            this.cloneList.clear();
            ((MutantEndermanEntity)this.mob).field_70699_by.func_75499_g();
            this.attackTarget.func_70604_c((LivingEntity)this.mob);
            this.attackTarget = null;
        }

        private void createClone(double x, double y, double z) {
            EndersoulCloneEntity clone = (EndersoulCloneEntity)MBEntityType.ENDERSOUL_CLONE.func_200721_a(((MutantEndermanEntity)this.mob).field_70170_p);
            clone.setCloner((MutantEndermanEntity)this.mob);
            if (EntityUtil.teleportTo((MobEntity)clone, x, y, z)) {
                ((MutantEndermanEntity)this.mob).field_70170_p.func_217376_c((Entity)clone);
                this.cloneList.add(clone);
            }
        }

        private MobEntity getRandomClone() {
            return this.cloneList.isEmpty() ? this.mob : (MobEntity)this.cloneList.get(((MutantEndermanEntity)this.mob).field_70146_Z.nextInt(this.cloneList.size()));
        }
    }

    static class MeleeGoal
    extends AnimationGoal<MutantEndermanEntity> {
        public MeleeGoal(MutantEndermanEntity mob) {
            super(mob);
        }

        @Override
        protected Animation getAnimation() {
            return MELEE_ANIMATION;
        }

        public void func_75246_d() {
            if (((MutantEndermanEntity)this.mob).animationTick == 3) {
                ((MutantEndermanEntity)this.mob).func_184185_a(SoundEvents.field_187727_dV, 1.0f, ((MutantEndermanEntity)this.mob).func_70647_i());
                boolean lower = ((MutantEndermanEntity)this.mob).getActiveArm() >= 3;
                float attackDamage = (float)((MutantEndermanEntity)this.mob).func_233637_b_(Attributes.field_233823_f_);
                DamageSource source = DamageSource.func_76358_a((LivingEntity)this.mob);
                for (Entity entity : ((MutantEndermanEntity)this.mob).field_70170_p.func_175674_a((Entity)this.mob, ((MutantEndermanEntity)this.mob).func_174813_aQ().func_186662_g(4.0), EndersoulFragmentEntity.IS_VALID_TARGET)) {
                    double dist = ((MutantEndermanEntity)this.mob).func_70032_d(entity);
                    double x = ((MutantEndermanEntity)this.mob).func_226277_ct_() - entity.func_226277_ct_();
                    double z = ((MutantEndermanEntity)this.mob).func_226281_cx_() - entity.func_226281_cx_();
                    if (!(((MutantEndermanEntity)this.mob).func_174813_aQ().field_72338_b <= entity.func_174813_aQ().field_72337_e) || !(dist <= 4.0) || !EntityUtil.isFacing((LivingEntity)this.mob, x, z, 3.0f + (1.0f - (float)dist / 4.0f) * 40.0f)) continue;
                    entity.func_70097_a(source, attackDamage > 0.0f ? attackDamage + (lower ? 1.0f : 3.0f) : 0.0f);
                    float power = 0.4f + ((MutantEndermanEntity)this.mob).field_70146_Z.nextFloat() * 0.2f;
                    if (!lower) {
                        power += 0.2f;
                    }
                    entity.func_213293_j(-x / dist * (double)power, (double)(power * 0.6f), -z / dist * (double)power);
                }
            }
        }
    }

    static class StareGoal
    extends AnimationGoal<MutantEndermanEntity> {
        private LivingEntity attackTarget;

        public StareGoal(MutantEndermanEntity mob) {
            super(mob);
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        @Override
        protected Animation getAnimation() {
            return STARE_ANIMATION;
        }

        @Override
        public boolean func_75250_a() {
            this.attackTarget = ((MutantEndermanEntity)this.mob).func_70638_az();
            return this.attackTarget != null && super.func_75250_a();
        }

        @Override
        public void func_75249_e() {
            super.func_75249_e();
            ((MutantEndermanEntity)this.mob).func_184185_a(MBSoundEvents.ENTITY_MUTANT_ENDERMAN_STARE, 2.5f, 0.7f + ((MutantEndermanEntity)this.mob).field_70146_Z.nextFloat() * 0.2f);
        }

        @Override
        public boolean func_75253_b() {
            return super.func_75253_b() && this.attackTarget.func_70089_S() && ((MutantEndermanEntity)this.mob).isBeingLookedAtBy(this.attackTarget);
        }

        public void func_75246_d() {
            ((MutantEndermanEntity)this.mob).field_70749_g.func_75651_a((Entity)this.attackTarget, 45.0f, 45.0f);
        }

        @Override
        public void func_75251_c() {
            super.func_75251_c();
            this.attackTarget.func_184210_p();
            this.attackTarget.func_70097_a(DamageSource.func_76358_a((LivingEntity)this.mob).func_76348_h().func_151518_m(), 2.0f);
            this.attackTarget.func_195064_c(new EffectInstance(Effects.field_76440_q, 160 + ((MutantEndermanEntity)this.mob).field_70146_Z.nextInt(140)));
            double x = ((MutantEndermanEntity)this.mob).func_226277_ct_() - this.attackTarget.func_226277_ct_();
            double z = ((MutantEndermanEntity)this.mob).func_226281_cx_() - this.attackTarget.func_226281_cx_();
            this.attackTarget.func_213293_j(x * (double)0.1f, (double)0.3f, z * (double)0.1f);
            EntityUtil.sendPlayerVelocityPacket((Entity)this.attackTarget);
            this.attackTarget = null;
        }
    }

    static class FindTargetGoal
    extends NearestAttackableTargetGoal<LivingEntity> {
        public FindTargetGoal(MutantEndermanEntity mutantEnderman) {
            super((MobEntity)mutantEnderman, LivingEntity.class, 10, false, false, target -> EndersoulFragmentEntity.IS_VALID_TARGET.test((Entity)target) && target.func_190631_cK() && (mutantEnderman.func_233680_b_((LivingEntity)target) || mutantEnderman.isBeingLookedAtBy(target) || EndersoulFragmentEntity.isProtected((Entity)target)));
        }

        public boolean func_75250_a() {
            if (this.field_75299_d.func_70638_az() != null || ((MutantEndermanEntity)this.field_75299_d).isAnimationPlaying()) {
                return false;
            }
            boolean flag = super.func_75250_a();
            if (flag && ((MutantEndermanEntity)this.field_75299_d).isBeingLookedAtBy(this.field_75309_a)) {
                ((MutantEndermanEntity)this.field_75299_d).animation = STARE_ANIMATION;
            }
            return flag;
        }

        protected AxisAlignedBB func_188511_a(double targetDistance) {
            return this.field_75299_d.func_174813_aQ().func_186662_g(targetDistance);
        }
    }
}

