/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.entity.mutant;

import chumbanotz.mutantbeasts.client.animationapi.Animation;
import chumbanotz.mutantbeasts.client.animationapi.IAnimatedEntity;
import chumbanotz.mutantbeasts.entity.ai.goal.AnimationGoal;
import chumbanotz.mutantbeasts.entity.ai.goal.AvoidDamageGoal;
import chumbanotz.mutantbeasts.entity.ai.goal.FleeRainGoal;
import chumbanotz.mutantbeasts.entity.ai.goal.MBHurtByTargetGoal;
import chumbanotz.mutantbeasts.entity.projectile.ThrowableBlockEntity;
import chumbanotz.mutantbeasts.pathfinding.MBGroundPathNavigator;
import chumbanotz.mutantbeasts.util.EntityUtil;
import chumbanotz.mutantbeasts.util.MBSoundEvents;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RangedAttackGoal;
import net.minecraft.entity.ai.goal.ReturnToVillageGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.GolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.SnowballEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.event.ForgeEventFactory;

public class MutantSnowGolemEntity
extends GolemEntity
implements IRangedAttackMob,
IAnimatedEntity,
IForgeShearable {
    private static final DataParameter<Boolean> JACK_O_LANTERN = EntityDataManager.func_187226_a(MutantSnowGolemEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final Animation THROW_ANIMATION = new Animation(20);
    private Animation animation = Animation.NONE;
    private int animationTick;

    public MutantSnowGolemEntity(EntityType<? extends MutantSnowGolemEntity> type, World worldIn) {
        super(type, worldIn);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimJumpGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new FleeRainGoal((CreatureEntity)this, 1.1));
        this.field_70714_bg.func_75776_a(2, (Goal)new RangedAttackGoal((IRangedAttackMob)this, 1.1, 30, 12.0f));
        this.field_70714_bg.func_75776_a(3, (Goal)new ThrowIceGoal(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new AvoidDamageGoal((CreatureEntity)this, 1.1));
        this.field_70714_bg.func_75776_a(5, (Goal)new ReturnToVillageGoal((CreatureEntity)this, 1.0, false));
        this.field_70714_bg.func_75776_a(6, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0, 1.0000001E-5f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, MobEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new MBHurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, MobEntity.class, 10, true, false, entity -> entity instanceof IMob && (!(entity instanceof CreeperEntity) || ((CreeperEntity)entity).func_70638_az() == this)));
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MutantSnowGolemEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 80.0).func_233815_a_(Attributes.field_233821_d_, 0.26).func_233814_a_(Attributes.field_233823_f_);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(JACK_O_LANTERN, (Object)true);
    }

    public boolean hasJackOLantern() {
        return (Boolean)this.field_70180_af.func_187225_a(JACK_O_LANTERN);
    }

    public void setJackOLantern(boolean jackOLantern) {
        this.field_70180_af.func_187227_b(JACK_O_LANTERN, (Object)jackOLantern);
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new MBGroundPathNavigator((MobEntity)this, worldIn).setAvoidRain(true);
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 2.0f;
    }

    public boolean func_213336_c(LivingEntity target) {
        return target instanceof IMob;
    }

    public float func_205022_a(BlockPos pos, IWorldReader worldIn) {
        return this.isSnowingAt(pos) ? 10.0f : 0.0f;
    }

    protected void func_184594_b(BlockPos pos) {
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.func_82168_bl();
        this.func_184644_a(PathNodeType.WATER, ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this) ? 16.0f : -1.0f);
        if (this.isAnimationPlaying()) {
            ++this.animationTick;
        }
        if (this.field_70170_p.func_226691_t_(this.func_233580_cy_()).func_225486_c(this.func_233580_cy_()) > 1.2f) {
            if (this.field_70146_Z.nextFloat() > Math.min(80.0f, this.func_110143_aJ()) * 0.01f) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_218425_n, this.func_226282_d_(0.6), this.func_226279_cv_() - 0.15, this.func_226287_g_(0.6), 0.0, 0.0, 0.0);
            }
            if (this.field_70173_aa % 60 == 0) {
                this.func_70097_a(DamageSource.field_76370_b, 1.0f);
            }
        }
        if (this.func_70089_S() && this.func_110143_aJ() < this.func_110138_aP() && this.field_70173_aa % 80 == 0 && this.isSnowingAt(this.func_233580_cy_())) {
            this.func_70691_i(1.0f);
        }
        if (!this.field_70170_p.field_72995_K && this.field_70122_E && ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this)) {
            int x = MathHelper.func_76128_c((double)this.func_226277_ct_());
            int y = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b);
            int z = MathHelper.func_76128_c((double)this.func_226281_cx_());
            for (int i = -2; i <= 2; ++i) {
                for (int j = -2; j <= 2; ++j) {
                    if (Math.abs(i) == 2 && Math.abs(j) == 2) continue;
                    BlockPos pos = new BlockPos(x + i, y, z + j);
                    BlockPos posDown = new BlockPos(x + i, y - 1, z + j);
                    BlockPos posAbove = new BlockPos(x + i, y + 1, z + j);
                    boolean placeSnow = this.field_70170_p.func_175623_d(pos) && this.field_70170_p.func_226691_t_(pos).func_225486_c(pos) < 0.95f && Blocks.field_150433_aE.func_176223_P().func_196955_c((IWorldReader)this.field_70170_p, pos);
                    boolean placeIce = this.field_70170_p.func_201671_F(posDown);
                    if (this.field_70170_p.func_201671_F(pos)) {
                        this.field_70170_p.func_175656_a(pos, Blocks.field_150432_aD.func_176223_P());
                    }
                    if (this.field_70170_p.func_201671_F(posAbove)) {
                        this.field_70170_p.func_175656_a(posAbove, Blocks.field_150432_aD.func_176223_P());
                    }
                    if (placeSnow && ((Math.abs(i) == 2 || Math.abs(j) == 2) && this.field_70146_Z.nextInt(20) != 0 || (Math.abs(i) == 1 || Math.abs(j) == 1) && this.field_70146_Z.nextInt(10) != 0) || placeIce && ((Math.abs(i) == 2 || Math.abs(j) == 2) && this.field_70146_Z.nextInt(14) != 0 || (Math.abs(i) == 1 || Math.abs(j) == 1) && this.field_70146_Z.nextInt(6) != 0)) continue;
                    if (placeSnow) {
                        this.field_70170_p.func_175656_a(pos, Blocks.field_150433_aE.func_176223_P());
                    }
                    if (!placeIce) continue;
                    this.field_70170_p.func_175656_a(posDown, Blocks.field_150432_aD.func_176223_P());
                }
            }
        }
    }

    private boolean isSnowingAt(BlockPos position) {
        if (!this.field_70170_p.func_72896_J()) {
            return false;
        }
        if (!this.field_70170_p.func_226660_f_(position)) {
            return false;
        }
        if (this.field_70170_p.func_205770_a(Heightmap.Type.MOTION_BLOCKING, position).func_177956_o() > position.func_177956_o()) {
            return false;
        }
        Biome biome = this.field_70170_p.func_226691_t_(position);
        return biome.func_201851_b() == Biome.RainType.SNOW && biome.func_225486_c(position) < 0.15f;
    }

    public boolean func_230270_dK_() {
        return true;
    }

    public boolean isShearable(ItemStack item, World world, BlockPos pos) {
        return this.hasJackOLantern();
    }

    public List<ItemStack> onSheared(PlayerEntity player, ItemStack item, World world, BlockPos pos, int fortune) {
        world.func_217384_a(null, (Entity)this, SoundEvents.field_232843_op_, player == null ? SoundCategory.BLOCKS : SoundCategory.PLAYERS, 1.0f, 1.0f);
        pos.func_177963_a(0.0, (double)this.func_70047_e(), 0.0);
        if (!world.func_201670_d()) {
            this.setJackOLantern(false);
            return Collections.singletonList(new ItemStack((IItemProvider)Items.field_221697_cK));
        }
        return Collections.emptyList();
    }

    @Override
    public Animation getAnimation() {
        return this.animation;
    }

    @Override
    public void setAnimation(Animation animation) {
        this.animation = animation;
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{THROW_ANIMATION};
    }

    @Override
    public int getAnimationTick() {
        return this.animationTick;
    }

    @Override
    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public void func_70103_a(byte id) {
        super.func_70103_a(id);
        if (id == 2 || id == 33 || id == 36 || id == 37 || id == 44) {
            EntityUtil.spawnParticlesAtEntity((Entity)this, (IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, Blocks.field_150433_aE.func_176223_P()), 30);
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (source.func_76364_f() instanceof SnowballEntity) {
            if (this.func_110143_aJ() < this.func_110138_aP()) {
                this.func_70691_i(1.0f);
                EntityUtil.spawnParticlesAtEntity((Entity)this, (IParticleData)ParticleTypes.field_197633_z, 1);
                EntityUtil.spawnParticlesAtEntity((Entity)this, (IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, Blocks.field_150433_aE.func_176223_P()), 10);
            }
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        if (this.animation != THROW_ANIMATION) {
            this.animation = THROW_ANIMATION;
        }
    }

    public static boolean canHarm(Entity attacker, Entity target) {
        if (!(attacker instanceof MutantSnowGolemEntity)) {
            return true;
        }
        return target instanceof IMob || target instanceof MobEntity || ((MobEntity)target).func_70638_az() == attacker || ((MutantSnowGolemEntity)attacker).func_70638_az() == target;
    }

    public Vector3d func_241205_ce_() {
        return new Vector3d(0.0, (double)(0.9f * this.func_70047_e()), (double)(this.func_213311_cf() * 0.2f));
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("JackOLantern", this.hasJackOLantern());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("Pumpkin") || compound.func_74767_n("JackOLantern")) {
            this.setJackOLantern(true);
        }
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return MBSoundEvents.ENTITY_MUTANT_SNOW_GOLEM_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return MBSoundEvents.ENTITY_MUTANT_SNOW_GOLEM_DEATH;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187815_fJ, 0.15f, 1.0f);
    }

    static class ThrowIceGoal
    extends AnimationGoal<MutantSnowGolemEntity> {
        private LivingEntity attackTarget;

        public ThrowIceGoal(MutantSnowGolemEntity mob) {
            super(mob);
        }

        @Override
        protected Animation getAnimation() {
            return THROW_ANIMATION;
        }

        @Override
        public boolean func_75250_a() {
            this.attackTarget = ((MutantSnowGolemEntity)this.mob).func_70638_az();
            return this.attackTarget != null && super.func_75250_a();
        }

        @Override
        public void func_75249_e() {
            super.func_75249_e();
            ((MutantSnowGolemEntity)this.mob).field_70699_by.func_75499_g();
        }

        public void func_75246_d() {
            ((MutantSnowGolemEntity)this.mob).field_70761_aq = ((MutantSnowGolemEntity)this.mob).field_70177_z;
            if (((MutantSnowGolemEntity)this.mob).animationTick == 7) {
                ThrowableBlockEntity block = new ThrowableBlockEntity((MutantSnowGolemEntity)this.mob, ((MutantSnowGolemEntity)this.mob).field_70170_p);
                block.func_70107_b(block.func_226277_ct_(), block.func_226278_cu_() + (double)1.4f, block.func_226281_cx_());
                double x = this.attackTarget.func_226277_ct_() - block.func_226277_ct_();
                double y = this.attackTarget.func_226278_cu_() - block.func_226278_cu_();
                double z = this.attackTarget.func_226281_cx_() - block.func_226281_cx_();
                double xz = Math.sqrt(x * x + z * z);
                block.func_70186_c(x, y + xz * (double)0.4f, z, 0.9f, 1.0f);
                ((MutantSnowGolemEntity)this.mob).field_70170_p.func_217376_c((Entity)block);
            }
        }
    }

    class SwimJumpGoal
    extends Goal {
        private final MutantSnowGolemEntity golem;
        private int jumpTick = 20;
        private boolean waterReplaced;
        private BlockPos.Mutable prevPos;

        public SwimJumpGoal(MutantSnowGolemEntity golem) {
            this.golem = golem;
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP));
            golem.field_70699_by.func_212239_d(true);
        }

        public boolean func_75250_a() {
            return this.golem.func_70090_H();
        }

        public void func_75249_e() {
            this.prevPos = new BlockPos.Mutable(this.golem.func_226277_ct_(), this.golem.func_174813_aQ().field_72338_b - 1.0, this.golem.func_226281_cx_());
            this.golem.func_213293_j((this.golem.field_70146_Z.nextFloat() - this.golem.field_70146_Z.nextFloat()) * 0.9f, 1.5, (this.golem.field_70146_Z.nextFloat() - this.golem.field_70146_Z.nextFloat()) * 0.9f);
            this.golem.func_70097_a(DamageSource.field_76369_e, 16.0f);
        }

        public boolean func_75253_b() {
            return this.jumpTick > 0;
        }

        public void func_75246_d() {
            --this.jumpTick;
            if (!this.waterReplaced && !this.golem.func_70090_H() && this.jumpTick < 17 && ForgeEventFactory.getMobGriefingEvent((World)this.golem.field_70170_p, (Entity)this.golem)) {
                this.prevPos.func_185336_p(this.getWaterSurfaceHeight(this.golem.field_70170_p, (BlockPos)this.prevPos));
                if ((double)this.prevPos.func_177956_o() > this.golem.func_226278_cu_()) {
                    return;
                }
                for (int x = -2; x <= 2; ++x) {
                    for (int y = -1; y <= 1; ++y) {
                        for (int z = -2; z <= 2; ++z) {
                            BlockPos pos;
                            if (y != 0 && (Math.abs(x) == 2 || Math.abs(z) == 2) || !this.golem.field_70170_p.func_175623_d(pos = this.prevPos.func_177982_a(x, y, z)) && !this.golem.field_70170_p.func_201671_F(pos) || (y != 0 ? (Math.abs(x) == 1 || Math.abs(z) == 1) && this.golem.field_70146_Z.nextInt(4) == 0 : (Math.abs(x) == 2 || Math.abs(z) == 2) && this.golem.field_70146_Z.nextInt(3) == 0)) continue;
                            this.golem.field_70170_p.func_175656_a(pos, Blocks.field_185778_de.func_176223_P());
                        }
                    }
                }
                BlockPos topPos = this.prevPos.func_177981_b(2);
                if (this.golem.field_70170_p.func_175623_d(topPos)) {
                    this.golem.field_70170_p.func_175656_a(topPos, Blocks.field_185778_de.func_176223_P());
                }
                this.waterReplaced = true;
            }
        }

        public void func_75251_c() {
            this.jumpTick = 20;
            this.waterReplaced = false;
            this.prevPos = null;
        }

        private int getWaterSurfaceHeight(World world, BlockPos coord) {
            int y = coord.func_177956_o();
            while (world.func_201671_F(new BlockPos(coord.func_177958_n(), y + 1, coord.func_177952_p()))) {
                ++y;
            }
            return y;
        }
    }
}

