/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.entity.mutant;

import chumbanotz.mutantbeasts.client.animationapi.Animation;
import chumbanotz.mutantbeasts.client.animationapi.IAnimatedEntity;
import chumbanotz.mutantbeasts.entity.ai.goal.AnimationGoal;
import chumbanotz.mutantbeasts.entity.ai.goal.AvoidDamageGoal;
import chumbanotz.mutantbeasts.entity.ai.goal.MBHurtByTargetGoal;
import chumbanotz.mutantbeasts.entity.ai.goal.MBMeleeAttackGoal;
import chumbanotz.mutantbeasts.pathfinding.MBGroundPathNavigator;
import chumbanotz.mutantbeasts.util.EntityUtil;
import chumbanotz.mutantbeasts.util.MBSoundEvents;
import chumbanotz.mutantbeasts.util.SeismicWave;
import chumbanotz.mutantbeasts.util.ZombieResurrection;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MoveThroughVillageGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.monster.ZombieVillagerEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.ForgeEventFactory;

public class MutantZombieEntity
extends MonsterEntity
implements IAnimatedEntity {
    private static final DataParameter<Integer> LIVES = EntityDataManager.func_187226_a(MutantZombieEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Byte> THROW_ATTACK_STATE = EntityDataManager.func_187226_a(MutantZombieEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    public static final int MAX_VANISH_TIME = 100;
    public static final int MAX_DEATH_TIME = 140;
    public static final Animation SLAM_GROUND_ANIMATION = new Animation(25);
    public static final Animation THROW_ANIMATION = new Animation(15);
    public static final Animation ROAR_ANIMATION = new Animation(120);
    private static final Animation[] ANIMATIONS = new Animation[]{SLAM_GROUND_ANIMATION, THROW_ANIMATION, ROAR_ANIMATION};
    private Animation animation = Animation.NONE;
    private int animationTick;
    public int throwHitTick = -1;
    public int throwFinishTick = -1;
    public int vanishTime;
    private final List<SeismicWave> seismicWaveList = new ArrayList<SeismicWave>();
    private final List<ZombieResurrection> resurrectionList = new ArrayList<ZombieResurrection>();
    private DamageSource deathCause;

    public MutantZombieEntity(EntityType<? extends MutantZombieEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70138_W = 1.0f;
        this.field_70728_aV = 30;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SlamGroundGoal(this));
        this.field_70714_bg.func_75776_a(0, (Goal)new RoarGoal(this));
        this.field_70714_bg.func_75776_a(0, (Goal)new ThrowAttackGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new MBMeleeAttackGoal((CreatureEntity)this, 1.2).setMaxAttackTick(0));
        this.field_70714_bg.func_75776_a(2, (Goal)new AvoidDamageGoal((CreatureEntity)this, 1.2));
        this.field_70714_bg.func_75776_a(3, (Goal)new MoveThroughVillageGoal((CreatureEntity)this, 1.0, true, 4, () -> false));
        this.field_70714_bg.func_75776_a(4, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new MBHurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true).func_190882_b(300));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractVillagerEntity.class, true));
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MutantZombieEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 150.0).func_233815_a_(Attributes.field_233823_f_, 12.0).func_233815_a_(Attributes.field_233819_b_, 35.0).func_233815_a_(Attributes.field_233821_d_, 0.26).func_233815_a_(Attributes.field_233820_c_, 1.0).func_233815_a_((Attribute)ForgeMod.SWIM_SPEED.get(), 4.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(LIVES, (Object)3);
        this.field_70180_af.func_187214_a(THROW_ATTACK_STATE, (Object)0);
    }

    public int getLives() {
        return (Integer)this.field_70180_af.func_187225_a(LIVES);
    }

    private void setLives(int lives) {
        this.field_70180_af.func_187227_b(LIVES, (Object)lives);
    }

    public boolean getThrowAttackHit() {
        return ((Byte)this.field_70180_af.func_187225_a(THROW_ATTACK_STATE) & 1) != 0;
    }

    private void setThrowAttackHit(boolean flag) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(THROW_ATTACK_STATE);
        this.field_70180_af.func_187227_b(THROW_ATTACK_STATE, (Object)(flag ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE)));
    }

    public boolean isThrowAttackFinished() {
        return ((Byte)this.field_70180_af.func_187225_a(THROW_ATTACK_STATE) & 2) != 0;
    }

    private void setThrowAttackFinished(boolean flag) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(THROW_ATTACK_STATE);
        this.field_70180_af.func_187227_b(THROW_ATTACK_STATE, (Object)(flag ? (byte)(b0 | 2) : (byte)(b0 & 0xFFFFFFFD)));
    }

    @Override
    public Animation getAnimation() {
        return this.animation;
    }

    @Override
    public void setAnimation(Animation animation) {
        this.animation = animation;
    }

    @Override
    public Animation[] getAnimations() {
        return ANIMATIONS;
    }

    @Override
    public int getAnimationTick() {
        return this.animationTick;
    }

    @Override
    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 2.8f;
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223223_b_;
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new MBGroundPathNavigator((MobEntity)this, worldIn);
    }

    protected float func_110146_f(float renderYawOffset, float distance) {
        return !this.func_70089_S() ? distance : super.func_110146_f(renderYawOffset, distance);
    }

    public int func_70641_bl() {
        return 1;
    }

    public int func_82143_as() {
        return 16;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    public boolean func_70104_M() {
        return !this.func_70617_f_();
    }

    public ActionResultType func_184199_a(PlayerEntity player, Vector3d vec, Hand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (!(itemStack.func_77973_b() != Items.field_151033_d || this.func_70089_S() || this.func_70027_ad() || this.func_70026_G())) {
            this.func_70015_d(8);
            itemStack.func_222118_a(1, (LivingEntity)player, livingEntity -> livingEntity.func_213334_d(hand));
            player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)itemStack.func_77973_b()));
            this.field_70170_p.func_184148_a(player, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187649_bu, this.func_184176_by(), 1.0f, this.field_70146_Z.nextFloat() * 0.4f + 0.8f);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public boolean func_70652_k(Entity entityIn) {
        if (!this.isAnimationPlaying()) {
            if (entityIn.func_184196_w((Entity)this) || this.field_70146_Z.nextInt(5) == 0) {
                this.animation = THROW_ANIMATION;
            } else if (this.field_70122_E || !this.func_213339_cH().func_204520_s().func_206888_e()) {
                this.animation = SLAM_GROUND_ANIMATION;
            }
            return true;
        }
        return super.func_70652_k(entityIn);
    }

    protected void func_70619_bc() {
        if (!this.isAnimationPlaying() && this.field_70122_E && this.func_70638_az() != null && this.func_70068_e((Entity)this.func_70638_az()) < 49.0) {
            int chance;
            int n = chance = !this.func_70781_l() || !this.func_70685_l((Entity)this.func_70638_az()) || this.func_189748_bU() != null && this.func_189748_bU().func_76352_a() ? 5 : 20;
            if (Math.abs(this.func_226278_cu_() - this.func_70638_az().func_226278_cu_()) <= 4.0 && this.field_70146_Z.nextInt(chance) == 0) {
                this.animation = SLAM_GROUND_ANIMATION;
            }
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        Entity entity;
        if (this.func_180431_b(source)) {
            return false;
        }
        if (source.func_76352_a() && source.func_188404_v() != null) {
            amount *= 0.5f;
        }
        if (this.animation == ROAR_ANIMATION && source != DamageSource.field_76380_i) {
            if (this.animationTick <= 10) {
                return false;
            }
            if (!source.func_151517_h()) {
                amount *= 0.15f;
            }
        }
        return (entity = source.func_76346_g()) != null && (!this.canHarm(entity) || this.animation == THROW_ANIMATION && entity == this.func_70638_az()) ? false : super.func_70097_a(source, amount);
    }

    protected void func_213623_ec() {
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return distanceToClosestPlayer > 16384.0;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.fixRotation();
        this.updateAnimation();
        this.updateMeleeGrounds();
        if (this.func_70089_S() && this.func_110143_aJ() < this.func_110138_aP() && this.field_70173_aa % 100 == 0 && this.field_70170_p.func_226690_K_()) {
            this.func_70691_i(2.0f);
        }
        for (int i = this.resurrectionList.size() - 1; i >= 0; --i) {
            ZombieResurrection zr = this.resurrectionList.get(i);
            if (zr.update(this)) continue;
            this.resurrectionList.remove((Object)zr);
        }
        if (this.func_110143_aJ() > 0.0f) {
            this.field_70725_aQ = 0;
            this.vanishTime = 0;
        }
        if (this.field_70123_F && ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this)) {
            AxisAlignedBB bb = this.func_174813_aQ().func_186662_g(0.2);
            for (BlockPos blockpos : BlockPos.func_191531_b((int)MathHelper.func_76128_c((double)bb.field_72340_a), (int)MathHelper.func_76128_c((double)bb.field_72338_b), (int)MathHelper.func_76128_c((double)bb.field_72339_c), (int)MathHelper.func_76128_c((double)bb.field_72336_d), (int)MathHelper.func_76128_c((double)bb.field_72337_e), (int)MathHelper.func_76128_c((double)bb.field_72334_f))) {
                Block block = this.field_70170_p.func_180495_p(blockpos).func_177230_c();
                if (this.field_70170_p.field_72995_K || !BlockTags.field_206952_E.func_230235_a_((Object)block) && !Tags.Blocks.GLASS.func_230235_a_((Object)block)) continue;
                this.field_70170_p.func_175655_b(blockpos, false);
            }
        }
    }

    private void fixRotation() {
        float yaw;
        for (yaw = this.field_70759_as - this.field_70761_aq; yaw < -180.0f; yaw += 360.0f) {
        }
        while (yaw >= 180.0f) {
            yaw -= 360.0f;
        }
        float offset = 0.1f;
        if (this.animation == SLAM_GROUND_ANIMATION) {
            offset = 0.2f;
        }
        this.field_70761_aq += yaw * offset;
    }

    protected void updateAnimation() {
        if (this.isAnimationPlaying()) {
            ++this.animationTick;
        }
        if (this.animation == THROW_ANIMATION) {
            if (this.getThrowAttackHit()) {
                if (this.throwHitTick == -1) {
                    this.throwHitTick = 0;
                }
                ++this.throwHitTick;
            }
            if (this.isThrowAttackFinished()) {
                if (this.throwFinishTick == -1) {
                    this.throwFinishTick = 0;
                }
                ++this.throwFinishTick;
            }
        } else {
            this.throwHitTick = -1;
            this.throwFinishTick = -1;
        }
    }

    protected void updateMeleeGrounds() {
        if (!this.seismicWaveList.isEmpty()) {
            SeismicWave wave = this.seismicWaveList.remove(0);
            wave.affectBlocks(this.field_70170_p, (Entity)this);
            AxisAlignedBB box = new AxisAlignedBB((double)wave.func_177958_n(), (double)wave.func_177956_o() + 1.0, (double)wave.func_177952_p(), (double)wave.func_177958_n() + 3.0, (double)wave.func_177956_o() + 2.0, (double)wave.func_177952_p() + 3.0);
            if (wave.isFirst()) {
                double addScale = this.field_70146_Z.nextDouble() * 0.75;
                box.func_72314_b(0.25 + addScale, 0.25 + addScale * 0.5, 0.25 + addScale);
            }
            DamageSource source = DamageSource.func_76358_a((LivingEntity)this).func_151518_m();
            for (Entity entity : this.field_70170_p.func_175674_a((Entity)this, box, EntityPredicates.field_188444_d.and(this::canHarm))) {
                entity.func_70097_a(source, wave.isFirst() ? (float)(9 + this.field_70146_Z.nextInt(4)) : (float)(6 + this.field_70146_Z.nextInt(3)));
                double x = entity.func_226277_ct_() - this.func_226277_ct_();
                double z = entity.func_226281_cx_() - this.func_226281_cx_();
                double d = Math.sqrt(x * x + z * z);
                entity.func_213293_j(x / d * 0.3, 0.04, z / d * 0.3);
                EntityUtil.sendPlayerVelocityPacket(entity);
                if (!(entity instanceof LivingEntity) || this.field_70146_Z.nextInt(5) != 0 || EntityUtil.canBlockDamageSource((LivingEntity)entity, source)) continue;
                ((LivingEntity)entity).func_195064_c(new EffectInstance(Effects.field_76438_s, 160, 1));
            }
        }
    }

    public AxisAlignedBB func_184177_bl() {
        return this.func_174813_aQ().func_186662_g(1.0);
    }

    protected boolean func_184228_n(Entity entityIn) {
        return false;
    }

    public boolean func_96092_aw() {
        return false;
    }

    protected void func_213371_e(LivingEntity livingEntity) {
        livingEntity.func_70108_f((Entity)this);
        livingEntity.field_70133_I = true;
    }

    public void func_70645_a(DamageSource cause) {
        if (!this.field_70170_p.field_72995_K) {
            this.deathCause = cause;
            this.func_130011_c((Entity)this.func_70643_av());
            if (this.field_70718_bc > 0) {
                this.field_70718_bc += 140;
            }
        }
    }

    protected void func_70609_aI() {
        if (this.func_70027_ad()) {
            ++this.vanishTime;
        } else if (this.vanishTime > 0) {
            --this.vanishTime;
        }
        if (this.field_70725_aQ <= 25 || !this.func_70027_ad() || this.field_70725_aQ >= 100) {
            ++this.field_70725_aQ;
        }
        if (this.field_70725_aQ >= 140) {
            this.field_70725_aQ = 0;
            this.vanishTime = 0;
            this.deathCause = null;
            if (!this.field_70170_p.field_72995_K) {
                this.setLives(this.getLives() - 1);
                if (this.func_110144_aD() != null) {
                    this.func_110144_aD().func_70604_c((LivingEntity)this);
                }
            }
            this.func_70606_j(Math.round(this.func_110138_aP() / 3.75f));
        }
        if (this.vanishTime >= 100 || this.getLives() <= 0 && this.field_70725_aQ > 25) {
            super.func_70645_a(this.deathCause != null ? this.deathCause : DamageSource.field_76377_j);
            for (int i = 0; i < 30; ++i) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_195594_a((IParticleData)(this.func_70027_ad() ? ParticleTypes.field_197631_x : ParticleTypes.field_197598_I), this.func_226282_d_(1.0), this.func_226279_cv_(), this.func_226287_g_(1.0), d0, d1, d2);
            }
            this.func_70106_y();
        }
    }

    public void func_174812_G() {
        super.func_174812_G();
        this.setLives(0);
    }

    private boolean canHarm(Entity entity) {
        return entity.func_200600_R() != EntityType.field_200725_aD && entity.func_200600_R() != EntityType.field_200727_aF && entity.func_200600_R() != EntityType.field_200763_C && entity.func_200600_R() != EntityType.field_204724_o && !(entity instanceof MutantZombieEntity);
    }

    public void func_70074_a(LivingEntity livingEntity) {
        if ((this.field_70170_p.func_175659_aa() == Difficulty.NORMAL && this.field_70146_Z.nextBoolean() || this.field_70170_p.func_175659_aa() == Difficulty.HARD) && livingEntity instanceof VillagerEntity) {
            VillagerEntity villagerentity = (VillagerEntity)livingEntity;
            ZombieVillagerEntity zombievillagerentity = (ZombieVillagerEntity)EntityType.field_200727_aF.func_200721_a(this.field_70170_p);
            zombievillagerentity.func_82149_j((Entity)villagerentity);
            villagerentity.func_70106_y();
            zombievillagerentity.func_213386_a((IWorld)this.field_70170_p, this.field_70170_p.func_175649_E(zombievillagerentity.func_233580_cy_()), SpawnReason.CONVERSION, (ILivingEntityData)new ZombieEntity.GroupData(false, true), (CompoundNBT)null);
            zombievillagerentity.func_213792_a(villagerentity.func_213700_eh());
            zombievillagerentity.func_223727_a((INBT)villagerentity.func_223722_es().func_234058_a_((DynamicOps)NBTDynamicOps.field_210820_a).getValue());
            zombievillagerentity.func_213790_g(villagerentity.func_213706_dY().func_222199_a());
            zombievillagerentity.func_213789_a(villagerentity.func_213708_dV());
            zombievillagerentity.func_82227_f(villagerentity.func_70631_g_());
            zombievillagerentity.func_94061_f(villagerentity.func_175446_cd());
            if (villagerentity.func_145818_k_()) {
                zombievillagerentity.func_200203_b(villagerentity.func_200201_e());
                zombievillagerentity.func_174805_g(villagerentity.func_174833_aM());
            }
            if (villagerentity.func_104002_bU()) {
                zombievillagerentity.func_110163_bv();
            }
            zombievillagerentity.func_184224_h(this.func_190530_aW());
            this.field_70170_p.func_217376_c((Entity)zombievillagerentity);
            if (!this.func_174814_R()) {
                this.field_70170_p.func_217378_a(null, 1026, this.func_233580_cy_(), 0);
            }
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("Lives", this.getLives());
        compound.func_74777_a("VanishTime", (short)this.vanishTime);
        if (!this.resurrectionList.isEmpty()) {
            ListNBT listnbt = new ListNBT();
            for (ZombieResurrection resurrection : this.resurrectionList) {
                CompoundNBT compound1 = NBTUtil.func_186859_a((BlockPos)resurrection);
                compound1.func_74768_a("Tick", resurrection.getTick());
                listnbt.add((Object)compound1);
            }
            compound.func_218657_a("Resurrections", (INBT)listnbt);
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("Lives")) {
            this.setLives(compound.func_74762_e("Lives"));
        }
        this.vanishTime = compound.func_74765_d("VanishTime");
        ListNBT listNBT = compound.func_150295_c("Resurrections", 10);
        for (int i = 0; i < listNBT.size(); ++i) {
            CompoundNBT compound1 = listNBT.func_150305_b(i);
            this.resurrectionList.add(i, new ZombieResurrection(this.field_70170_p, NBTUtil.func_186861_c((CompoundNBT)compound1), compound1.func_74762_e("Tick")));
        }
    }

    protected SoundEvent func_184639_G() {
        return MBSoundEvents.ENTITY_MUTANT_ZOMBIE_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return MBSoundEvents.ENTITY_MUTANT_ZOMBIE_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return MBSoundEvents.ENTITY_MUTANT_ZOMBIE_DEATH;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187939_hm, 0.15f, 1.0f);
    }

    static class ThrowAttackGoal
    extends AnimationGoal<MutantZombieEntity> {
        private LivingEntity attackTarget;
        private int finish = -1;

        public ThrowAttackGoal(MutantZombieEntity mob) {
            super(mob);
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        @Override
        protected Animation getAnimation() {
            return THROW_ANIMATION;
        }

        @Override
        public boolean func_75250_a() {
            this.attackTarget = ((MutantZombieEntity)this.mob).func_70638_az();
            return this.attackTarget != null && super.func_75250_a();
        }

        @Override
        public void func_75249_e() {
            super.func_75249_e();
            this.attackTarget.func_184210_p();
            double x = this.attackTarget.func_226277_ct_() - ((MutantZombieEntity)this.mob).func_226277_ct_();
            double z = this.attackTarget.func_226281_cx_() - ((MutantZombieEntity)this.mob).func_226281_cx_();
            double d = Math.sqrt(x * x + z * z);
            this.attackTarget.func_213293_j(x / d * (double)0.8f, (double)1.6f, z / d * (double)0.8f);
            EntityUtil.sendPlayerVelocityPacket((Entity)this.attackTarget);
        }

        @Override
        public boolean func_75253_b() {
            return super.func_75250_a() && this.finish < 10;
        }

        public void func_75246_d() {
            ((MutantZombieEntity)this.mob).field_70749_g.func_75651_a((Entity)this.attackTarget, 30.0f, 30.0f);
            if (((MutantZombieEntity)this.mob).animationTick == THROW_ANIMATION.getDuration()) {
                ((MutantZombieEntity)this.mob).field_213328_B = Vector3d.field_186680_a;
                double x = this.attackTarget.func_226277_ct_() - ((MutantZombieEntity)this.mob).func_226277_ct_();
                double y = this.attackTarget.func_226278_cu_() - ((MutantZombieEntity)this.mob).func_226278_cu_();
                double z = this.attackTarget.func_226281_cx_() - ((MutantZombieEntity)this.mob).func_226281_cx_();
                double d0 = Math.sqrt(x * x + y * y + z * z);
                ((MutantZombieEntity)this.mob).func_213293_j(x / d0 * (double)3.4f, y / d0 * (double)1.4f, z / d0 * (double)3.4f);
            } else if (((MutantZombieEntity)this.mob).animationTick > THROW_ANIMATION.getDuration()) {
                double d1 = ((MutantZombieEntity)this.mob).func_213311_cf() * 2.0f * ((MutantZombieEntity)this.mob).func_213311_cf() * 2.0f;
                double d2 = ((MutantZombieEntity)this.mob).func_70092_e(this.attackTarget.func_226277_ct_(), this.attackTarget.func_174813_aQ().field_72338_b, this.attackTarget.func_226281_cx_());
                if (d2 < d1 && !((MutantZombieEntity)this.mob).getThrowAttackHit()) {
                    ((MutantZombieEntity)this.mob).setThrowAttackHit(true);
                    DamageSource source = DamageSource.func_76358_a((LivingEntity)this.mob);
                    ((MutantZombieEntity)this.mob).func_70652_k((Entity)this.attackTarget);
                    double x = this.attackTarget.func_226277_ct_() - ((MutantZombieEntity)this.mob).func_226277_ct_();
                    double z = this.attackTarget.func_226281_cx_() - ((MutantZombieEntity)this.mob).func_226281_cx_();
                    double d = Math.sqrt(x * x + z * z);
                    this.attackTarget.func_213293_j(x / d * (double)0.6f, (double)-1.2f, z / d * (double)0.6f);
                    this.attackTarget.field_70172_ad = 10;
                    EntityUtil.sendPlayerVelocityPacket((Entity)this.attackTarget);
                    EntityUtil.stunRavager(this.attackTarget);
                    EntityUtil.disableShield(this.attackTarget, source, 150);
                    ((MutantZombieEntity)this.mob).func_184185_a(MBSoundEvents.ENTITY_MUTANT_ZOMBIE_GRUNT, 0.3f, 0.8f + ((MutantZombieEntity)this.mob).field_70146_Z.nextFloat() * 0.4f);
                }
                if (!(!((MutantZombieEntity)this.mob).field_70122_E && ((MutantZombieEntity)this.mob).func_213339_cH().func_204520_s().func_206888_e() || ((MutantZombieEntity)this.mob).isThrowAttackFinished())) {
                    this.finish = 0;
                    ((MutantZombieEntity)this.mob).setThrowAttackFinished(true);
                }
                if (this.finish >= 0) {
                    ++this.finish;
                }
            }
        }

        @Override
        public void func_75251_c() {
            super.func_75251_c();
            this.finish = -1;
            ((MutantZombieEntity)this.mob).setThrowAttackHit(false);
            ((MutantZombieEntity)this.mob).setThrowAttackFinished(false);
            this.attackTarget = null;
        }
    }

    static class RoarGoal
    extends AnimationGoal<MutantZombieEntity> {
        public RoarGoal(MutantZombieEntity mob) {
            super(mob);
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        @Override
        protected Animation getAnimation() {
            return ROAR_ANIMATION;
        }

        @Override
        public boolean func_75250_a() {
            return !((MutantZombieEntity)this.mob).isAnimationPlaying() && ((MutantZombieEntity)this.mob).func_70638_az() != null && ((MutantZombieEntity)this.mob).field_70122_E && ((MutantZombieEntity)this.mob).func_70068_e((Entity)((MutantZombieEntity)this.mob).func_70638_az()) > 16.0 && ((MutantZombieEntity)this.mob).field_70146_Z.nextFloat() * 100.0f < 0.35f;
        }

        @Override
        public void func_75249_e() {
            super.func_75249_e();
            ((MutantZombieEntity)this.mob).field_70708_bq = 0;
            ((MutantZombieEntity)this.mob).field_70757_a = -((MutantZombieEntity)this.mob).func_70627_aG();
        }

        public void func_75246_d() {
            if (((MutantZombieEntity)this.mob).animationTick < 75 && ((MutantZombieEntity)this.mob).func_70638_az() != null) {
                ((MutantZombieEntity)this.mob).field_70749_g.func_75651_a((Entity)((MutantZombieEntity)this.mob).func_70638_az(), 30.0f, 30.0f);
            }
            if (((MutantZombieEntity)this.mob).animationTick == 10) {
                ((MutantZombieEntity)this.mob).func_184185_a(MBSoundEvents.ENTITY_MUTANT_ZOMBIE_ROAR, 3.0f, 0.7f + ((MutantZombieEntity)this.mob).field_70146_Z.nextFloat() * 0.2f);
                for (Entity entity : ((MutantZombieEntity)this.mob).field_70170_p.func_175674_a((Entity)this.mob, ((MutantZombieEntity)this.mob).func_174813_aQ().func_72314_b(12.0, 8.0, 12.0), arg_0 -> RoarGoal.lambda$tick$0((MutantZombieEntity)this.mob, arg_0))) {
                    if (!(((MutantZombieEntity)this.mob).func_70068_e(entity) <= 196.0)) continue;
                    double x = entity.func_226277_ct_() - ((MutantZombieEntity)this.mob).func_226277_ct_();
                    double z = entity.func_226281_cx_() - ((MutantZombieEntity)this.mob).func_226281_cx_();
                    double d = Math.sqrt(x * x + z * z);
                    entity.func_213293_j(x / d * (double)0.7f, (double)0.3f, z / d * (double)0.7f);
                    entity.func_70097_a(DamageSource.func_76358_a((LivingEntity)this.mob).func_76348_h().func_151518_m(), (float)(2 + ((MutantZombieEntity)this.mob).field_70146_Z.nextInt(2)));
                    EntityUtil.sendPlayerVelocityPacket(entity);
                }
            }
            if (((MutantZombieEntity)this.mob).animationTick >= 20 && ((MutantZombieEntity)this.mob).animationTick < 80 && ((MutantZombieEntity)this.mob).animationTick % 10 == 0) {
                int x = MathHelper.func_76128_c((double)((MutantZombieEntity)this.mob).func_226277_ct_());
                int y = MathHelper.func_76128_c((double)((MutantZombieEntity)this.mob).func_174813_aQ().field_72338_b);
                int z = MathHelper.func_76128_c((double)((MutantZombieEntity)this.mob).func_226281_cx_());
                y = ZombieResurrection.getSuitableGround(((MutantZombieEntity)this.mob).field_70170_p, x += (1 + ((MutantZombieEntity)this.mob).field_70146_Z.nextInt(8)) * (((MutantZombieEntity)this.mob).field_70146_Z.nextBoolean() ? 1 : -1), y - 1, z += (1 + ((MutantZombieEntity)this.mob).field_70146_Z.nextInt(8)) * (((MutantZombieEntity)this.mob).field_70146_Z.nextBoolean() ? 1 : -1));
                if (y != -1) {
                    ((MutantZombieEntity)this.mob).resurrectionList.add(new ZombieResurrection(((MutantZombieEntity)this.mob).field_70170_p, x, y, z));
                }
            }
        }

        private static /* synthetic */ boolean lambda$tick$0(MutantZombieEntity rec$, Entity x$0) {
            return rec$.canHarm(x$0);
        }
    }

    static class SlamGroundGoal
    extends AnimationGoal<MutantZombieEntity> {
        private double dirX = -1.0;
        private double dirZ = -1.0;
        private LivingEntity attackTarget;

        public SlamGroundGoal(MutantZombieEntity mob) {
            super(mob);
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        @Override
        protected Animation getAnimation() {
            return SLAM_GROUND_ANIMATION;
        }

        @Override
        public boolean func_75250_a() {
            this.attackTarget = ((MutantZombieEntity)this.mob).func_70638_az();
            return this.attackTarget != null && super.func_75250_a();
        }

        @Override
        public void func_75249_e() {
            super.func_75249_e();
            ((MutantZombieEntity)this.mob).field_70757_a = -((MutantZombieEntity)this.mob).func_70627_aG();
            ((MutantZombieEntity)this.mob).func_184185_a(MBSoundEvents.ENTITY_MUTANT_ZOMBIE_ATTACK, 0.3f, 0.8f + ((MutantZombieEntity)this.mob).field_70146_Z.nextFloat() * 0.4f);
        }

        public void func_75246_d() {
            if (((MutantZombieEntity)this.mob).animationTick < 8) {
                ((MutantZombieEntity)this.mob).field_70749_g.func_75651_a((Entity)this.attackTarget, 30.0f, 30.0f);
            }
            if (((MutantZombieEntity)this.mob).animationTick == 8) {
                double x = this.attackTarget.func_226277_ct_() - ((MutantZombieEntity)this.mob).func_226277_ct_();
                double z = this.attackTarget.func_226281_cx_() - ((MutantZombieEntity)this.mob).func_226281_cx_();
                double d = Math.sqrt(x * x + z * z);
                this.dirX = x / d;
                this.dirZ = z / d;
            }
            if (((MutantZombieEntity)this.mob).animationTick == 12) {
                int x = MathHelper.func_76128_c((double)(((MutantZombieEntity)this.mob).func_226277_ct_() + this.dirX * 2.0));
                int y = MathHelper.func_76128_c((double)((MutantZombieEntity)this.mob).func_174813_aQ().field_72338_b);
                int z = MathHelper.func_76128_c((double)(((MutantZombieEntity)this.mob).func_226281_cx_() + this.dirZ * 2.0));
                int x1 = MathHelper.func_76128_c((double)(((MutantZombieEntity)this.mob).func_226277_ct_() + this.dirX * 8.0));
                int z1 = MathHelper.func_76128_c((double)(((MutantZombieEntity)this.mob).func_226281_cx_() + this.dirZ * 8.0));
                SeismicWave.createWaves(((MutantZombieEntity)this.mob).field_70170_p, ((MutantZombieEntity)this.mob).seismicWaveList, x, z, x1, z1, y);
                ((MutantZombieEntity)this.mob).field_70170_p.func_184148_a(null, (double)x, (double)y, (double)z, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 0.5f, 0.8f + ((MutantZombieEntity)this.mob).field_70146_Z.nextFloat() * 0.4f);
            }
        }

        @Override
        public void func_75251_c() {
            super.func_75251_c();
            this.dirX = -1.0;
            this.dirZ = -1.0;
            this.attackTarget = null;
        }
    }
}

