/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.item;

import chumbanotz.mutantbeasts.MutantBeasts;
import chumbanotz.mutantbeasts.client.MBItemStackTileEntityRenderer;
import chumbanotz.mutantbeasts.entity.mutant.MutantEndermanEntity;
import chumbanotz.mutantbeasts.entity.projectile.ThrowableBlockEntity;
import chumbanotz.mutantbeasts.particles.MBParticleTypes;
import chumbanotz.mutantbeasts.util.EntityUtil;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.enchantment.IVanishable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class EndersoulHandItem
extends Item
implements IVanishable {
    private final Multimap<Attribute, AttributeModifier> attributeModifiers;

    public EndersoulHandItem(Item.Properties properties) {
        super(properties.func_200918_c(240).setISTER(() -> MBItemStackTileEntityRenderer::new));
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Weapon modifier", 5.0, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)-2.4f, AttributeModifier.Operation.ADDITION));
        this.attributeModifiers = builder.build();
    }

    public boolean func_195938_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player) {
        return !player.func_184812_l_();
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.func_222118_a(1, attacker, livingEntity -> livingEntity.func_213361_c(EquipmentSlotType.MAINHAND));
        return true;
    }

    public int func_77619_b() {
        return 16;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(stack, enchantment) || enchantment.field_77351_y == EnchantmentType.WEAPON && enchantment != Enchantments.field_191530_r;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        if (context.func_225518_g_()) {
            return ActionResultType.FAIL;
        }
        if (!world.func_180495_p(pos).func_235714_a_(MutantBeasts.ENDERSOUL_HAND_HOLDABLE)) {
            return ActionResultType.FAIL;
        }
        if (!context.func_195999_j().func_175151_a(pos, context.func_196000_l(), context.func_195996_i())) {
            return ActionResultType.FAIL;
        }
        if (world.func_180495_p(pos).hasTileEntity()) {
            return ActionResultType.FAIL;
        }
        if (!world.field_72995_K) {
            world.func_217376_c((Entity)new ThrowableBlockEntity(world, context.func_195999_j(), world.func_180495_p(pos), pos));
            world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        }
        return ActionResultType.SUCCESS;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (!playerIn.func_213453_ef()) {
            return ActionResult.func_226250_c_((Object)stack);
        }
        RayTraceResult result = EndersoulHandItem.rayTrace(worldIn, playerIn, 128.0);
        if (result.func_216346_c() == RayTraceResult.Type.MISS) {
            playerIn.func_146105_b((ITextComponent)new TranslationTextComponent(this.func_77658_a() + ".teleport_failed"), true);
            return ActionResult.func_226251_d_((Object)stack);
        }
        if (result.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockPos pos = ((BlockRayTraceResult)result).func_216350_a();
            Direction direction = ((BlockRayTraceResult)result).func_216354_b();
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            BlockPos checkPos = new BlockPos(x += direction.func_82601_c(), (y += direction.func_96559_d()) - 1, z += direction.func_82599_e());
            if (!worldIn.func_175623_d(checkPos) || !worldIn.func_180495_p(checkPos).func_185904_a().func_76220_a()) {
                Block block1 = worldIn.func_180495_p(pos.func_177984_a()).func_177230_c();
                Block block2 = worldIn.func_180495_p(pos.func_177981_b(2)).func_177230_c();
                Block block3 = worldIn.func_180495_p(pos.func_177981_b(3)).func_177230_c();
                if (block1 == Blocks.field_150350_a) {
                    x = pos.func_177958_n();
                    y = pos.func_177956_o() + 1;
                    z = pos.func_177952_p();
                } else if (block2 == Blocks.field_150350_a) {
                    x = pos.func_177958_n();
                    y = pos.func_177956_o() + 2;
                    z = pos.func_177952_p();
                } else if (block3 == Blocks.field_150350_a) {
                    x = pos.func_177958_n();
                    y = pos.func_177956_o() + 3;
                    z = pos.func_177952_p();
                }
            }
            worldIn.func_184148_a(null, playerIn.func_226277_ct_(), playerIn.func_226278_cu_() + (double)playerIn.func_213302_cg() / 2.0, playerIn.func_226281_cx_(), SoundEvents.field_187544_ad, playerIn.func_184176_by(), 1.0f, 1.0f);
            playerIn.func_70634_a((double)x + 0.5, (double)y, (double)z + 0.5);
            playerIn.field_70143_R = 0.0f;
            if (!worldIn.field_72995_K) {
                MutantEndermanEntity.teleportAttack((LivingEntity)playerIn);
            }
            worldIn.func_184148_a(null, playerIn.func_226277_ct_(), playerIn.func_226278_cu_() + (double)playerIn.func_213302_cg() / 2.0, playerIn.func_226281_cx_(), SoundEvents.field_187544_ad, playerIn.func_184176_by(), 1.0f, 1.0f);
            EntityUtil.sendParticlePacket((Entity)playerIn, (IParticleData)MBParticleTypes.ENDERSOUL, 256);
            playerIn.func_184811_cZ().func_185145_a((Item)this, 40);
            playerIn.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
            stack.func_222118_a(4, (LivingEntity)playerIn, e -> e.func_213334_d(handIn));
            return ActionResult.func_226248_a_((Object)stack);
        }
        return ActionResult.func_226250_c_((Object)stack);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        return slot == EquipmentSlotType.MAINHAND ? this.attributeModifiers : super.getAttributeModifiers(slot, stack);
    }

    public static RayTraceResult rayTrace(World world, PlayerEntity player, double maxDist) {
        float pitch = player.field_70127_C + (player.field_70125_A - player.field_70127_C);
        float yaw = player.field_70126_B + (player.field_70177_z - player.field_70126_B);
        double x = player.field_70169_q + (player.func_226277_ct_() - player.field_70169_q);
        double y = player.field_70167_r + (player.func_226278_cu_() - player.field_70167_r) + (double)player.func_70047_e();
        double z = player.field_70166_s + (player.func_226281_cx_() - player.field_70166_s);
        Vector3d startVec = new Vector3d(x, y, z);
        float f3 = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float f6 = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        float f7 = f4 * f5;
        float f8 = f3 * f5;
        Vector3d endVec = startVec.func_72441_c((double)f7 * maxDist, (double)f6 * maxDist, (double)f8 * maxDist);
        return world.func_217299_a(new RayTraceContext(startVec, endVec, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)player));
    }
}

