/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.item;

import chumbanotz.mutantbeasts.util.SeismicWave;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.IVanishable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class HulkHammerItem
extends Item
implements IVanishable {
    public static final Map<UUID, List<SeismicWave>> WAVES = new HashMap<UUID, List<SeismicWave>>();
    private final Multimap<Attribute, AttributeModifier> attributeModifiers;

    public HulkHammerItem(Item.Properties properties) {
        super(properties.func_200918_c(64));
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Weapon modifier", 8.0, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Weapon modifier", -3.0, AttributeModifier.Operation.ADDITION));
        this.attributeModifiers = builder.build();
    }

    public boolean canDisableShield(ItemStack stack, ItemStack shield, LivingEntity entity, LivingEntity attacker) {
        return true;
    }

    public EquipmentSlotType getEquipmentSlot(ItemStack stack) {
        return EquipmentSlotType.MAINHAND;
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.func_222118_a(1, attacker, e -> e.func_213361_c(EquipmentSlotType.MAINHAND));
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (state.func_185887_b((IBlockReader)worldIn, pos) != 0.0f) {
            stack.func_222118_a(2, entityLiving, e -> e.func_213361_c(EquipmentSlotType.MAINHAND));
        }
        return true;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (HulkHammerItem.func_219968_a((World)worldIn, (PlayerEntity)playerIn, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.SOURCE_ONLY).func_216346_c() == RayTraceResult.Type.MISS) {
            return ActionResult.func_226250_c_((Object)stack);
        }
        if (!worldIn.field_72995_K) {
            ArrayList<SeismicWave> list = new ArrayList<SeismicWave>();
            Vector3d vec = playerIn.func_70040_Z();
            int x = MathHelper.func_76128_c((double)(playerIn.func_226277_ct_() + vec.field_72450_a * 1.0));
            int y = MathHelper.func_76128_c((double)playerIn.func_174813_aQ().field_72338_b);
            int z = MathHelper.func_76128_c((double)(playerIn.func_226281_cx_() + vec.field_72449_c * 1.0));
            int x1 = MathHelper.func_76128_c((double)(playerIn.func_226277_ct_() + vec.field_72450_a * 8.0));
            int z1 = MathHelper.func_76128_c((double)(playerIn.func_226281_cx_() + vec.field_72449_c * 8.0));
            SeismicWave.createWaves(worldIn, list, x, z, x1, z1, y);
            HulkHammerItem.addWave(playerIn.func_110124_au(), list);
        }
        worldIn.func_184148_a(playerIn, playerIn.func_226277_ct_(), playerIn.func_226278_cu_(), playerIn.func_226281_cx_(), SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 0.8f, 0.8f + playerIn.func_70681_au().nextFloat() * 0.4f);
        playerIn.func_184811_cZ().func_185145_a((Item)this, 25);
        playerIn.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
        stack.func_222118_a(1, (LivingEntity)playerIn, e -> e.func_213334_d(handIn));
        return ActionResult.func_233538_a_((Object)stack, (boolean)worldIn.field_72995_K);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        return slot == EquipmentSlotType.MAINHAND ? this.attributeModifiers : super.getAttributeModifiers(slot, stack);
    }

    public static void addWave(UUID name, List<SeismicWave> list) {
        List<SeismicWave> waves = null;
        Iterator<List<SeismicWave>> iterator = WAVES.values().iterator();
        while (iterator.hasNext()) {
            List<SeismicWave> waves1;
            waves = waves1 = iterator.next();
        }
        if (waves == null) {
            WAVES.put(name, list);
        } else {
            waves.addAll(list);
            WAVES.put(name, waves);
        }
    }
}

