/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.packet;

import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.network.NetworkEvent;

public class DeathTimePacket {
    private int entityId;
    private int deathTime;

    public DeathTimePacket(int entityId, int deathTime) {
        this.entityId = entityId;
        this.deathTime = deathTime;
    }

    void encode(PacketBuffer buffer) {
        buffer.writeInt(this.entityId);
        buffer.writeInt(this.deathTime);
    }

    DeathTimePacket(PacketBuffer buffer) {
        this.entityId = buffer.readInt();
        this.deathTime = buffer.readInt();
    }

    void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            Optional optionalWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(((NetworkEvent.Context)context.get()).getDirection().getReceptionSide());
            optionalWorld.filter(ClientWorld.class::isInstance).ifPresent(world -> {
                Entity entity = world.func_73045_a(this.entityId);
                if (entity instanceof LivingEntity) {
                    ((LivingEntity)entity).field_70725_aQ = this.deathTime;
                }
            });
        });
        context.get().setPacketHandled(true);
    }
}

