/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.packet;

import chumbanotz.mutantbeasts.particles.MBParticleTypes;
import chumbanotz.mutantbeasts.util.EntityUtil;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.network.NetworkEvent;

public class SpawnParticlePacket {
    private IParticleData particleData;
    private int entityId;
    private int amount;

    public SpawnParticlePacket(IParticleData particleData, int entityId, int amount) {
        this.particleData = particleData;
        this.entityId = entityId;
        this.amount = amount;
    }

    void encode(PacketBuffer buffer) {
        buffer.writeInt(Registry.field_212632_u.func_148757_b((Object)this.particleData.func_197554_b()));
        this.particleData.func_197553_a(buffer);
        buffer.writeInt(this.entityId);
        buffer.writeInt(this.amount);
    }

    SpawnParticlePacket(PacketBuffer buffer) {
        ParticleType particletype = (ParticleType)Registry.field_212632_u.func_148745_a(buffer.readInt());
        if (particletype == null) {
            particletype = ParticleTypes.field_197610_c;
        }
        this.particleData = this.readParticle(buffer, particletype);
        this.entityId = buffer.readInt();
        this.amount = buffer.readInt();
    }

    private <T extends IParticleData> T readParticle(PacketBuffer packetBuffer, ParticleType<T> particleType) {
        return (T)particleType.func_197571_g().func_197543_b(particleType, packetBuffer);
    }

    void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            Optional optionalWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(((NetworkEvent.Context)context.get()).getDirection().getReceptionSide());
            optionalWorld.filter(ClientWorld.class::isInstance).ifPresent(world -> {
                Entity entity = world.func_73045_a(this.entityId);
                if (entity != null) {
                    if (this.particleData == MBParticleTypes.ENDERSOUL) {
                        EntityUtil.spawnEndersoulParticles(entity, this.amount, 1.8f);
                    } else {
                        EntityUtil.spawnParticlesAtEntity(entity, this.particleData, this.amount);
                    }
                }
            });
        });
        context.get().setPacketHandled(true);
    }
}

