/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.pathfinding;

import net.minecraft.block.AbstractRailBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CampfireBlock;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.FluidState;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathType;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;

public class MBWalkNodeProcessor
extends WalkNodeProcessor {
    public PathNodeType func_186330_a(IBlockReader blockaccessIn, int x, int y, int z) {
        return MBWalkNodeProcessor.func_237231_a_(blockaccessIn, new BlockPos.Mutable(x, y, z));
    }

    public static PathNodeType func_237231_a_(IBlockReader blockReader, BlockPos.Mutable mutable) {
        int i = mutable.func_177958_n();
        int j = mutable.func_177956_o();
        int k = mutable.func_177952_p();
        PathNodeType pathnodetype = MBWalkNodeProcessor.getPathNodeTypeRaw(blockReader, (BlockPos)mutable);
        if (pathnodetype == PathNodeType.OPEN && j >= 1) {
            PathNodeType nodeBelow = MBWalkNodeProcessor.getPathNodeTypeRaw(blockReader, (BlockPos)mutable.func_181079_c(i, j - 1, k));
            PathNodeType pathNodeType = pathnodetype = nodeBelow != PathNodeType.WALKABLE && nodeBelow != PathNodeType.OPEN && nodeBelow != PathNodeType.WATER && nodeBelow != PathNodeType.LAVA ? PathNodeType.WALKABLE : PathNodeType.OPEN;
            if (nodeBelow == PathNodeType.DAMAGE_FIRE) {
                pathnodetype = PathNodeType.DAMAGE_FIRE;
            }
            if (nodeBelow == PathNodeType.DAMAGE_CACTUS) {
                pathnodetype = PathNodeType.DAMAGE_CACTUS;
            }
            if (nodeBelow == PathNodeType.DAMAGE_OTHER) {
                pathnodetype = PathNodeType.DAMAGE_OTHER;
            }
            if (nodeBelow == PathNodeType.DANGER_OTHER) {
                pathnodetype = PathNodeType.DANGER_OTHER;
            }
            if (nodeBelow == PathNodeType.STICKY_HONEY) {
                pathnodetype = PathNodeType.STICKY_HONEY;
            }
        }
        if (pathnodetype == PathNodeType.WALKABLE) {
            pathnodetype = MBWalkNodeProcessor.checkNeighbors(blockReader, mutable.func_181079_c(i, j, k), pathnodetype);
        }
        return pathnodetype;
    }

    public static PathNodeType checkNeighbors(IBlockReader blockReader, BlockPos.Mutable mutable, PathNodeType pathNodeType) {
        int i = mutable.func_177958_n();
        int j = mutable.func_177956_o();
        int k = mutable.func_177952_p();
        for (int l = -1; l <= 1; ++l) {
            for (int i1 = -1; i1 <= 1; ++i1) {
                for (int j1 = -1; j1 <= 1; ++j1) {
                    if (l == 0 && j1 == 0) continue;
                    mutable.func_181079_c(i + l, j + i1, k + j1);
                    PathNodeType rawNode = MBWalkNodeProcessor.getPathNodeTypeRaw(blockReader, (BlockPos)mutable);
                    if (rawNode == PathNodeType.DAMAGE_CACTUS) {
                        return PathNodeType.DANGER_CACTUS;
                    }
                    if (rawNode == PathNodeType.DANGER_OTHER || rawNode == PathNodeType.DAMAGE_OTHER) {
                        return PathNodeType.DANGER_OTHER;
                    }
                    if (rawNode == PathNodeType.DAMAGE_FIRE) {
                        return PathNodeType.DANGER_FIRE;
                    }
                    if (rawNode == PathNodeType.WATER) {
                        return PathNodeType.WATER_BORDER;
                    }
                    if (rawNode != PathNodeType.LAVA) continue;
                    return PathNodeType.LAVA;
                }
            }
        }
        return pathNodeType;
    }

    protected static PathNodeType getPathNodeTypeRaw(IBlockReader blockReader, BlockPos blockPos) {
        BlockState blockstate = blockReader.func_180495_p(blockPos);
        PathNodeType forgeType = blockstate.getAiPathNodeType(blockReader, blockPos);
        if (forgeType != null) {
            return forgeType;
        }
        Block block = blockstate.func_177230_c();
        if (blockstate.isAir(blockReader, blockPos)) {
            return PathNodeType.OPEN;
        }
        if (!blockstate.func_235714_a_((ITag)BlockTags.field_212185_E) && !blockstate.func_203425_a(Blocks.field_196651_dG)) {
            if (blockstate.func_203425_a(Blocks.field_150434_aF)) {
                return PathNodeType.DAMAGE_CACTUS;
            }
            if (blockstate.func_203425_a(Blocks.field_222434_lW) || blockstate.func_235714_a_((ITag)BlockTags.field_226154_ad_)) {
                return PathNodeType.DAMAGE_OTHER;
            }
            if (blockstate.func_203425_a(Blocks.field_196553_aF) || blockstate.func_203425_a(Blocks.field_150425_aM)) {
                return PathNodeType.DANGER_OTHER;
            }
            if (blockstate.func_203425_a(Blocks.field_226907_mc_) || blockstate.func_203425_a(Blocks.field_222420_lI)) {
                return PathNodeType.STICKY_HONEY;
            }
            if (blockstate.func_203425_a(Blocks.field_150375_by)) {
                return PathNodeType.COCOA;
            }
            if (blockstate.func_235714_a_((ITag)BlockTags.field_232872_am_) || blockstate.func_203425_a(Blocks.field_196814_hQ) || CampfireBlock.func_226915_i_((BlockState)blockstate)) {
                return PathNodeType.DAMAGE_FIRE;
            }
            if (DoorBlock.func_235492_h_((BlockState)blockstate) && !((Boolean)blockstate.func_177229_b((Property)DoorBlock.field_176519_b)).booleanValue()) {
                return PathNodeType.DOOR_WOOD_CLOSED;
            }
            if (block instanceof DoorBlock && blockstate.func_185904_a() == Material.field_151573_f && !((Boolean)blockstate.func_177229_b((Property)DoorBlock.field_176519_b)).booleanValue()) {
                return PathNodeType.DOOR_IRON_CLOSED;
            }
            if (block instanceof DoorBlock && ((Boolean)blockstate.func_177229_b((Property)DoorBlock.field_176519_b)).booleanValue()) {
                return PathNodeType.DOOR_OPEN;
            }
            if (block instanceof AbstractRailBlock) {
                return PathNodeType.RAIL;
            }
            if (block instanceof LeavesBlock) {
                return PathNodeType.LEAVES;
            }
            if (!(block.func_203417_a((ITag)BlockTags.field_219748_G) || block.func_203417_a((ITag)BlockTags.field_219757_z) || block instanceof FenceGateBlock && !((Boolean)blockstate.func_177229_b((Property)FenceGateBlock.field_176466_a)).booleanValue())) {
                FluidState fluidstate = blockReader.func_204610_c(blockPos);
                if (fluidstate.func_206884_a((ITag)FluidTags.field_206959_a)) {
                    return PathNodeType.WATER;
                }
                if (fluidstate.func_206884_a((ITag)FluidTags.field_206960_b)) {
                    return PathNodeType.LAVA;
                }
                return !blockstate.func_196957_g(blockReader, blockPos, PathType.LAND) ? PathNodeType.BLOCKED : PathNodeType.OPEN;
            }
            return PathNodeType.FENCE;
        }
        return PathNodeType.TRAPDOOR;
    }
}

